//%attributes = {}
//******************************************************************************
//Method: SDA_util_Wait
//Written by  cyril on 2/2/99
//
//Purpose: wait the specified number of ticks
//
//$1 - longint -number of ticks to wait
//Loop and allow the scheduler to process the posted key    
//4D seems to lose some post keys  if you don't have a delay 
//The docs indicate that the best way to do this is to do a 1 tick
//delay inside a loop
//
//Copyright 1999 Syncor Systems, Inc.
//******************************************************************************
C_LONGINT:C283($1; $lNbrOfTicksToWait)
C_LONGINT:C283($lCurrentProcess; $lCount; $lStart; $lStop)

$lNbrOfTicksToWait:=$1

$lCurrentProcess:=Current process:C322

For ($lCount; 1; $lNbrOfTicksToWait)
	$lStart:=Milliseconds:C459
	DELAY PROCESS:C323($lCurrentProcess; 1)
	$lStop:=Milliseconds:C459
	
	If (($lStop-$lStart)><>SDA_BUSY_TICK_LIMIT)  //a minimum tick wait is 16.67 milliseconds
		//if our system is taking more than 50, it is probably busy
		//and is likely to not have processed our posted key, so wait a bit more
		DELAY PROCESS:C323($lCurrentProcess; <>SDA_EXTRA_TICK_WAIT)
		
	End if   //      If (($lStop-$lStart)><>SDA_BUSY_TICK_LIMIT)  `a minimum tick wait is 16.67 
	
End for   //    For ($lCount;1;<>SDA_POST_KEY_DELAY)
