//%attributes = {"publishedSql":true}
//METHOD: ARR_Remove_Elements_from_End
//
//This removes a specified number of elements from the end of an array
//
//$1 is dereferenced array to make smaller
//$2 is number of elements to remove
//
//Deep Sky Technologies, Inc.
//http://www.deepskytech.com/
//================================================================================
_O_C_STRING:C293(32; $_dss_sMethodName)
$_dss_sMethodName:="ARR_Remove_Elements_from_End"
//--------------------------------------------------------------------------------
If (False:C215)  //methods and variables used indirectly herein (for Insider compatibility)
	//indirect_variables
	//indirect_method_calls
End if   //false  
//================================================================================
C_POINTER:C301($1; $_dss_pArray)
$_dss_pArray:=$1
C_LONGINT:C283($2; $_dss_lElementsToRemove)
$_dss_lElementsToRemove:=$2
//--------------------------------------------------------------------------------
//method_wide_constants_declarations
//--------------------------------------------------------------------------------
C_LONGINT:C283($_dss_lType)
C_LONGINT:C283($_dss_lSize)
//================================================================================
$_dss_lType:=Type:C295($_dss_pArray)
If ($_dss_lType=Is pointer:K8:14)
	$_dss_lType:=Type:C295($_dss_pArray->)
	If (_dss_ArrIs($_dss_lType))
		//check how many elements have been specified to be removed    
		Case of 
			: ($_dss_lElementsToRemove>0)  //more than one element being removed
				$_dss_lSize:=Size of array:C274($_dss_pArray->)
				//make sure not removing more than exists
				If (Not:C34($_dss_lElementsToRemove>$_dss_lSize))  //fine
					//remove the element(s)        
					DELETE FROM ARRAY:C228($_dss_pArray->; $_dss_lSize+1-$_dss_lElementsToRemove; $_dss_lElementsToRemove)
					//
				Else   //bad
					_err MESSAGE("Can't delete elements after end of array: "+String:C10($_dss_lElementsToRemove)+","+String:C10($_dss_lSize); $_dss_sMethodName; kFalse)
				End if 
				//
			: ($_dss_lElementsToRemove=0)  //no elements are to removed
				//do_nothing
				//
			: ($_dss_lElementsToRemove<0)  //negative number of elements specified to be removed        
				_err MESSAGE("Negative number of elements specified to be removed: "+String:C10($_dss_lElementsToRemove); $_dss_sMethodName; kFalse)
		End case 
		//
	Else   //ERROR
		_err MESSAGE_PARAMETER("$1 is not pointer to array"; "_dss_ARR_CLEAR"; kFalse)
	End if 
	//  
Else   //ERROR
	_err MESSAGE_PARAMETER("$1 is not pointer"; "_dss_ARR_CLEAR"; kFalse)
End if 
//eom
