//%attributes = {"publishedSql":true}
// Method: _http_DocSend
// 2003.01.10-02:39:31 / Pasi Mankinen
// © Copyright 2003 Manage Applications
// Purpose: 
// 
// ------------------------------------------------------------
If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStart; Current method name:C684)
End if 

If (False:C215)
	// Proc: HTTP_SndHtmlDoc(Socket;DocPath;Request)
	// This proc. sends a "static" file stored on disk.
	
	// added byte range serving support
	//----------
	//CQ-4/2/99 Added PDF "TEXT" file
	//CQ-7/4/99 Fixed $docLen (data fork size only instead of data+rsrc size)
	//----------
	//CQ-22/6/99 Added support for "gzip" Content-Encoding
End if 

C_LONGINT:C283($0; $_http_lDocLen; $1; $_http_lSocket; _tcp_lZipable; $_http_lOrigLen; $_http_lCached)  //set in _http_MimeType
C_LONGINT:C283($_http_lErr; $_http_lLastModified)
C_TEXT:C284($2; $_http_tFileName; $3; $_http_tMimeType; $_http_tDocType; $_http_tFolderSeparator)
C_TEXT:C284($_http_tModified; $_http_tLastModified; $_http_tEncoding; $_http_tSendHeader)
C_DATE:C307($_http_dLastModified)
C_TIME:C306($_http_hLastModified)

$_http_lSocket:=$1
$_http_tFileName:=$2
$_http_lCacheRow:=0

$_http_tFolderSeparator:=_doc FolderSeparator
$_http_tFileName:=Replace string:C233($_http_tFileName; "/"; $_http_tFolderSeparator)
If (False:C215)
	//problem when usin windows network paths like '\\Athlon\MGII_v67\WebFolder'
	$_http_tFileName:=Replace string:C233($_http_tFileName; $_http_tFolderSeparator+$_http_tFolderSeparator; $_http_tFolderSeparator)
End if 

If (<>_http_lCacheRowsInUse=kTrue)
	$_http_lCacheRow:=Find in array:C230(<>_http_atCacheFileName; $_http_tFileName)
	If ($_http_lCacheRow>1)
		
	End if 
End if 

If ($_http_lCacheRow<1)
	If (Test path name:C476($_http_tFileName)=Is a document:K24:1)
		$_http_lDocLen:=Get document size:C479($_http_tFileName)  // 7/4/99 - Data fork size only instead of file logical size (data+rsrc)
		
		$_http_lCached:=kFalse
		$_http_tModified:=""
		
		If (<>_tcp_lCachedInUse=kTrue)
			// ------ this has been added to provide HTTP client cache support ------
			_tcp_ tTcpPrsState:="modified time get"
			$_http_lModified:=_http_FileModified($_http_tFileName)
			
			If (($_http_tFileName#"@.dhtm") & ($3="@If-Modified-Since:@"))  //  the HTTP client uses a cache !
				// extract the modification date of its cached URL
				$_http_tLastModified:=Substring:C12($3; Position:C15("If-Modified-Since: "; $3)+19)
				$_http_tLastModified:=Substring:C12($_http_tLastModified; 1; Position:C15(ksCR; $_http_tLastModified; *)-1)
				TRACE:C157  //v11
				$_http_dLastModified:=Date:C102(_str Parse($_http_tLastModified; ksSpace; 1))
				$_http_hLastModified:=Time:C179(_str Parse($_http_tLastModified; ksSpace; 1))
				$_http_lLastModified:=_http_ DateTimeToSeconds($_http_dModified; $_http_hModified; 1)
				// convert it into GMT time
				If ($_http_lModified=$_http_lLastModified)
					//If (_http_ SecondsToRFC (_http_ RFCToSeconds ($_http_tLastModified);1)=$_http_tModified)
					$_http_lCached:=kTrue
				End if 
			End if 
		End if 
		
		// $_http_lCached:=kFalse   `disable cache
		_tcp_lZipable:=kFalse
		_tcp_ tTcpPrsState:="mime type get"
		$_http_tMimeType:=_http_MimeType($_http_tFileName)  //sets also _http_lZipable !!!
	Else 
		$_http_tMimeType:=""
	End if 
End if 

If ($_http_tMimeType#"")
	// we can send the file, so send the HTTP header
	If (($3="GET @") & ($_http_lCached=kTrue))
		$_http_lDocLen:=0
		_tcp_ tTcpPrsState:="304 not modified"
		$_http_lErr:=_http_HeaderSend($_http_lSocket; "304 not modified"+ksCRLF; ""; $_http_lDocLen)
	Else 
		If ((<>_tcp_lRangeSendInUse=kTrue) & (Position:C15(ksCRLF+"Range: bytes"; $3)#0))
			_tcp_ tTcpPrsState:="range send"
			$_http_lDocLen:=_http_RangeSend($_http_lSocket; $3; $_http_tMimeType; $_http_tModified; $_http_tFileName; $_http_lDocLen)
		Else 
			$_http_tEncoding:=""
			// CQ-22/6/99 - support gzip encoding for "zipable" files like HTML or text files
			If ((_tcp_lZipable=kTrue) & ($_http_lDocLen#0))
				_tcp_ tTcpPrsState:="gzip test"
				If (_http_HeaderExtract($3; "Accept-Encoding")="@gzip@")
					If (Test path name:C476($_http_tFileName+".gz")=Is a document:K24:1)
						// check that the gzip version is more recent than the original one
						
						//was:
						//  If (GetFileMSeconds ($_http_tFileName)<=GetFileMSeconds ($_http_tFileName+".
						//~gz"))     
						If (_http_FileModified($_http_tFileName)<=_http_FileModified($_http_tFileName+".gz"))
							$_http_tFileName:=$_http_tFileName+".gz"  // set new file path
							$_http_lOrigLen:=$_http_lDocLen
							$_http_lDocLen:=Get document size:C479($_http_tFileName)  //GetFileLogSize ($_http_tFileName)  ` set new doclen
							$_http_tEncoding:="x-gzip"  // Content-Encoding (see RFC#1945/10.3)
						End if 
					End if 
				End if 
			End if 
			
			C_BLOB:C604(_tcp_xBlob)
			SET BLOB SIZE:C606(_tcp_xBlob; 0)
			$_http_tSend:=""
			Case of 
				: (($_http_tMimeType="text/@") & (Position:C15(".dhtm"; $_http_tFileName)>0))  //& ($_http_lDocLen<<>_http_lMaxCachedFileSize))  ` use the File cache
					_tcp_ tTcpPrsState:="blob file get"
					_http_BLOB_FILE_GET(->_tcp_xBlob; $_http_tFileName)
					$_http_lDocLen:=BLOB size:C605(_tcp_xBlob)
			End case 
			
			_tcp_ tTcpPrsState:="200 OK"
			$_http_lErr:=_http_HeaderSend($_http_lSocket; "200 OK"; $_http_tMimeType; $_http_lDocLen)
			If ($_http_tModified#"")  // ------ added for cache support
				$_http_tSendHeader:="Last-Modified: "+$_http_tModified+ksCRLF
				$_http_lErr:=_tcp_ TextSend($_http_lSocket; $_http_tSendHeader)
				_http_tSendHeader:=_http_tSendHeader+$_http_tSendHeader
				If ($_http_lErr>0)
					_http_lDataSent:=_http_lDataSent+$_http_lErr
				End if 
			End if 
			If ($_http_tEncoding#"")
				$_http_tSendHeader:="Content-Encoding: "+$_http_tEncoding+ksCRLF+"X-GzipStats: original="+String:C10($_http_lOrigLen)+"; gzip="+String:C10($_http_lDocLen)+"; ratio="+String:C10(Int:C8(100*($_http_lOrigLen-$_http_lDocLen)/$_http_lOrigLen))+"%"+ksCRLF
				$_http_lErr:=_tcp_ TextSend($_http_lSocket; $_http_tSendHeader)
				_http_tSendHeader:=_http_tSendHeader+$_http_tSendHeader
				If ($_http_lErr>0)
					_http_lDataSent:=_http_lDataSent+$_http_lErr
				End if 
			End if 
			$_http_tSendHeader:=ksCRLF
			$_http_lErr:=_tcp_ TextSend($_http_lSocket; $_http_tSendHeader)  //flush send - end of HTTP answer header
			_http_tSendHeader:=_http_tSendHeader+$_http_tSendHeader
			
			If ($_http_lErr>0)
				_http_lDataSent:=_http_lDataSent+$_http_lErr
			End if 
			// send the file if method = GET (so that we also support method = HEAD)
			If ((($3="GET @") | ($3="POST @")) & ($_http_tFileName#""))  // method = GET -> send the file
				Case of 
					: (BLOB size:C605(_tcp_xBlob)>0)  // use blob   
						_tcp_ tTcpPrsState:="blob send"
						$_http_lErr:=_tcp_ BlobSend($_http_lSocket; ->_tcp_xBlob)  //;0;16)  `flush send, 
						If ($_http_lErr>0)
							_http_lDataSent:=_http_lDataSent+$_http_lErr
						End if 
						//convert Mac text to HTML, same as ITK_Text2HTML (text;0) 
						If ($_http_lErr<0)
							_tcp_TRACE(kTrue; "_tcp_ BlobSend error: "+String:C10($_http_lErr))
						End if 
					: (Length:C16($_http_tSend)>0)  // use the File cache
						_tcp_ tTcpPrsState:="text send"
						$_http_lErr:=_tcp_ FileSend($_http_lSocket; $_http_tSend)  //;0;0)  `flush send
						If ($_http_lErr>0)
							_http_lDataSent:=_http_lDataSent+$_http_lErr
						End if 
						If ($_http_lErr<0)
							_tcp_TRACE(kTrue; "_tcp_ FileSend error: "+String:C10($_http_lErr))
						End if 
					Else 
						_tcp_ tTcpPrsState:="file send: "+$_http_tFileName
						$_http_lErr:=_tcp_ FileSend($_http_lSocket; $_http_tFileName)
						If ($_http_lErr>0)
							_http_lDataSent:=_http_lDataSent+$_http_lErr
						End if 
						If ($_http_lErr<0)
							_tcp_TRACE(kTrue; "_tcp_ FileSend error: "+String:C10($_http_lErr))
						End if 
				End case 
			End if 
			// _web_TRACE (kFalse ;Current method name;$_http_tFileName)
		End if 
	End if 
	//$_http_lErr:=_tcp_ TextSend ($_http_lSocket;"")  // flush output buffer    
	//If ($_http_lErr>0)
	//_http_lDataSent:=_http_lDataSent+$_http_lErr
	//End if 
Else 
	// the file doesn't exist or is a unknown type
	_tcp_ tTcpPrsState:="404 ERR"
	$_http_tSend:="<html><head><title>Not Found</title></head><body><h1>Not Found</h1>"
	$_http_tSend:=$_http_tSend+"<p>404 Error: document does not exist.</p></body></html>"
	$_http_lDocLen:=Length:C16($_http_tSend)
	$_http_lErr:=_http_HeaderSend($_http_lSocket; "404 ERR"+ksCRLF; "text/html"; $_http_lDocLen)
	$_http_lErr:=_tcp_ TextSend($_http_lSocket; $_http_tSend)
	If ($_http_lErr>0)
		_http_lDataSent:=_http_lDataSent+$_http_lErr
	End if 
End if 

$0:=$_http_lDocLen

If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStop; Current method name:C684)
End if 