//%attributes = {"publishedSql":true}
// Method: _http_SERVER_LOG_SAVE
// 2003.04.03-01:05:34 / Pasi Mankinen
// © Copyright 2003 Manage Applications
// Purpose: 
// saves all http server activity to a standard NCSA combined format text file
// a general log contains all log entries, separate log files can be defined for
// selected URL paths ("HTTP_LogFile=..." entries in the [Param] table)
// ------------------------------------------------------------
_prs NEW_INIT

If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStart; Current method name:C684)
End if 

C_TEXT:C284($_tcp_msg; $_tcp_log; $_tcp_referer; $_tcp_log2File; $_tcp_log2Win; $_tcp_tDelimeter)
$_tcp_tDelimeter:=ksTab  //Char(255)


COMPILER__tcp_
COMPILER__http_

_tcp_ tTcpPrsState:="starting"
$_tcp_nextFlush:=Tickcount:C458

// load separate log file info
//QUERY(;="HTTP_LogFile=@")
ARRAY TEXT:C222($_tcp_atLogFile; 0)
//SELECTION TO ARRAY(;$_http_atLogFile)
ARRAY TEXT:C222($_tcp_atLogFolder; 0)
//SELECTION TO ARRAY(;$_http_atLogFolder)
ARRAY TEXT:C222($_tcp_atLogBuff; Size of array:C274($_tcp_atLogFile))
SORT ARRAY:C229($_tcp_atLogFolder; $_tcp_atLogFile; <)  // sort in reverse order to allow multiple level logs, ie: /fold1/fold2 and /fold1

<>_http_tLogFolder:=<>_http_tHttpFolder  //_doc LocalPath +"WebLog"
_tcp_ tTcpPrsState:="create log folder"
If (Test path name:C476(<>_http_tLogFolder)#Is a folder:K24:2)
	If (<>_http_tLogFolder#"")
		CREATE FOLDER:C475(<>_http_tLogFolder)
	End if 
End if 

_tcp_ tTcpPrsState:="wait messages"
$_tcp_log2File:=""
Repeat 
	
	// receive all log messages waiting
	// is there something to save in the log file ?  
	While (_msg_ Count(<>_tcp_lMsgPipeLogSave)>0)  // do we have incoming data to save in the log file ?
		$_tcp_msg:=_msg_ Receive(<>_tcp_lMsgPipeLogSave; kFalse)
		If ($_tcp_msg="")
			IDLE:C311
			_tcp_ tTcpPrsState:="no message to process"
		Else 
			
			_tcp_ tTcpPrsState:="process message"
			$_tcp_curDate:=_date Current(kFalse)
			$_tcp_curTime:=_time Current(kFalse)
			$_tcp_logFilePath:=<>_http_tLogFolder+<>_http_tFolderSeparator+"weblog_"+String:C10(Year of:C25($_tcp_curDate))+String:C10(Month of:C24($_tcp_curDate); "00")
			
			// separate the log entry and the http request header
			$_tcp_p:=Position:C15($_tcp_tDelimeter; $_tcp_msg; *)
			$_tcp_logData:=Substring:C12($_tcp_msg; 1; $_tcp_p-1)+ksCR  // +ksLF   `PM 3002-02-07
			// add LF (NCSA Combined is a Unix text file format)
			$_tcp_head:=Substring:C12($_tcp_msg; $_tcp_p+1)  // extract the original HTTP request header
			
			// update the log entry with data coming from the HTTP request header
			$_tcp_logData:=Replace string:C233($_tcp_logData; "<`AGENT`>"; ksQuoteDouble+_http_HeaderExtract($_tcp_head; "User-Agent")+ksQuoteDouble)  // User-Agent
			$_tcp_logData:=Replace string:C233($_tcp_logData; "<`REF`>"; ksQuoteDouble+_http_HeaderExtract($_tcp_head; "Referer")+ksQuoteDouble)  // Referer
			$_tcp_logData:=Replace string:C233($_tcp_logData; "<`REQ`>"; ksQuoteDouble+Substring:C12($_tcp_head; 1; Position:C15(ksCRLF; $_tcp_head)-1)+ksQuoteDouble)  // Requête
			// update the date/time info in the log entry with actual date/time info
			$_tcp_timeStamp:=_http_ DateTimeToRFC($_tcp_curDate; $_tcp_curTime; 1)  // GMT please
			If (Length:C16($_tcp_timeStamp)=28)  // CQ-1/7/97 Time info are fixed format in NCSA log files
				$_tcp_timeStamp:="[0"+Replace string:C233(Substring:C12($_tcp_timeStamp; 6; 10); " "; "/")+":"+Substring:C12($_tcp_timeStamp; 17; 14)+"]"
			Else 
				$_tcp_timeStamp:="["+Replace string:C233(Substring:C12($_tcp_timeStamp; 6; 11); " "; "/")+":"+Substring:C12($_tcp_timeStamp; 18; 14)+"]"
			End if 
			$_tcp_logData:=Replace string:C233($_tcp_logData; "<`TIME`>"; $_tcp_timeStamp)  // Timestamp
			// $_http_logData:=Replace string($_http_logData;ksCR ;ksCRLF )  `PM 3002-02-07
			// add log entry to separate logs
			For ($_tcp_i; 1; Size of array:C274($_tcp_atLogFile))
				$_tcp_logFolders:=$_tcp_atLogFolder{$_tcp_i}+ksCR  // CQ-3/12/96
				Repeat 
					$_tcp_logFolder:=Substring:C12($_tcp_logFolders; 1; Position:C15(ksCR; $_tcp_logFolders)-1)
					$_tcp_logFolders:=Substring:C12($_tcp_logFolders; Position:C15(ksCR; $_tcp_logFolders)+1)
					If (($_tcp_logFolder#"") & (Position:C15(" "+$_tcp_logFolder; $_tcp_msg)#0))
						$_tcp_atLogBuff{$_tcp_i}:=$_tcp_atLogBuff{$_tcp_i}+$_tcp_logData
						If (Length:C16($_tcp_atLogBuff{$_tcp_i})>8192)  // save if we have more than 8KB of data to log
							$_tcp_logFile:=$_tcp_logFilePath+"_"+Substring:C12($_tcp_atLogFile{$_tcp_i}; Position:C15("="; $_tcp_atLogFile{$_tcp_i})+1)+".txt"
							_doc APPEND($_tcp_logFile; ""; $_tcp_atLogBuff{$_tcp_i})
							If (OK=1)
								$_tcp_atLogBuff{$_tcp_i}:=""
							End if 
						End if 
						$_tcp_i:=999
						$_tcp_logFolder:=""
					End if 
				Until ($_tcp_logFolder="")
			End for 
			
			$_tcp_log2File:=$_tcp_log2File+$_tcp_logData  // add log entry to general log
		End if 
		
		If (Length:C16($_tcp_log2File)>4000)  // save if we have more than 4KBi of data to log
			$_tcp_logFile:=$_tcp_logFilePath+".log"  // general log filename = Laaaamm.log"
			
			_doc APPEND($_tcp_logFile; ""; $_tcp_log2File)
			If (OK=1)
				$_tcp_log2File:=""
			End if 
		End if 
	End while 
	
	
	If ((<>_tcp_lServerQuit=kTrue) | (Tickcount:C458>$_tcp_nextFlush))
		$_tcp_nextFlush:=Tickcount:C458+(30*60)  // next flush in 30s
		// save remaining data in general log file
		If ($_tcp_log2File#"")
			$_tcp_logFile:=$_tcp_logFilePath+".txt"
			_doc APPEND($_tcp_logFile; ""; $_tcp_log2File)
			If (OK=1)
				$_tcp_log2File:=""
			End if 
		End if 
		// save remaining data in separate log files
		For ($_tcp_i; 1; Size of array:C274($_tcp_atLogFile))
			If ($_tcp_atLogBuff{$_tcp_i}#"")
				$_tcp_logFile:=$_tcp_logFilePath+"_"+Substring:C12($_tcp_atLogFile{$_tcp_i}; Position:C15("="; $_tcp_atLogFile{$_tcp_i})+1)+".txt"
				_doc APPEND($_tcp_logFile; ""; $_tcp_atLogBuff{$_tcp_i})
				If (OK=1)
					$_tcp_atLogBuff{$_tcp_i}:=""
				End if 
			End if 
		End for 
		//reload separate log file info
		// QUERY(;="HTTP_LogFile=@")
		ARRAY TEXT:C222($_tcp_atLogFile; 0)
		// SELECTION TO ARRAY(;$_http_atLogFile)
		ARRAY TEXT:C222($_tcp_atLogFolder; 0)
		// SELECTION TO ARRAY(;$_http_atLogFolder)
		ARRAY TEXT:C222($_tcp_atLogBuff; Size of array:C274($_tcp_atLogFile))
		SORT ARRAY:C229($_tcp_atLogFolder; $_tcp_atLogFile; <)  // sort in reverse order to allow multiple level logs, ie: /fold1/fold2 and /fold1
	End if   // TickCount > $nextFlush ?
	
	If (<>_tcp_lServerQuit=kFalse)
		_tcp_ tTcpPrsState:="delay"
		If (<>_info_ fProfile)
			_info_ CALL_PROFILE(kStop; Current method name:C684)
		End if 
		DELAY PROCESS:C323(Current process:C322; 120)  // sleep for 2s
		If (<>_info_ fProfile)
			_info_ CALL_PROFILE(kStart; Current method name:C684)
		End if 
	End if 
Until ((<>_tcp_lServerQuit=kTrue) & (_msg_ Count(<>_tcp_lMsgPipeLogSave)<=0))
If ($_tcp_log2File#"")
	$_tcp_logFile:=$_tcp_logFilePath+".txt"
	_doc APPEND($_tcp_logFile; ""; $_tcp_log2File)
	If (OK=1)
		$_tcp_log2File:=""
	End if 
End if 
_tcp_ tTcpPrsState:="quit"
<>_tcp_lLogSavePrs:=0

If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStop; Current method name:C684)
End if 

_prs_ NEW_QUIT