//%attributes = {"publishedSql":true}
//*==============================================================================
//Methode projet : API_Tokenize
// Public
//
//DESCRIPTION :
// This function tokenizes a text (containing 4D code) into a CC4D Blob
//
// PARAMETRES :
//  $0 (LONGINT)  <= error code
//  $1 (TEXT) => detokenized code
//  $2 (POINTEUR) => blob pointer, tokenized code (modified)
//  
//NOTES : 
//
//EXAMPLE : 
//  API_Tokenize
//  
//CREATION : Bruno LEGAY (BLE) - 12/04/07, 09:09:10 - v1.00.00
//*===============================================================================

C_LONGINT:C283($0)  //error code
C_TEXT:C284($1)  //detokenized code
C_POINTER:C301($2)  //tokenized code blob pointer

C_LONGINT:C283($vl_errCode)  //error code
C_TEXT:C284($vt_tokenizedCode)  //detokenized code
C_POINTER:C301($vp_tokenizedCodeBlobPtr)  //tokenized code blob pointer

$vl_errCode:=0
If (Count parameters:C259>1)
	$vt_tokenizedCode:=$1
	$vp_tokenizedCodeBlobPtr:=$2
	
	If (Type:C295($vp_tokenizedCodeBlobPtr->)=Is BLOB:K8:12)
		
		C_BLOB:C604($vx_tempBlob)
		SET BLOB SIZE:C606($vx_tempBlob; 0)
		// v19: $vl_errCode:=API Tokenize($vt_tokenizedCode; $vx_tempBlob)
		If ($vl_errCode=0)
			$vp_tokenizedCodeBlobPtr->:=$vx_tempBlob
		Else 
			SET BLOB SIZE:C606($vp_tokenizedCodeBlobPtr->; 0)
		End if 
		SET BLOB SIZE:C606($vx_tempBlob; 0)
		
	Else 
		_info_ ALERT(Current method name:C684+" : $2 is not a pointer to a blob variable !")
	End if 
	
Else 
	_info_ ALERT(Current method name:C684+" : not enough parameters !")
End if 
$0:=$vl_errCode
