//%attributes = {}
// ----------------------------------------------------
// User name (OS): pate
// Date and time: 17.10.08, 23:26:23
// ----------------------------------------------------
// Method: _mb4d_ResourceGet
// Description
// 
//
// Parameters
// ----------------------------------------------------

//*==============================================================================
//Project method : API_Resource_Get
// Public
//
//DESCRIPTION :
// This function is a wrapper on "API Get Resource" 
//
//PARAMETRES :
//  $0 (LONGINT)  <= error code (0 if everything went fine)
//  $1 (STRING 4) => resource type
//  $2 (LONGINT) => resource id
//  $3 (POINTEUR) => pointer to a blob (modified)
//  
//NOTES : 
//
//EXAMPLE : 
//  API_Resource_Get
//  
//CREATION : Bruno LEGAY (BLE) - 29/03/07, 08:19:59 - v1.00.00
//*===============================================================================

C_LONGINT:C283($0)  //Err Code
_O_C_STRING:C293(4; $1)  //Resource type
C_LONGINT:C283($2)  //Resource id
C_POINTER:C301($3)  //Pointer to a blob (modified)

C_LONGINT:C283($vl_errCode)  //Err Code
_O_C_STRING:C293(4; $va_resType)  //Resource type
C_LONGINT:C283($vl_resId)  //Resource id
C_POINTER:C301($vp_resBlobPtr)  //Pointer to a blob (modified)
C_BLOB:C604($vx_tempBlob)

$vl_errCode:=0

$va_resType:=$1
$vl_resId:=$2
$vp_resBlobPtr:=$3

If (Type:C295($vp_resBlobPtr->)=Is BLOB:K8:12)
	
	//Using API_Pack
	//We are using a local blob to get API Get Resource to work
	
	//Using a deferenced blob pointer does not work (Bruno LEGAY 30/03/2007)
	//$vl_errCode:=API Get Resource ($va_resType;$vl_resId;$vp_resBlobPtr->;$ve_docRef)
	
	SET BLOB SIZE:C606($vx_tempBlob; 0)
	
	//This is the current structure
	// v19: $vl_errCode:=API Get Resource($va_resType; $vl_resId; $vx_tempBlob)
	//_mz_svn__debug (Current method name+" - getting resource - blob : "+String(BLOB size($vx_tempBlob))+" byte(s) - errCode : "+String($vl_errCode))
	
	$vp_resBlobPtr->:=$vx_tempBlob
	
	SET BLOB SIZE:C606($vx_tempBlob; 0)
	
Else 
	_info_ ALERT(Current method name:C684+" : $3 is not a pointer to a blob")
End if 

$0:=$vl_errCode
