//%attributes = {}
//*==============================================================================
//Project method : API_Resource_Set
// Public
//
//DESCRIPTION :
// This function is a wrapper on "API Set Resource" 
//
//PARAMETRES :
//  $0 (LONGINT)  <= error code (0 if everything went fine)
//  $1 (STRING 4) => resource type
//  $2 (POINTEUR) => resource id (-1 for a new ressource, a new unique id will be returned)
//  $3 (POINTEUR) => pointer to a blob (modified)
//  $4 (TEXT) => resource name
//  $5 (INTEGER) => 4D structure file reference (returned by "API_ResFile_Open")
//  optionnal, default, the current structure
//  
//NOTES : 
//
//EXAMPLE : 
//  API_Resource_Get
//  
//CREATION : Bruno LEGAY (BLE) - 29/03/07, 08:19:59 - v1.00.00
//*===============================================================================

C_LONGINT:C283($0)  //Err Code
_O_C_STRING:C293(4; $1)  //Resource type
C_POINTER:C301($2)  //Resource id
C_POINTER:C301($3)  //Pointer to a blob (modified)
C_TEXT:C284($4)  //resource name
_O_C_INTEGER:C282($5)  //4D structure file reference

C_LONGINT:C283($vl_errCode)  //Err Code
_O_C_STRING:C293(4; $va_resType)  //Resource type
C_POINTER:C301($vl_resId_Ptr)  //Resource id
C_POINTER:C301($vp_resBlobPtr)  //Pointer to a blob (modified)
C_TEXT:C284($vt_resourceName)  //resource name
_O_C_INTEGER:C282($ve_docRef)  //4D structure file reference

$vl_errCode:=0
C_LONGINT:C283($vl_nbParam)
$vl_nbParam:=Count parameters:C259

If ($vl_nbParam>2)
	$va_resType:=$1
	$vl_resId_Ptr:=$2
	$vp_resBlobPtr:=$3
	
	Case of 
		: ($vl_nbParam=3)
			$vt_resourceName:=""
			//$ve_docRef:=
			
		: ($vl_nbParam=4)
			$vt_resourceName:=$4
			//$ve_docRef:=
			
			
		Else 
			$vt_resourceName:=$4
			$ve_docRef:=$5
	End case 
	
	Case of 
		: (Type:C295($vl_resId_Ptr->)#Is longint:K8:6)
			_info_ ALERT(Current method name:C684+" : $2 is not a pointer to a longint")
			
		: (Type:C295($vp_resBlobPtr->)#Is BLOB:K8:12)
			_info_ ALERT(Current method name:C684+" : $3 is not a pointer to a blob")
			
		Else 
			
			//Using API_Pack
			//We are using a local blob to get API Get Resource to work
			
			//Using a deferenced blob pointer does not work (Bruno LEGAY 30/03/2007)
			//$vl_errCode:=API Get Resource ($va_resType;$vl_resId;$vp_resBlobPtr->;$ve_docRef)
			
			C_TEXT:C284($vt_debugNew)
			If ($vl_resId_Ptr->=-1)
				//This is a  new ressource
				$vt_debugNew:="new "
			Else 
				$vt_debugNew:=""
			End if 
			
			_err LOG(Current method name:C684+" - setting "+$vt_debugNew+"resource - type : "+ksQuoteDouble+$va_resType+ksQuoteDouble+" - id : "+String:C10($vl_resId_Ptr->)+" - blob : "+String:C10(BLOB size:C605($vp_resBlobPtr->))+" - docRef : "+String:C10($ve_docRef); Current method name:C684)
			
			C_BLOB:C604($vx_tempBlob)
			SET BLOB SIZE:C606($vx_tempBlob; 0)
			$vx_tempBlob:=$vp_resBlobPtr->
			
			C_LONGINT:C283($vl_resID)
			$vl_resID:=$vl_resId_Ptr->
			
			Case of 
				: (($vl_nbParam=3) | ($vl_nbParam=4))
					// v19: $vl_errCode:=API Set Resource($va_resType; $vl_resID; $vt_resourceName; $vx_tempBlob)
					
				: ($ve_docRef=-1)  //This is the current structure
					// v19: $vl_errCode:=API Set Resource($va_resType; $vl_resID; $vt_resourceName; $vx_tempBlob)
					
				Else 
					// v19: $vl_errCode:=API Set Resource($va_resType; $vl_resID; $vt_resourceName; $vx_tempBlob; $ve_docRef)
					
			End case 
			
			$vl_resId_Ptr->:=$vl_resID
			$vp_resBlobPtr->:=$vx_tempBlob
			SET BLOB SIZE:C606($vx_tempBlob; 0)
			
			_err LOG(Current method name:C684+" - setting "+$vt_debugNew+"resource - type : "+ksQuoteDouble+$va_resType+ksQuoteDouble+" - id : "+String:C10($vl_resId_Ptr->)+" - blob : "+String:C10(BLOB size:C605($vp_resBlobPtr->))+" byte(s) - errCode : "+String:C10($vl_errCode); Current method name:C684)
			
	End case 
	
Else 
	_info_ ALERT(Current method name:C684+" : not enough parameter")
End if 
$0:=$vl_errCode
