//%attributes = {}
//_prli_HostFormMethod({->ReturnFromPixel};{->ReturnToPixel};{ReturnPageNumber})
//    ->PrintingAreaName

//Part of the PrintTwist(tm) component by Business Brothers, Inc.
//Written by Tony Ringsmuth

//This method MUST be called within the host form method of the
//   host form for the report.
//----------------------------------------------------------------
//FUNCTION
//Get the pixel coordinates of each of the configured print areas.
//Each print area must be a rectangle object on the form.  Put the "Name" of the
//  print area as the box object name.
//----------------------------------------------------------------
//PARAMETERS
//$0 returns a string that describes the area of your host form that is currently
//   being printed.

//$0 Returns one of the following values:
//  TestPrint:  When printing an initial test print: zero pixels will be printed.
//  Header:      The general page header: to be printed on each page of the report
//  Header_1:  Any detail space between the bottom of the page header and the
//      top of PrintArea1.
//  AfterArea_{AreaRefString_X}: Any space between PrintAreaX and PrintAreaX+1.
//  Break_0:    Space after the end of the final print area, down to the top of th
//      page footer.
//  Footer:      The footer area to be printed on each page


//{$1}: Pointer to a numeric datatype: optional: 
//    $1-> Returns the vertical print starting coordinate

//{$2}: Pointer to a numeric datatype: optional: 
//    $2-> Returns the vertical print ending coordinate

//{$3}: Pointer to a numeric datatype: optional: 
//    $2-> Returns the current printing page number


//When in Dialog command, we should have an "ON Load" event
//When in Print form command, we should have an "On Printing Detil" event.

//----------------------------------------------------------------
//REVISION HISTORY
//Rev: 07/27/07: Allow $1, $2, $3 to be NIL
//Rev: 03/11/05: Return Page number ($3)
//Rev: 02/25/05: Improved documentation
//----------------------------------------------------------------
C_TEXT:C284($0)
C_BOOLEAN:C305(_prli_TestPrintFormComplete)
C_LONGINT:C283($_prli_i)
C_POINTER:C301($1; $2; $3)


If (Not:C34(_prli_TestPrintFormComplete))
	For ($_prli_i; 1; Size of array:C274(_prli_aAreaName))
		If (Length:C16(_prli_aAreaName{$_prli_i})>0)
			If (_prli_aAreaRightCoord{$_prli_i}=0)
				OBJECT GET COORDINATES:C663(*; _prli_aAreaName{$_prli_i}; _prli_aAreaLeftCoord{$_prli_i}; _prli_aAreaTopCoord{$_prli_i}; _prli_aAreaRightCoord{$_prli_i}; _prli_aAreaBottomCoord{$_prli_i})
				
				If (_prli_aAreaRightCoord{$_prli_i}>=_prli_iPageWidth)
					_prli_aAreaRightCoord{$_prli_i}:=_prli_iPageWidth-1
				End if 
				
				If (_prli_aAreaBottomCoord{$_prli_i}>_prli_iPageHeight)
					_prli_aAreaBottomCoord{$_prli_i}:=_prli_iPageHeight
				End if 
				
			End if 
		End if 
	End for 
	
	CANCEL:C270  //We are in a dialog: Cancel out
	_prli_TestPrintFormComplete:=True:C214
End if 

If (Form event code:C388#On Printing Detail:K2:18)
	//Try to protect against accidentally ending up in a dialog of a printing form.
	//  Maybe this could happen on our "Test Print" run where we call this
	//   form via the Dialog command.  
	CANCEL:C270
End if 

For ($_prli_i; 1; Size of array:C274(_prli_aAreaName))
	If (Length:C16(_prli_aAreaName{$_prli_i})>0)
		OBJECT SET VISIBLE:C603(*; _prli_aAreaName{$_prli_i}; False:C215)
	End if 
End for 

If (Count parameters:C259>0)
	If (Not:C34(Is nil pointer:C315($1)))
		$1->:=_prli_VPrintFrom
	End if 
End if 
If (Count parameters:C259>1)
	If (Not:C34(Is nil pointer:C315($2)))
		$2->:=_prli_VPrintTo
	End if 
End if 
If (Count parameters:C259>2)
	If (Not:C34(Is nil pointer:C315($3)))
		$3->:=_prli_iPrintingPage
	End if 
End if 
$0:=_prli_PrintFormCommand
