//%attributes = {}
//_prli_Print({Opts})

//Part of the PrintTwist(tm) component by Business Brothers, Inc.
//Written by Tony Ringsmuth

//In the use of the Print Form command using the new Print Section feature
//  released in 6.8.1, be aware of the fact that printing prints:
//  FROM AND INCLUDING the From line,
//  UPTO BUT NOT INCLUDING the To line.

//Rev: 11/09/07: Fixed bug with _prli_SetFirstHiddenColumn
//Rev: 11/01/07: Version 11 Compatability
//Rev: 05/14/07: Moved the actual sorting to here.
//Rev: 11/04/04: 1.1.8
//Rev: 02/12/04: Bug fix in user-abort
//Rev: 02/05/04: Better handle a user-abort
//Rev: 09/22/03: Fixed a bug in the clearing of arrays
//Rev: 08/27/03: Fixed a bug in the clearing of arrays


C_LONGINT:C283($1; $_prli_opts)
C_POINTER:C301(_prli_pHostFormTable; <>_prli_pObjectsFormTable)
C_TEXT:C284(_prli_HostFormName; _prli_ObjectsFormName)
C_LONGINT:C283(_prli_iPageHeight; _prli_iPageWidth; _prli_iPrintingRow; _prli_iAreaWidth; _prli_iRowCount; _prli_iRowsPrintedThisPage; _prli_iPrintingPage; _prli_iTotalPageCount; _prli_iGetPrintedHeight)
C_LONGINT:C283(_prli_iDCText2ArrayAlert)


_prli_iDCText2ArrayAlert:=0

$_prli_opts:=0
If (Count parameters:C259>0)
	$_prli_opts:=$1
End if 
$_prli_SizeToZeroAfterPrint:=($_prli_opts ?? 0)  //+1
$_prli_DontIssuePageBreakAtEnd:=($_prli_opts ?? 1)  //+2

C_LONGINT:C283(_prli_iCountPagesDontPrint; $_prli_CountPagesDone)
$_prli_CountPagesDone:=_prli_iCountPagesDontPrint
_prli_iCountPagesDontPrint:=Num:C11($_prli_opts ?? 2)  //+4
//
If (Application version:C493>="1100")
	C_POINTER:C301($_prli_pNil)
	<>_prli_pObjectsFormTable:=$_prli_pNil  //in version, we use the "Project Forms" area.  
Else 
	<>_prli_pObjectsFormTable:=->[_Preference:1]  //[_prli_Form]
End if 

//See Also: _prli_FormMethod

$_prli_NoAreasDefined:=False:C215
Case of 
	: (Type:C295(_prli_aAreaTopCoord)=Is undefined:K8:13)
		$_prli_NoAreasDefined:=True:C214
	: (Size of array:C274(_prli_aAreaTopCoord)=0)
		$_prli_NoAreasDefined:=True:C214
End case 

_prli_iTotalPageCount:=0
_prli_iGetPrintedHeight:=0

If ($_prli_NoAreasDefined)
	BEEP:C151
	_info_ ALERT(Current method name:C684+" was called prior to any calls to _prli_SetArraysNam.")
Else 
	_prli_UserCancelPrint:=False:C215
	_prli_iPrintingPage:=0
	$_prli_PrevErrorMethod:=Method called on error:C704
	C_LONGINT:C283($_prli_SpecialOpts; $_prli_TickBegin; $_prli_TickEnd)
	$_prli_SpecialOpts:=0
	If (Macintosh option down:C545 & Shift down:C543)
		$_prli_SpecialOpts:=1
	End if 
	
	$_prli_TickBegin:=Tickcount:C458  //Let's time this.
	
	
	C_LONGINT:C283(_prli_RightSideVertLineAdd; _prli_BotSideHorizLineAdd)
	_prli_RightSideVertLineAdd:=1  //When printing Horiz lines, the right side must be 1 pix lower than the left.
	_prli_BotSideHorizLineAdd:=1  //When printing Vert lines, the bottom side must be 1 pix right of the top.
	
	//If there were any areas configured as a PrintList Wrapper, remove them, or
	//  else they will end up printing here again.
	For ($_prli_iAreaCtr; Size of array:C274(_prli_aRunAsWrapper); 1; -1)
		If (_prli_aRunAsWrapper{$_prli_iAreaCtr})
			For ($_prli_iGroupArrayCtr; 1; Size of array:C274(_prli_aGroup))
				$_prli_Ptr:=_prli_aGroup{$_prli_iGroupArrayCtr}
				DELETE FROM ARRAY:C228($_prli_Ptr->; $_prli_iAreaCtr)
			End for 
		End if 
	End for 
	
	
	GET PRINTABLE AREA:C703(_prli_iPageHeight; _prli_iPageWidth)
	$_prli_iOriginalPageHeight:=_prli_iPageHeight
	_prli_iPrintingRow:=0
	
	C_LONGINT:C283(_prli_iPlatform)
	_O_PLATFORM PROPERTIES:C365(_prli_iPlatform)
	
	_prli_AreaRef:=-1
	_prli_iRowsPrintedThisPage:=0
	
	<>_prli_tBaseVarName:=_prli_Util_PtrName(->_prli_Var1)  //This code allows us to safely rename the form vars with insider, while still
	<>_prli_tBaseVarName:=Substring:C12(<>_prli_tBaseVarName; 1; Length:C16(<>_prli_tBaseVarName)-1)  //  using Get Pointer.
	
	If (Find in array:C230(_prli_aAreaRightCoord; 0)>-1)  //Is there any print area that has not had it's coordinates explicitly configured?
		//See Also: _prli_FormMethod  
		//The purpose of the following code is that we need to get "inside" the host print
		//  form to detect the coordinates of any _prli_Print areas that the developer has
		//   not explicitly passed coordinates in _prli_GetAreaRef.
		If (Length:C16(_prli_HostFormName)>0)
			If (_prli_iCountPagesDontPrint=0)
				_prli_Util_PrintForm(_prli_pHostFormTable; _prli_HostFormName; 0; 0; 0; "TestPrint")  //A test print, to get object coordinates: Print zero size.
			Else 
				_prli_VPrintFrom:=0
				_prli_VPrintTo:=0
				_prli_PrintFormCommand:="TestPrint"
				DIALOG:C40(_prli_pHostFormTable->; _prli_HostFormName)  //See Also: _prli_HostFormMethod
			End if 
			
		Else 
			
		End if 
	End if 
	_prli_TestPrintFormComplete:=True:C214
	_prli_iPrintingPage:=1
	
	If (True:C214)  //11/01/2007
		COPY ARRAY:C226(_prli_alAreaRef; $_prli_aSortedArea_AreaRef)
		COPY ARRAY:C226(_prli_aAreaTopCoord; $_prli_aSortedArea_TopCoordinat)
		SORT ARRAY:C229($_prli_aSortedArea_TopCoordinat; $_prli_aSortedArea_AreaRef)  //Sort the areas in order of their position on the form
		
	Else 
		If (Size of array:C274(_prli_aAreaTopCoord)>0)
			_prli_Util_SortArraysGroup(->_prli_aGroup; 0; ">"; ->_prli_aAreaTopCoord)  //Sort the areas in order of their position on the form
		End if 
	End if 
	
	If (_prli_iFormHdrCoord>0) & (Length:C16(_prli_HostFormName)>0)
		_prli_Util_PrintForm(_prli_pHostFormTable; _prli_HostFormName; 0; _prli_iFormHdrCoord; _prli_iCountPagesDontPrint; "Header")  //Print the header
	End if 
	
	If ((_prli_aAreaTopCoord{1}-_prli_iFormHdrCoord)>0) & (Length:C16(_prli_HostFormName)>0)
		_prli_Util_PrintForm(_prli_pHostFormTable; _prli_HostFormName; _prli_iFormHdrCoord; _prli_aAreaTopCoord{1}; _prli_iCountPagesDontPrint; "Header_1")  //Print detail area above first PT Area
	End if 
	
	ARRAY INTEGER:C220(_prli_aRowPreHeight; Size of array:C274(_prli_alAreaRef); 0)
	ARRAY INTEGER:C220(_prli_aRowHeight; Size of array:C274(_prli_alAreaRef); 0)
	ARRAY INTEGER:C220(_prli_aRowPostHeight; Size of array:C274(_prli_alAreaRef); 0)
	
	For ($_prli_AreaCtr; 1; Size of array:C274(_prli_alAreaRef))
		_prli_iFindArea:=Find in array:C230(_prli_alAreaRef; $_prli_aSortedArea_AreaRef{$_prli_AreaCtr})
		_prli_AreaRef:=_prli_alAreaRef{_prli_iFindArea}
		
		If (_prli_aAreaBottomCoord{_prli_iFindArea}=0) & (_prli_aAreaRightCoord{_prli_iFindArea}=0)
			$_prli_Err:="PrintTwist Developer Alert: You are attempting a _prli_Print job "
			$_prli_Err:=$_prli_Err+"without having specified the area coordinates using _prli_GetAreaRef, "
			$_prli_Err:=$_prli_Err+"or referencing the method _prli_HostFormMethod within your host form."+Char:C90(13)
			$_prli_Err:=$_prli_Err+"You must do one or both of these things."+Char:C90(13)
			$_prli_Err:=$_prli_Err+"The easiest solution for this is to call the method '_prli_HostFormMethod' "+"from your host form method."+Char:C90(13)
			$_prli_Err:=$_prli_Err+"Area Name: "+_prli_aAreaName{_prli_iFindArea}+Char:C90(13)
			$_prli_Err:=$_prli_Err+"Host Table: "+Table name:C256(_prli_pHostFormTable)+Char:C90(13)
			$_prli_Err:=$_prli_Err+"Form Name: "+_prli_HostFormName
			SET TEXT TO PASTEBOARD:C523($_prli_Err)
			_prli_Util_ErrorAlert("A Detailed error message has been pasted to your clipboard:"+Char:C90(13)+$_prli_Err; Current method name:C684)
		End if 
		_prli_iAreaWidth:=_prli_aAreaRightCoord{_prli_iFindArea}-_prli_aAreaLeftCoord{_prli_iFindArea}
		_prli_iPageRowNumber:=1
		
		_prli_iVisibleCols:=-1
		Case of 
			: (Not:C34(Is nil pointer:C315(_prli_aLastVisibleColumn{_prli_iFindArea})))
				$_prli_iFindCol:=Find in array:C230(_prli_aArray{_prli_iFindArea}; _prli_aLastVisibleColumn{_prli_iFindArea})
				If ($_prli_iFindCol>-1)
					_prli_iVisibleCols:=$_prli_iFindCol
				End if 
				
			: (Not:C34(Is nil pointer:C315(_prli_aFirstHiddenColumn{_prli_iFindArea})))
				$_prli_iFindCol:=Find in array:C230(_prli_aArray{_prli_iFindArea}; _prli_aFirstHiddenColumn{_prli_iFindArea})
				If ($_prli_iFindCol>-1)
					_prli_iVisibleCols:=$_prli_iFindCol-1
				End if 
		End case 
		
		
		If (_prli_iVisibleCols=-1)
			_prli_iVisibleCols:=Size of array:C274(_prli_aArray{_prli_iFindArea})-_prli_aHideColumns{_prli_iFindArea}
		End if 
		
		//The following segment of code is designed to make printing as fast as possible:
		//  Loading a form with 255 objects is slower than a form with fewer objects.
		//  We will use the smallest possible form that will still accomodate the quantity
		//  objects that we will be using.
		Case of 
			: (Length:C16(_prli_aObjectsFormName{_prli_iFindArea})>0)
				_prli_ObjectsFormName:=_prli_aObjectsFormName{_prli_iFindArea}
				
			: (_prli_iVisibleCols<=10)
				_prli_ObjectsFormName:="_prli_Objects_010"
				
			: (_prli_iVisibleCols<=30)
				_prli_ObjectsFormName:="_prli_Objects_030"
				
			Else 
				_prli_ObjectsFormName:="_prli_Objects_255"
				
		End case 
		
		
		If (_prli_aNumHdrLines{_prli_iFindArea}<1)
			_prli_aNumHdrLines{_prli_iFindArea}:=1
		End if 
		
		$_prli_iFooterHeight:=_prli_iFooterCoord-_prli_Break0
		
		$_prli_iFrameHeight:=0
		If (_prli_aFrame_Width{_prli_iFindArea}>0)
			$_prli_iFrameHeight:=1
		End if 
		
		
		$_prli_iColCnt:=Size of array:C274(_prli_aArray{_prli_iFindArea})
		ARRAY POINTER:C280(_prli_aHiddenArray; 0)
		ARRAY POINTER:C280(_prli_aHiddenArray; $_prli_iColCnt)
		
		ARRAY TEXT:C222(_prli_aHidCol_Text; $_prli_iColCnt; 0)
		ARRAY INTEGER:C220(_prli_aHidCol_Int; $_prli_iColCnt; 0)
		ARRAY LONGINT:C221(_prli_aHidCol_Long; $_prli_iColCnt; 0)
		ARRAY REAL:C219(_prli_aHidCol_Real; $_prli_iColCnt; 0)
		ARRAY DATE:C224(_prli_aHidCol_Date; $_prli_iColCnt; 0)
		ARRAY BOOLEAN:C223(_prli_aHidCol_Bool; $_prli_iColCnt; 0)
		
		
		//--------------------------------------------
		//Record the column data types into an array form faster redundant access
		$_prli_FieldsExist:=False:C215
		ARRAY INTEGER:C220(_prli_aColumnType; $_prli_iColCnt)
		For ($_prli_iColCtr; 1; $_prli_iColCnt)
			$_prli_pArray:=_prli_aArray{_prli_iFindArea}{$_prli_iColCtr}
			$_prli_iType:=_prli_Util_MyType($_prli_pArray)
			_prli_aColumnType{$_prli_iColCtr}:=$_prli_iType
			Case of 
				: ($_prli_iType=-1)  //nil
					
				: (Is a variable:C294($_prli_pArray))
					_prli_aHiddenArray{$_prli_iColCtr}:=$_prli_pArray
				Else 
					$_prli_FieldsExist:=True:C214
					If (_prli_aTableNum{_prli_iFindArea}=0)
						_prli_aTableNum{_prli_iFindArea}:=Table:C252($_prli_pArray)
					End if 
					Case of 
						: (($_prli_iType=Is alpha field:K8:1) | ($_prli_iType=Is text:K8:3))
							_prli_aHiddenArray{$_prli_iColCtr}:=->_prli_aHidCol_Text{$_prli_iColCtr}
							_prli_aColumnType{$_prli_iColCtr}:=Text array:K8:16
							
						: ($_prli_iType=Is integer:K8:5)
							_prli_aHiddenArray{$_prli_iColCtr}:=->_prli_aHidCol_Int{$_prli_iColCtr}
							_prli_aColumnType{$_prli_iColCtr}:=Integer array:K8:18
							
						: (($_prli_iType=Is longint:K8:6) | ($_prli_iType=Is time:K8:8))
							_prli_aHiddenArray{$_prli_iColCtr}:=->_prli_aHidCol_Long{$_prli_iColCtr}
							_prli_aColumnType{$_prli_iColCtr}:=LongInt array:K8:19
							
						: ($_prli_iType=Is real:K8:4)
							_prli_aHiddenArray{$_prli_iColCtr}:=->_prli_aHidCol_Real{$_prli_iColCtr}
							_prli_aColumnType{$_prli_iColCtr}:=Real array:K8:17
							
						: ($_prli_iType=Is date:K8:7)
							_prli_aHiddenArray{$_prli_iColCtr}:=->_prli_aHidCol_Date{$_prli_iColCtr}
							_prli_aColumnType{$_prli_iColCtr}:=Date array:K8:20
							
						: ($_prli_iType=Is boolean:K8:9)
							_prli_aHiddenArray{$_prli_iColCtr}:=->_prli_aHidCol_Bool{$_prli_iColCtr}
							_prli_aColumnType{$_prli_iColCtr}:=Boolean array:K8:21
							
					End case 
					C_POINTER:C301($_prli_pTable)
					If (Table:C252($_prli_pArray)=_prli_aTableNum{_prli_iFindArea})
						SELECTION TO ARRAY:C260($_prli_pArray->; _prli_aHiddenArray{$_prli_iColCtr}->)  //The RecNums arrays is just to enforce the proper table.
					Else 
						ARRAY LONGINT:C221($_prli_aRecNums; 0)
						SELECTION TO ARRAY:C260(Table:C252(_prli_aTableNum{_prli_iFindArea})->; $_prli_aRecNums; $_prli_pArray->; _prli_aHiddenArray{$_prli_iColCtr}->)  //The RecNums arrays is just to enforce the proper table.
						ARRAY LONGINT:C221($_prli_aRecNums; 0)
					End if 
					If (Length:C16(_prli_aHeader{_prli_iFindArea}{$_prli_iColCtr})=0)
						_prli_aHeader{_prli_iFindArea}{$_prli_iColCtr}:=Replace string:C233(Field name:C257($_prli_pArray); "_"; " ")
					End if 
			End case 
		End for   //$iColCtr      
		//--------------------------------------------
		
		
		_prli_iRowCount:=-1
		ARRAY BOOLEAN:C223(_prli_aIsArrayOrField; Size of array:C274(_prli_aHiddenArray))
		For ($_prli_iColCtr; 1; Size of array:C274(_prli_aHiddenArray))
			$_prli_bIsArray:=_prli_Util_IsAnArray(_prli_aHiddenArray{$_prli_iColCtr})
			_prli_aIsArrayOrField{$_prli_iColCtr}:=$_prli_bIsArray
			If ($_prli_bIsArray & (_prli_iRowCount=-1))
				_prli_iRowCount:=Size of array:C274(_prli_aHiddenArray{$_prli_iColCtr}->)
			End if 
		End for 
		
		If (_prli_aSortOrder{_prli_iFindArea}>"")
			
			
			//Remove any unsortable columns from the sorting list (flat variables)
			ARRAY LONGINT:C221(_prli_aLong1; 0)
			_prli_Util_TextToArray(_prli_aSortOrder{_prli_iFindArea}; ->_prli_aLong1; ";")
			For ($_prli_i; Size of array:C274(_prli_aLong1); 1; -1)
				If (_prli_aLong1{$_prli_i}#0)
					$_prli_iColumn:=Abs:C99(_prli_aLong1{$_prli_i})
					If ($_prli_iColumn<=Size of array:C274(_prli_aHiddenArray))
						If (_prli_aIsArrayOrField{$_prli_iColumn})
							
						Else 
							_prli_Util_ErrorAlert("You cannot sort column number "+String:C10($_prli_iColumn)+" because it is not an array or a field: "+_prli_Util_PtrName(_prli_aHiddenArray{$_prli_iColumn})+".")
							DELETE FROM ARRAY:C228(_prli_aLong1; $_prli_i)
							_prli_aSortOrder{_prli_iFindArea}:=_prli_UTIL_ArrayToText(->_prli_aLong1; ";")
						End if 
					Else 
						_prli_Util_ErrorAlert("You cannot sort column number "+String:C10($_prli_iColumn)+" because there are only "+String:C10(Size of array:C274(_prli_aHiddenArray))+" columns.")
						DELETE FROM ARRAY:C228(_prli_aLong1; $_prli_i)
						_prli_aSortOrder{_prli_iFindArea}:=_prli_UTIL_ArrayToText(->_prli_aLong1; ";")
					End if 
				End if 
			End for 
			ARRAY LONGINT:C221(_prli_aLong1; 0)
			
			
			If ($_prli_FieldsExist)
				C_POINTER:C301($_prli_pTable)
				$_prli_pTable:=Table:C252(_prli_aTableNum{_prli_iFindArea})
				LONGINT ARRAY FROM SELECTION:C647($_prli_pTable->; $_prli_aRecNums)
				_prli_Util_SortArrays(2+4; _prli_aSortOrder{_prli_iFindArea}; ->_prli_aHiddenArray)
				SORT ARRAY:C229(_prli_aSortArraysKey; $_prli_aRecNums)
				CREATE SELECTION FROM ARRAY:C640($_prli_pTable->; $_prli_aRecNums)
				ARRAY LONGINT:C221($_prli_aRecNums; 0)
			Else 
				_prli_Util_SortArrays(2+4; _prli_aSortOrder{_prli_iFindArea}; ->_prli_aHiddenArray)  //05/14/07: Moved this from _prli_SetSort to here.
			End if   //$FieldsExist
		End if   //(a_prli_SortOrder{_prli_iFindArea}>"")
		
		ARRAY INTEGER:C220(_prli_aSortBrkLev; 0)
		
		_prli_Util_ArrayGetSortBrkLev(->_prli_aHiddenArray; _prli_aSortOrder{_prli_iFindArea}; ->_prli_aSortBrkLev)
		
		
		ARRAY INTEGER:C220(_prli_aSortLevelColumn; 0)
		_prli_Util_TextToArray(_prli_aSortOrder{_prli_iFindArea}; ->_prli_aSortLevelColumn; ";")
		
		//Has the user not properly set the boundaries of the print area?
		//See Also: _prli_GetAreaRef, _prli_FormMethod
		If ((_prli_aAreaLeftCoord{_prli_iFindArea}=0) & (_prli_aAreaRightCoord{_prli_iFindArea}=0))
			_prli_aAreaLeftCoord{_prli_iFindArea}:=1
			_prli_aAreaRightCoord{_prli_iFindArea}:=_prli_iPageWidth-1
		End if 
		
		
		//--------------------------------------------
		//Record for quick reference which break levels have a printed break:
		// - both header and footer.
		//Store this information in a bitwise "array"
		
		//See Also: _prli_Util_InsertBreakElement
		
		C_LONGINT:C283(_prli_PrintBreakLevelFtr; _prli_PrintBreakLevelHdr; $_prli_iFindBrkCol; $_prli_iKey; $_prli_iColumn; $_prli_iBrkLev)
		_prli_PrintBreakLevelFtr:=0
		_prli_PrintBreakLevelHdr:=0
		
		
		$_prli_PrintThisBreak:=False:C215
		For ($_prli_iFindBrkCol; 1; Size of array:C274(_prli_aBrk_LevCol{_prli_iFindArea}))
			If (Length:C16(_prli_aBrk_Text{_prli_iFindArea}{$_prli_iFindBrkCol})>0)  //Is there some text to print?
				$_prli_iKey:=_prli_aBrk_LevCol{_prli_iFindArea}{$_prli_iFindBrkCol}
				$_prli_iColumn:=$_prli_iKey%256
				
				If (($_prli_iColumn>0) & ($_prli_iColumn<=_prli_iVisibleCols))  //Is the column number greater than zero?
					
					$_prli_iBrkLev:=$_prli_iKey\512
					If ($_prli_iBrkLev>=0) & ($_prli_iBrkLev<=32)
						If ($_prli_iKey ?? 8)  //+256: Is it a Header Break?
							_prli_PrintBreakLevelHdr:=_prli_PrintBreakLevelHdr ?+ $_prli_iBrkLev
						Else 
							_prli_PrintBreakLevelFtr:=_prli_PrintBreakLevelFtr ?+ $_prli_iBrkLev
						End if   //($iKey ?? 8)
					End if   //($iBrkLev>0) & ($iBrkLev<=32)
					
				End if   //(($iColumn>0) & ($iColumn<=_prli_iVisibleCols))
			End if   //(Length(a_prli_Brk_Text{_prli_iFindArea}{$iFindBrkCol})>0)
		End for 
		
		
		//--------------------------------------------
		
		If (_prli_aFrame_Width{_prli_iFindArea}>0)
			//See Also: _prli_ObjectsFormMethod
			_prli_Util_PrintForm(<>_prli_pObjectsFormTable; _prli_ObjectsFormName; 0; 1; _prli_iCountPagesDontPrint; "TopFrame")
		End if 
		
		_prli_bInCalcWidths:=True:C214
		_prli_Util_AutoCalcWidths
		_prli_bInCalcWidths:=False:C215
		
		If (_prli_aBrkKeepSamePage_First{_prli_iFindArea}>0)
			_prli_CountingRowHeights:=True:C214
			INSERT IN ARRAY:C227(_prli_aRowPreHeight{_prli_iFindArea}; 1; _prli_iRowCount)
			INSERT IN ARRAY:C227(_prli_aRowHeight{_prli_iFindArea}; 1; _prli_iRowCount)
			INSERT IN ARRAY:C227(_prli_aRowPostHeight{_prli_iFindArea}; 1; _prli_iRowCount)
			$_prli_iOldCountPagesDontPrint:=_prli_iCountPagesDontPrint
			$_prli_GetPrintedHeight1:=_prli_iGetPrintedHeight
			_prli_iGetPrintedHeight:=0
			_prli_iCountPagesDontPrint:=1
			_prli_iPageHeight:=1000000000
			
			For ($_prli_iRowCtr; 1; _prli_iRowCount)  //Count through the rows of one PT Area------------------------------------------
				_prli_iPrintingRow:=$_prli_iRowCtr
				//----------CHECK FOR A PRINT AREA PAGE HEADER-----------
				
				//CHECK FOR A BREAK HEADER
				_prli_bHdrBreak:=True:C214
				$_prli_OldPrintedHeight:=_prli_iGetPrintedHeight
				_prli_Util_PrintBreaks
				_prli_aRowPreHeight{_prli_iFindArea}{_prli_iPrintingRow}:=_prli_iGetPrintedHeight-$_prli_OldPrintedHeight
				
				
				//--------------PRINT THE DETAIL ROW------------------
				
				If (_prli_aHideDetail{_prli_iFindArea}=0)
					_prli_aRowHeight{_prli_iFindArea}{_prli_iPrintingRow}:=_prli_Util_GetDetailRowHeight
				End if 
				
				If (_prli_UserCancelPrint=False:C215)
					_prli_iLastRowPrinted:=_prli_iPrintingRow  //Used with PageProc Callback
					//--------------PRINT POSSIBLE BREAK ROWS------------------    
					
					_prli_bHdrBreak:=False:C215
					$_prli_OldPrintedHeight:=_prli_iGetPrintedHeight
					_prli_Util_PrintBreaks
					
					If (_prli_iPrintingRow<_prli_iRowCount)
						_prli_Util_PrintBreakDividers
					End if 
					_prli_aRowPostHeight{_prli_iFindArea}{_prli_iPrintingRow}:=_prli_iGetPrintedHeight-$_prli_OldPrintedHeight
				End if 
				
				If (_prli_UserCancelPrint)
					$_prli_iRowCtr:=_prli_iRowCount  //Dump the loop
				End if 
				
			End for   //Row Counter---------------------------------------------------------------------
			_prli_iCountPagesDontPrint:=$_prli_iOldCountPagesDontPrint
			_prli_iGetPrintedHeight:=$_prli_GetPrintedHeight1
			
		End if   // (a_prli_BrkKeepSamePage{_prli_iFindArea}>0)
		_prli_CountingRowHeights:=False:C215
		_prli_iPageHeight:=$_prli_iOriginalPageHeight
		
		_prli_Util_PrintAreaHdr
		
		_prli_iLastRowPrinted:=0  //Used with PageProc Callback
		
		For ($_prli_iRowCtr; 1; _prli_iRowCount)  //Count through the rows of one PT Area------------------------------------------
			_prli_iPrintingRow:=$_prli_iRowCtr
			_prli_iRowsPrintedThisPage:=_prli_iRowsPrintedThisPage+1
			//----------CHECK FOR A PRINT AREA PAGE HEADER-----------
			
			//CHECK FOR A BREAK HEADER
			_prli_bHdrBreak:=True:C214
			_prli_Util_PrintBreaks
			
			
			
			//--------------PRINT THE DETAIL ROW------------------
			
			If (_prli_aHideDetail{_prli_iFindArea}=0)
				If (_prli_aBrkKeepSamePage_First{_prli_iFindArea}>0)
					$_prli_iRowHeight:=_prli_aRowHeight{_prli_iFindArea}{_prli_iRowCount}
				Else 
					$_prli_iRowHeight:=_prli_Util_GetDetailRowHeight
				End if 
				_prli_Util_PrintPageBreak(0; $_prli_iRowHeight)
				
				If (_prli_UserCancelPrint=False:C215)
					
					If ((_prli_iPageHeight-$_prli_iFooterHeight-_prli_iGetPrintedHeight-$_prli_iFrameHeight)<$_prli_iRowHeight)
						//This branch of code handles rare cases where one row cannot fit on an entire
						//  page.
						$_prli_iRemainToPrint:=$_prli_iRowHeight
						
						Repeat 
							If ($_prli_iRemainToPrint<$_prli_iRowHeight)  //in other words, don't run this code on the first run of the loop.
								_prli_Util_PrintPageBreak(0; $_prli_iRowHeight)
							End if 
							$_prli_iThisPrintHeight:=_prli_iPageHeight-$_prli_iFooterHeight-_prli_iGetPrintedHeight-$_prli_iFrameHeight
							If ($_prli_iThisPrintHeight>$_prli_iRemainToPrint)
								$_prli_iThisPrintHeight:=$_prli_iRemainToPrint
							End if 
							$_prli_iRemainToPrint:=$_prli_iRemainToPrint-$_prli_iThisPrintHeight
							
							//See Also: _prli_ObjectsFormMethod
							_prli_Util_PrintForm(<>_prli_pObjectsFormTable; _prli_ObjectsFormName; 0; $_prli_iRowHeight; _prli_iCountPagesDontPrint; "DetailRow")  //PRINT DETAIL ROW
							
						Until ($_prli_iRemainToPrint<=0)
						
						
					Else 
						
						//See Also: _prli_ObjectsFormMethod
						_prli_Util_PrintForm(<>_prli_pObjectsFormTable; _prli_ObjectsFormName; 0; $_prli_iRowHeight; _prli_iCountPagesDontPrint; "DetailRow")  //PRINT DETAIL ROW
					End if 
					
				End if 
			End if 
			
			If (_prli_UserCancelPrint=False:C215)
				_prli_iLastRowPrinted:=_prli_iPrintingRow  //Used with PageProc Callback
				//--------------PRINT POSSIBLE BREAK ROWS------------------    
				
				_prli_bHdrBreak:=False:C215
				_prli_Util_PrintBreaks
				
				If (_prli_iPrintingRow<_prli_iRowCount)
					_prli_Util_PrintBreakDividers
				End if 
			End if 
			
			If (_prli_UserCancelPrint)
				$_prli_iRowCtr:=_prli_iRowCount  //Dump the loop
			End if 
			
		End for   //Row Counter---------------------------------------------------------------------
		
		If (_prli_UserCancelPrint=False:C215)
			If (Length:C16(_prli_aPageProc{_prli_iFindArea})>0)
				$_prli_String:=_prli_aPageProc{_prli_iFindArea}+"("+String:C10(_prli_AreaRef)+";"+String:C10(_prli_iLastRowPrinted)+")"
				_prli_Util_Execute($_prli_String; _prli_aPageProc{_prli_iFindArea})
			End if 
		End if 
		
		
		If (_prli_aFrame_Width{_prli_iFindArea}>0) & (_prli_UserCancelPrint=False:C215)
			//See Also: _prli_ObjectsFormMethod
			_prli_Util_PrintForm(<>_prli_pObjectsFormTable; _prli_ObjectsFormName; 0; 1; _prli_iCountPagesDontPrint; "BottomFrame")  //PRINT DETAIL ROW
		End if 
		
		If ($_prli_AreaCtr<Size of array:C274(_prli_alAreaRef)) & (_prli_UserCancelPrint=False:C215)
			//Are there more areas to print?
			//If so, then print the area between the areas.
			$_prli_iFindNextArea:=Find in array:C230(_prli_alAreaRef; $_prli_aSortedArea_AreaRef{$_prli_AreaCtr+1})
			$_prli_iBetweenSpace:=_prli_aAreaTopCoord{$_prli_iFindNextArea}-_prli_aAreaBottomCoord{_prli_iFindArea}
			If ($_prli_iBetweenSpace>0)
				_prli_Util_PrintPageBreak(0; $_prli_iBetweenSpace)
				If (Length:C16(_prli_HostFormName)>0)
					_prli_Util_PrintForm(_prli_pHostFormTable; _prli_HostFormName; _prli_aAreaBottomCoord{_prli_iFindArea}+1; _prli_aAreaTopCoord{$_prli_iFindNextArea}; _prli_iCountPagesDontPrint; "AfterArea_"+String:C10(_prli_AreaRef))
				End if 
			End if 
		End if 
		
		If (_prli_UserCancelPrint)
			$_prli_AreaCtr:=Size of array:C274(_prli_alAreaRef)  //Dump the loop
		End if 
		
		
		ARRAY TEXT:C222(_prli_aHidCol_Text; 0; 0)
		ARRAY INTEGER:C220(_prli_aHidCol_Int; 0; 0)
		ARRAY LONGINT:C221(_prli_aHidCol_Long; 0; 0)
		ARRAY REAL:C219(_prli_aHidCol_Real; 0; 0)
		ARRAY DATE:C224(_prli_aHidCol_Date; 0; 0)
		ARRAY BOOLEAN:C223(_prli_aHidCol_Bool; 0; 0)
		
	End for   //$AreaCtr
	
	
	
	If (_prli_iCountPagesDontPrint=0)  //If we're just calculating the number of pages, then don't run this code
		If ((_prli_aClearArraysWhenDone{_prli_iFindArea}) | $_prli_SizeToZeroAfterPrint)  //Are we configured to clear out the report arrays when finished?
			For ($_prli_AreaCtr; 1; Size of array:C274(_prli_alAreaRef))
				For ($_prli_iColCtr; 1; Size of array:C274(_prli_aArray{$_prli_AreaCtr}))
					$_prli_Ptr:=_prli_aArray{$_prli_AreaCtr}{$_prli_iColCtr}
					If (Is a variable:C294($_prli_Ptr))
						_prli_Util_SizeArray(0; $_prli_Ptr)  //Mod 02/25/05: Changed from _prli_Util_SizeArrayGroup to _prli_Util_SizeArray
					End if 
				End for 
			End for 
		End if 
	End if   //_prli_iCountPagesDontPrint
	
	//----------------------Print from the bottom of the last PrintTwist area to the
	//  specified host form's Break Zero area
	
	_prli_AreaRef:=-1
	_prli_iFindArea:=-1
	
	
	//Print from the bottom of the Print Area to the bottom of the Detail area
	$_prli_iDetailSpace:=_prli_iFormDetailCoord-_prli_aAreaBottomCoord{Size of array:C274(_prli_alAreaRef)}
	If ($_prli_iDetailSpace>0) & (_prli_UserCancelPrint=False:C215)
		_prli_Util_PrintPageBreak(0; _prli_iFormDetailCoord-_prli_aAreaBottomCoord{Size of array:C274(_prli_alAreaRef)})
		If (Length:C16(_prli_HostFormName)>0)
			
			_prli_Util_PrintForm(_prli_pHostFormTable; _prli_HostFormName; _prli_aAreaBottomCoord{Size of array:C274(_prli_alAreaRef)}+1; _prli_iFormDetailCoord; _prli_iCountPagesDontPrint; "AfterArea_"+String:C10(_prli_alAreaRef{Size of array:C274(_prli_alAreaRef)}))
		End if 
	End if 
	
	//Print the form Break area
	$_prli_iBreakSpace:=_prli_Break0-_prli_iFormDetailCoord
	If ($_prli_iBreakSpace>0) & (_prli_UserCancelPrint=False:C215)
		_prli_Util_PrintPageBreak(0; _prli_Break0-_prli_iFormDetailCoord)
		If (Length:C16(_prli_HostFormName)>0)
			_prli_Util_PrintForm(_prli_pHostFormTable; _prli_HostFormName; _prli_iFormDetailCoord; _prli_Break0; _prli_iCountPagesDontPrint; "Break_0")
		End if 
	End if 
	
	
	$_prli_iFooterHeight:=_prli_iFooterCoord-_prli_Break0
	If ($_prli_iFooterHeight>0) & (_prli_UserCancelPrint=False:C215)
		$_prli_iTo:=_prli_iPageHeight-$_prli_iFooterHeight-_prli_iGetPrintedHeight
		_prli_Util_PrintBlankSpace($_prli_iTo)
		If (Length:C16(_prli_HostFormName)>0)
			_prli_Util_PrintForm(_prli_pHostFormTable; _prli_HostFormName; _prli_Break0; _prli_iFooterCoord; _prli_iCountPagesDontPrint; "Footer")
		End if 
	End if 
	
	
	If (($_prli_DontIssuePageBreakAtEnd=False:C215) & (_prli_iCountPagesDontPrint#1))
		PAGE BREAK:C6
	End if 
	_prli_iTotalPageCount:=_prli_iPrintingPage
	
	If (_prli_iCountPagesDontPrint#1)
		_prli_Util_SizeArrayGroup(-1; ->_prli_aGroup)  //Clear the PT configurations.
	End if 
	
	ON ERR CALL:C155($_prli_PrevErrorMethod)  //Restore to the prior on-error call method
	If ($_prli_SpecialOpts ?? 0)
		$_prli_TickEnd:=Tickcount:C458
		_info_ ALERT(String:C10($_prli_TickEnd-$_prli_TickBegin)+" Ticks")
	End if 
End if 
