//%attributes = {}
//BB_ArrayToText(->Array{;Delimiter};{IndexArray};NumFormat+Opts
//    ;TextFormat)->Text
//by Tony Ringsmuth, cerca 1990
//Part of the BB_Base Component, by Business Brothers.

//--------------------------------------------------------------------------------
//FUNCTION
//Compose Text ($0) from the specified array ($1) with the delimiter ($2)
//Allow the specification of an index to the array ($3)
//   and formats for the text output ($4, $5)

//--------------------------------------------------------------------------------
//PARAMETERS
//$0 = Text that contains concatination of values from TextArray
//$1 = pointer to Array: Text/Numeric/Date/Boolean
//{$2} = Delimiter to be put between elemnt vals in result
//{$3} = IndexArray: Only return text for selected Index elements of $1
//{$4} = when specifying a format for date or time, pass the format number here
//   Values above 16 are bitwise options parameters
//   +4 (bit 2): Replace Delimiters in text with "<CHAR###>" (Text Only)
//{$5} = when specifying a format for numbers ("###,##0" etc), pass the frmt here

//Output text will NOT contain a delimiter after the last item.

//--------------------------------------------------------------------------------
//REV HISTORY
//Rev: 12/21/06: Added "Replace Delimiters" opt
//Rev: 07/05/05: General Cleanup, Add BB_DateString for dates
//Rev: 03/30/05: Allow custom formats for Boolean output
//Rev: 04/16/04: Changed from using ◊BB_NullPtr to Nil
//Rev: 02/10/04: Improved documentation
//Rev: 02/16/00: Bug Fix with ◊NullPtr in $3
//Rev: 01/31/00: allow 2D arrays
//Rev: 12/01/99: Bullet proofing
//Rev: 11/29/99: Add Format options
//Rev: 04/22/99: added numeric, date & Boolean arrays, and Index Array
//--------------------------------------------------------------------------------
C_TEXT:C284($0)
C_POINTER:C301($1; $_prli_pArray)
C_TEXT:C284($2; $_prli_Dlmtr)
C_POINTER:C301($3; $_prli_pIndexArray)
C_LONGINT:C283($4; $_prli_opts)
C_TEXT:C284($5; $_prli_TextFormat)

C_LONGINT:C283($_prli_iCtr; $_prli_iElement; $_prli_iType; $_prli_iSize; $_prli_iNumFormat; $_prli_iOffset; $_prli_iTable; $_prli_iField; $_prli_iTypeIndexArray)
C_TEXT:C284($_prli_VarName; $_prli_Add)
C_BOOLEAN:C305($_prli_bIndexArray)
C_BLOB:C604($_prli_xTempBlob)

$_prli_pArray:=$1

If (Count parameters:C259>1)
	$_prli_Dlmtr:=$2
Else 
	$_prli_Dlmtr:=""
End if 

If (Count parameters:C259>2)
	$_prli_pIndexArray:=$3
End if 

$_prli_opts:=0  //Opts is a Bitwise parameter:
If (Count parameters:C259>3)
	$_prli_opts:=$4
End if 
$_prli_iNumFormat:=($_prli_opts%16)
$_prli_ReplaceDelimiters:=($_prli_opts ?? 2)  //+4

If (Count parameters:C259>4)
	$_prli_TextFormat:=$5
End if 


$_prli_iType:=Type:C295($_prli_pArray->)

If ($_prli_iType=Array 2D:K8:24)
	RESOLVE POINTER:C394($_prli_pArray; $_prli_VarName; $_prli_iTable; $_prli_iField)
	If ($_prli_iTable=-1)  //$iTable=-1 indicates the 1st dimension of a 2d array: not allowed here.
		_prli_Util_ErrorAlert("The first dimension of a 2D array cannot be used: "+$_prli_VarName; "_prli_Util_ArrayToText")
	Else 
		$_prli_Ptr2:=Get pointer:C304($_prli_VarName)
		If (Size of array:C274($_prli_Ptr2->)<$_prli_iTable)
			_prli_Util_ErrorAlert("Tried to reference array "+String:C10($_prli_iTable)+" of "+$_prli_VarName+" which had only "+String:C10(Size of array:C274($_prli_Ptr2->))+" arrays."; "_prli_Util_ArrayToText")
		Else 
			VARIABLE TO BLOB:C532($_prli_pArray->{0}; $_prli_xTempBlob)
			If (BLOB size:C605($_prli_xTempBlob)>4)
				$_prli_iOffset:=4  //the 5th character (blobs start at zero) holds the data type.
				$_prli_iType:=Character code:C91(BLOB to text:C555($_prli_xTempBlob; Mac text without length:K22:10; $_prli_iOffset; 1))
			End if 
		End if 
	End if 
End if 
$_prli_bIndexArray:=False:C215


If (Not:C34(Is nil pointer:C315($_prli_pIndexArray)))  //02/16/00
	$_prli_SkipErr2:=False:C215
	$_prli_iTypeIndexArray:=Type:C295($_prli_pIndexArray->)
	If ($_prli_iTypeIndexArray=Array 2D:K8:24)
		RESOLVE POINTER:C394($_prli_pIndexArray; $_prli_VarName; $_prli_iTable; $_prli_iField)
		If ($_prli_iTable=-1)  //$iTable=-1 indicates the 1st dimension of a 2d array: not allowed here.
			_prli_Util_ErrorAlert("Index Array: The first dimension of a 2D array cannot be used: "+$_prli_VarName; "_prli_Util_ArrayToText")
		Else 
			$_prli_Ptr2:=Get pointer:C304($_prli_VarName)
			If (Size of array:C274($_prli_Ptr2->)<$_prli_iTable)
				_prli_Util_ErrorAlert("Index Array: Tried to reference array "+String:C10($_prli_iTable)+" of "+$_prli_VarName+" which had only "+String:C10(Size of array:C274($_prli_Ptr2->))+" arrays."; "_prli_Util_ArrayToText")
				$_prli_SkipErr2:=True:C214
			Else 
				VARIABLE TO BLOB:C532($_prli_pIndexArray->{0}; $_prli_xTempBlob)
				If (BLOB size:C605($_prli_xTempBlob)>4)
					$_prli_iOffset:=4  //the 5th character (blobs start at zero) holds the data type.
					$_prli_iTypeIndexArray:=Character code:C91(BLOB to text:C555($_prli_xTempBlob; Mac text without length:K22:10; $_prli_iOffset; 1))
				End if 
			End if 
		End if 
	End if 
	$_prli_bIndexArray:=(($_prli_iTypeIndexArray=Integer array:K8:18) | ($_prli_iTypeIndexArray=LongInt array:K8:19) | ($_prli_iTypeIndexArray=Real array:K8:17))
	If (($_prli_bIndexArray=False:C215) & ($_prli_SkipErr2=False:C215))
		RESOLVE POINTER:C394($_prli_pIndexArray; $_prli_VarName; $_prli_iTable; $_prli_iField)
		_prli_Util_ErrorAlert("Index Array: Cannot use array of type: "+String:C10($_prli_iTypeIndexArray)+": "+$_prli_VarName; "_prli_Util_ArrayToText")
	End if 
End if   //02/16/00


Case of 
	: ($_prli_bIndexArray)
		$_prli_iSize:=Size of array:C274($_prli_pIndexArray->)
	: (($_prli_iType=Is undefined:K8:13) | ($_prli_iType=Array 2D:K8:24))
		$_prli_iSize:=0
	Else 
		$_prli_iSize:=Size of array:C274($_prli_pArray->)
End case 
$0:=""

If ($_prli_iSize>0)
	
	If ($_prli_ReplaceDelimiters)
		$_prli_DlmtReplace:=""
		For ($_prli_i; 1; Length:C16($_prli_Dlmtr))
			$_prli_DlmtReplace:=$_prli_DlmtReplace+"<CHAR"+String:C10(Character code:C91($_prli_Dlmtr[[$_prli_i]]); "000")+">"
		End for 
	End if 
	
	C_TEXT:C284($_prli_TrueText; $_prli_FalseText)
	If ($_prli_iType=Boolean array:K8:21)
		If ($_prli_TextFormat="")
			$_prli_TrueText:="True"
			$_prli_FalseText:="False"
		Else 
			$_prli_iPosition:=Position:C15(";"; $_prli_TextFormat)
			If ($_prli_iPosition=0)
				$_prli_TrueText:=$_prli_TextFormat
				$_prli_FalseText:=""
			Else 
				$_prli_TrueText:=Substring:C12($_prli_TextFormat; 1; $_prli_iPosition-1)
				$_prli_FalseText:=Substring:C12($_prli_TextFormat; $_prli_iPosition+1)
			End if 
		End if 
	End if 
	
	For ($_prli_iCtr; 1; $_prli_iSize)
		If ($_prli_bIndexArray)
			$_prli_iElement:=$_prli_pIndexArray->{$_prli_iCtr}
		Else 
			$_prli_iElement:=$_prli_iCtr
		End if 
		$_prli_Add:=""
		Case of 
			: (($_prli_iType=Text array:K8:16) | ($_prli_iType=String array:K8:15))
				If ($_prli_ReplaceDelimiters)
					$_prli_Add:=Replace string:C233($_prli_pArray->{$_prli_iElement}; $_prli_Dlmtr; $_prli_DlmtReplace)
				Else 
					$_prli_Add:=$_prli_pArray->{$_prli_iElement}
				End if 
				
			: ($_prli_iType=Date array:K8:20)
				Case of 
					: ($_prli_iNumFormat>0)
						$_prli_Add:=String:C10($_prli_pArray->{$_prli_iElement}; $_prli_iNumFormat)
						//: (Length($TextFormat)>0)
						//$Add:=BB_DateString($pArray->{$iElement};$TextFormat)
					Else 
						$_prli_Add:=String:C10($_prli_pArray->{$_prli_iElement}; Internal date short:K1:7)  //Default Format for Dates: Forced YYYY
				End case 
				
			: (($_prli_iType=Real array:K8:17) | ($_prli_iType=Integer array:K8:18) | ($_prli_iType=LongInt array:K8:19))
				If (Length:C16($_prli_TextFormat)>0)
					$_prli_Add:=String:C10($_prli_pArray->{$_prli_iElement}; $_prli_TextFormat)
				Else 
					$_prli_Add:=String:C10($_prli_pArray->{$_prli_iElement})
				End if 
				
			: ($_prli_iType=Boolean array:K8:21)
				If ($_prli_pArray->{$_prli_iElement})
					$_prli_Add:=$_prli_TrueText
				Else 
					$_prli_Add:=$_prli_FalseText
				End if 
		End case 
		$0:=$0+$_prli_Add+$_prli_Dlmtr
		If (Length:C16($0)>=32000)
			_prli_Util_ErrorAlert("The Length of the output has exceeded 32K."+Char:C90(13)+Substring:C12($0; 1; 255)+"..."; "_prli_Util_ArrayToText")
			$_prli_iCtr:=$_prli_iSize
		End if 
	End for 
	
	If ($_prli_Dlmtr>"")
		$0:=Substring:C12($0; 1; Length:C16($0)-Length:C16($_prli_Dlmtr))
	Else 
		$0:=$0
	End if 
End if 
