//%attributes = {}
//_prli_Util_ArrayGetSortBrkLev(->aGroup;SortOrders;->ResultArray)

//Part of the PrintTwist(tm) component by Business Brothers, Inc.
//Written by Tony Ringsmuth


//FUNCTION:
//Build a result array that has the Break level of each corresonding
//  element in Group, based on SortOrders.
//The break level compares element with the next element

//Result array should be Integer, Longint or Real

//Rev: 09/28/2005: Fixed a bug if sorting on column zero
//Rev: 03/16/2005: Fixed a bug here when the final sort level is descending.
//Rev: 05/12/2003: Fixed an Array Range Check error with Arrays are Zero size.


C_POINTER:C301($1; $_prli_pGroup; $3; $_prli_pResultArray)
C_TEXT:C284($2; $_prli_SortOrders)
C_LONGINT:C283($_prli_Size; $_prli_i; $_prli_LastDlmt; $_prli_Cnt; $_prli_LevCtr; $_prli_SortLevNum)

$_prli_pGroup:=$1
$_prli_SortOrders:=$2
$_prli_pResultArray:=$3

$_prli_Size:=_prli_iRowCount
_prli_Util_SizeArray(0; $_prli_pResultArray)

If ($_prli_Size>0)
	
	ARRAY POINTER:C280($_prli_aSortArrays; 0)
	ARRAY BOOLEAN:C223($_prli_aIsAnArray; 0)
	$_prli_LastDlmt:=0
	For ($_prli_i; 1; Length:C16($_prli_SortOrders))
		If ($_prli_SortOrders[[$_prli_i]]=";")
			$_prli_String:=Substring:C12($_prli_SortOrders; $_prli_LastDlmt+1; $_prli_i-$_prli_LastDlmt-1)
			$_prli_SortLevNum:=Abs:C99(Num:C11($_prli_String))
			Case of 
				: ($_prli_SortLevNum=0)
					$_prli_i:=1000
					
				: ($_prli_SortLevNum<=Size of array:C274($_prli_pGroup->))
					$_prli_iSize:=Size of array:C274($_prli_aSortArrays)+1
					INSERT IN ARRAY:C227($_prli_aSortArrays; $_prli_iSize)
					INSERT IN ARRAY:C227($_prli_aIsAnArray; $_prli_iSize)
					$_prli_aSortArrays{$_prli_iSize}:=$_prli_pGroup->{$_prli_SortLevNum}
					$_prli_aIsAnArray{$_prli_iSize}:=_prli_Util_IsAnArray($_prli_pGroup->{$_prli_SortLevNum})
					
					$_prli_LastDlmt:=$_prli_i
				Else 
					_prli_Util_ErrorAlert("Tried to sort by a column that does not exist: Column "+String:C10($_prli_SortLevNum)+Char:C90(13)+"Column Count: "+String:C10(Size of array:C274($_prli_pGroup->))+"."; Current method name:C684)
			End case 
		End if 
	End for 
	
	If (Length:C16($_prli_SortOrders)>0)
		$_prli_SortLevNum:=Abs:C99(Num:C11(Substring:C12($_prli_SortOrders; $_prli_LastDlmt+1; $_prli_i-$_prli_LastDlmt-1)))
		If (($_prli_SortLevNum>0) & ($_prli_SortLevNum<=Size of array:C274($_prli_pGroup->)))
			$_prli_iSize:=Size of array:C274($_prli_aSortArrays)+1
			INSERT IN ARRAY:C227($_prli_aSortArrays; $_prli_iSize)
			INSERT IN ARRAY:C227($_prli_aIsAnArray; $_prli_iSize)
			$_prli_aSortArrays{$_prli_iSize}:=$_prli_pGroup->{$_prli_SortLevNum}
			$_prli_aIsAnArray{$_prli_iSize}:=_prli_Util_IsAnArray($_prli_pGroup->{$_prli_SortLevNum})
		Else 
			_prli_Util_ErrorAlert("Tried to sort by a column that does not exist: Column "+String:C10($_prli_SortLevNum)+Char:C90(13)+"Column Count: "+String:C10(Size of array:C274($_prli_pGroup->))+"."; Current method name:C684)
		End if 
	End if 
	
	
	
	_prli_Util_SizeArray($_prli_Size; $_prli_pResultArray)
	
	$_prli_pResultArray->{0}:=0
	For ($_prli_Cnt; 1; $_prli_Size-1)
		$_prli_pResultArray->{$_prli_Cnt}:=-1  //No Break
		For ($_prli_LevCtr; 1; Size of array:C274($_prli_aSortArrays))
			If ($_prli_aIsAnArray{$_prli_LevCtr})
				$_prli_pArray:=$_prli_aSortArrays{$_prli_LevCtr}
				If ($_prli_pArray->{$_prli_Cnt}#$_prli_pArray->{$_prli_Cnt+1})
					$_prli_pResultArray->{$_prli_Cnt}:=$_prli_LevCtr
					$_prli_LevCtr:=10000
				End if 
			End if 
		End for 
	End for 
	
	$_prli_pResultArray->{$_prli_Cnt}:=0
End if 
