//%attributes = {"publishedSql":true}
// Method: _tcp_SERVER_HTTP_HANDLER
// 2003.04.03-02:20:45 / Pasi Mankinen
// © Copyright 2003 Manage Applications
// Purpose: 
// Slave process that handles HTTP and 4d remote tcp requests
// http_Master listens for connections and passes them to _rem_ Serve or _http_Ser
// this process is paused to use the minimum amount of cpu time

//see also: _tcp_SERVER_LISTENER
// ------------------------------------------------------------
_prs NEW_INIT

If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStart; Current method name:C684)
End if 

C_LONGINT:C283($_tcp_lCurrentPrs; $_tcp_lErr; $_tcp_lSleep)
C_LONGINT:C283($_tcp_lKeepAlive; $_tcp_lSocket; $_tcp_lStatus; $_tcp_lSocketIndex)


COMPILER__tcp_
_tcp_ PLUGIN_TYPE_SERVER_SET

COMPILER__http_

// MESSAGES OFF

_tcp_ tTcpPrsState:="starting"
_http_ SERVE_INIT
$_tcp_lCurrentPrs:=Current process:C322  //can not change

$_tcp_lSleep:=kTrue
$_tcp_lSocket:=0

_tcp_lSocket:=0  //set by SET PROCESS VARIABLE
$_tcp_lKeepAlive:=kFalse  //don't go to sleep after start
$_tcp_lBufferSize:=0

Repeat 
	If ($_tcp_lKeepAlive#kTrue)
		If (($_tcp_lKeepAlive=kClose) & ($_tcp_lSocket>0))  //$_tcp_lBufferSize = status
			_tcp_ tTcpPrsState:="sleep close"
			$_tcp_lStatus:=_tcp_ StatusGet($_tcp_lSocket)
			//If ($_tcp_lStatus=8)
			//DELAY PROCESS($_tcp_lCurrentPrs;0)  //_time WAIT (0,001) 
			// wait for other end to close?
			// wait for data to be sent, we should use LINGER arp option
			//End if 
			If (_tcp_ CloseNeeded($_tcp_lStatus)=kTrue)
				//$_tcp_lIndex:=Find in array(<>_tcp_alSocketRequestPrs;$_tcp_lCurrentPrs)
				//If ($_tcp_lIndex>0)
				//<>_tcp_alSocketStatus{$_tcp_lIndex}:=-5
				//Else 
				_tcp_ SOCKET_CLOSE($_tcp_lSocket; Current method name:C684)
				$_tcp_lSocket:=0
				//End if 
			Else 
				IDLE:C311
			End if 
			
		End if 
		//If ((_tcp_lSocket=0) | ($_tcp_lSocket=_tcp_lSocket))  // not a new request waiting, _tcp_lSocket set in _tcp_SERVER_CONNECTED
		_tcp_ tTcpPrsState:="sleep"
		PAUSE PROCESS:C319($_tcp_lCurrentPrs)
		//Else 
		//  // new loop
		//End if 
		_tcp_lHitConnectTime:=Tickcount:C458
	End if 
	If (<>_tcp_lServerQuit=kFalse)
		_tcp_ tTcpPrsState:="wake up"
		$_tcp_lSocket:=_tcp_lSocket  //set by SET PROCESS VARIABLE
	End if 
	
	Case of 
		: (<>_tcp_lServerQuit=kTrue)
			IDLE:C311  //just quit
		: ($_tcp_lSocket=0)
			_err MESSAGE("socket is zero"; Current method name:C684; kFalse)
		Else 
			_tcp_lKeepAliveCount:=0
			$_tcp_lKeepAlive:=<>_tcp_lKeepAlive
			
			Repeat 
				_tcp_ tTcpPrsState:="waiting for data: "+String:C10(_tcp_lKeepAliveCount)
				$_tcp_lBufferSize:=_tcp_ BufferSize($_tcp_lSocket; 0)
				If (($_tcp_lKeepAlive=kTrue) & ($_tcp_lBufferSize=0))  // the next request is available ?   
					//wait for data to come in
					_tcp_ tTcpPrsState:="sleep - keepalive"
					If (<>_info_ fProfile)
						_info_ CALL_PROFILE(kStop; Current method name:C684)
					End if 
					DELAY PROCESS:C323($_tcp_lCurrentPrs; <>_tcp_lKeepAliveTimeout)
					If (<>_info_ fProfile)
						_info_ CALL_PROFILE(kStart; Current method name:C684)
					End if 
					_tcp_ tTcpPrsState:="wake up - keepalive"
					$_tcp_lSocket:=_tcp_lSocket  //set by SET PROCESS VARIABLE
					If ($_tcp_lSocket>0)
						$_tcp_lBufferSize:=_tcp_ BufferSize($_tcp_lSocket; 0)
					End if 
				End if 
				
				Case of 
					: ($_tcp_lBufferSize<0)  // socket closed            
						$_tcp_lKeepAlive:=kClose
						
					: ($_tcp_lSocket<=0)
						$_tcp_lKeepAlive:=kClose
						
					: ($_tcp_lBufferSize>0)
						_tcp_lHitConnectTime:=Tickcount:C458
						_tcp_ tTcpPrsState:="http serve"
						_tcp_lKeepAliveCount:=_tcp_lKeepAliveCount+1
						_tcp_ lHitCount:=_tcp_ lHitCount+1
						//$_tcp_lSocketIndex:=Find in array(<>_tcp_alSocket;$_tcp_lSocket)
						//If ($_tcp_lSocketIndex>0)
						//<>_tcp_alSocketHitCount{$_tcp_lSocketIndex}:=<>_tcp_alSocketHitCount{$_tcp_lSocketIndex}+1
						//End if 
						$_tcp_lKeepAlive:=_http_ Serve($_tcp_lSocket)  // handle the incoming HTTP _info_ Request (s)    
						_tcp_ tTcpPrsState:="http serve - end"
						
						If ($_tcp_lKeepAlive#kTrue)
							// _tcp_ tTcpPrsLastConnectTime:=_date CurrentDateTimeToString 
							_tcp_ tTcpPrsLastConnectTime:=_date ToString(_date Current(kFalse))+" - "+_time ToString(_time Current(kFalse))
							$_tcp_lKeepAlive:=kClose
						End if 
						
					Else   //: ($_tcp_lBufferSize=0)  ` the next request is not available
						Case of 
							: (_tcp_lKeepAliveCount>(<>_tcp_lMaxKeepAliveCount))
								$_tcp_lKeepAlive:=kClose
							: (Abs:C99(Tickcount:C458-_tcp_lHitConnectTime)><>_tcp_lKeepAliveTimeout)
								//it does not matter if tickcount has looped over - some other process will serve
								$_tcp_lKeepAlive:=kClose
								//: (_tcp_lKeepAliveCount>10)
								//DELAY PROCESS(Current process;6)
							Else 
								IDLE:C311  //keep on trying
						End case 
				End case   // the next request is not available ?
				
				
			Until ((<>_tcp_lServerQuit=kTrue) | ($_tcp_lKeepAlive=kClose))  // ($_tcp_lKeepAlive#kTrue)
			
	End case 
Until (<>_tcp_lServerQuit=kTrue)

If ($_tcp_lSocket#0)
	$_tcp_lStatus:=_tcp_ StatusGet($_tcp_lSocket)
	If ($_tcp_lStatus>0)
		_tcp_ tTcpPrsState:="quit close"
		_tcp_ SOCKET_CLOSE($_tcp_lSocket; Current method name:C684)
	End if 
End if 

_tcp_ tTcpPrsState:="quit"

If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStop; Current method name:C684)
End if 

_prs_ NEW_QUIT
