//%attributes = {}
// Project Method: Calendar_SetupMonth

// Searching for answers? Be sure to check out the "About..." menu located in the
// Apple menu (Macintosh) or the Help menu (Windows). There you can find online
// help for this example database, as well as a listing of numerous 4D resources
// available to you.

// Method created by Dave Batton, DataCraft

// Set up some IP variables that describe what the calendar looks like for the 
//   currently displayed month. We also set the month name and year displayed on
//   the calendar here.

C_LONGINT:C283(cal_lFirstBox; cal_lLastBox)
C_TEXT:C284(cal_tTitle)
C_DATE:C307(cal_dFirstBoxDate; $cal_dFirstOfThisMonth)

// Determine the first and last boxes used to display this month.
cal_lFirstBox:=Day number:C114(_date Add(!00-00-00!; cal_lYear; cal_atMonths; 1))
cal_lFirstBox:=cal_lFirstBox-<>cal_lFirstShownDayNumber+1  //-2=Monday
If (cal_lFirstBox<1)
	cal_lFirstBox:=7-cal_lFirstBox
End if 
cal_lLastBox:=cal_LastDay(cal_atMonths; cal_lYear)+cal_lFirstBox-1

// We also will need to know the date of the first date displayed on the calendar.
$cal_dFirstOfThisMonth:=cal_Date(1; cal_atMonths; cal_lYear)
cal_dFirstBoxDate:=_date Add($cal_dFirstOfThisMonth; 0; 0; 1-cal_lFirstBox)
If (cal_lLastBox<=35)  // there might be only 5 weeks visible
	cal_dLastBoxDate:=cal_dFirstBoxDate+35-1  //-1 PM: 2005-10-06
Else 
	cal_dLastBoxDate:=cal_dFirstBoxDate+42-1  //-1 PM: 2005-10-06
End if 

// Set the title of the calendar.
cal_tTitle:=cal_atMonths{cal_atMonths}+ksSpace+"("+String:C10(cal_atMonths)+".)"+ksSpace+String:C10(cal_lYear)
