//%attributes = {}
// Project Method: Calendar_PlaceTextObject

// Searching for answers? Be sure to check out the "About..." menu located in the
// Apple menu (Macintosh) or the Help menu (Windows). There you can find online
// help for this example database, as well as a listing of numerous 4D resources
// available to you.

// Method created by Dave Batton, DataCraft

// Called from Calendar_PlaceEvents to place Special Day and Appointment events.

C_LONGINT:C283($cal_lObjectNum; $1)

$cal_lObjectNum:=$1

Case of 
	: ($cal_lObjectNum<1)
	: ($cal_lObjectNum>cal_lMaxTextObjects)
	Else 
		_O_C_STRING:C293(31; $cal_varObjectName)
		C_POINTER:C301($cal_varPtr)
		C_LONGINT:C283($cal_boxNumber; $cal_boxLeft; $cal_boxTop; $cal_boxRight; $cal_boxBottom; $cal_textBottom)
		
		$cal_varObjectName:="cal_tText"+String:C10($cal_lObjectNum)
		
		// Update the arrays that let us track which record the object is associated with.
		cal_TRACKING_ELEM_ADD($cal_varObjectName)
		
		// Get a pointer to the variable object.
		$cal_varPtr:=Get pointer:C304($cal_varObjectName)
		
		// Set the object's text.
		$cal_varPtr->:=cal_EventDisplayFormat
		
		// Set the object's color.
		cal_OBJECT_COLOR_SET($cal_varPtr)
		
		// We handle the stacking of event objects here.
		If (do_adDate_{cal_lEventIndex}#cal_dLastDatePlaced)
			cal_lNextTextTop:=15
			cal_dLastDatePlaced:=do_adDate_{cal_lEventIndex}
		Else 
			cal_lNextTextTop:=cal_lNextTextTop+cal_lTextHeight
		End if 
		
		// Find the box into which we want to place this event.
		$cal_boxNumber:=do_adDate_{cal_lEventIndex}-cal_dFirstBoxDate+1
		OBJECT GET COORDINATES:C663(*; "Box"+String:C10($cal_boxNumber); $cal_boxLeft; $cal_boxTop; $cal_boxRight; $cal_boxBottom)
		
		// Make sure the item's text doesn't extend beyond the bottom of the box for that 
		//   date.
		$cal_textBottom:=$cal_boxTop+cal_lNextTextTop+cal_lTextHeight
		If ($cal_textBottom>$cal_boxBottom)
			$cal_textBottom:=$cal_boxBottom
		End if 
		
		// Move the text event object into place.
		OBJECT MOVE:C664($cal_varPtr->; $cal_boxLeft+3; $cal_boxTop+cal_lNextTextTop; $cal_boxRight-3; $cal_textBottom; *)
End case 
