//%attributes = {}
// Method:  ld_CalculateQueueLG
// 2004.03.02-20:17:11 / Pasi Mankinen
// © Copyright 2004 Manage Applications
// Purpose: 
// `AK: 2004-08-02
// ------------------------------------------------------------
If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStart; Current method name:C684)
End if 

C_LONGINT:C283($1; $ld_lStartIndex; $2; $ld_lEndIndex; $3; $ld_lDirection; $4; $ld_lCalculationType; $5; $ld_lUseExtraTime; $ld_lIndex)
C_REAL:C285($0; $ld_rTime; $6; $ld_rMinAllowedTime; $7; $ld_rMaxAllowedTime; $ld_rExtraTimeHours; $ld_rExtraTime; $ld_rEndTime; $ld_rStartTime)
C_LONGINT:C283($8; $ld_lCalcLoadFromCriticalDate; $ld_lMatStartTimeTmp; $ld_lMatEndTimeTmp)  //array values are longint!
//C_DATE($8;$ld_dCapacityStartDate)
//C_TIME($9;$ld_hCapacityStartTime)
C_DATE:C307($ld_dStartDate; $ld_dEndDate)
C_LONGINT:C283($ld_lStartTime; $ld_dEndTime; $ld_lWlgLoadingType; $ld_lCalculationOnlyExtratime)
C_REAL:C285($ld_rFreeCumulativeCapacity; $ld_rWorkTime_tmp; $ld_rSetup_Time; $ld_rWork_Time)
C_TEXT:C284($ld_work_tOriginal_WLG)
C_DATE:C307($ld_dMatStartDateTmp; $ld_dMatEndDateTmp)

//COMPILER_ld_ip, COMPILER_ld_work_arr
$ld_lStartIndex:=$1
$ld_lEndIndex:=$2
$ld_lDirection:=$3
$ld_lCalculationType:=$4
$ld_lUseExtraTime:=$5
$ld_rMinAllowedTime:=$6
$ld_rMaxAllowedTime:=$7
$ld_lCalcLoadFromCriticalDate:=$8

If ($ld_lStartIndex>0)
	//AK: 2004-11-01 - force calc. type to another  
	$ld_lWlgLoadingType:=ld_wlg_LoadingTypeGet(ld_work_asWork_Load_Group_id{$ld_lStartIndex})
	$ld_lCalculationOnlyExtratime:=kFalse
	If ($ld_lCalculationType>=0)  //AK: 2004-11-11
		//should we override calculation type
		//because of wlg_ setting?    
		Case of 
			: ($ld_lWlgLoadingType=<>wlg_lType_NotLoaded)
				$ld_lCalculationType:=<>ld_lTypeToCap
			: ($ld_lWlgLoadingType=<>wlg_lType_LoadToFreeCapacity)
				$ld_lCalculationType:=<>ld_lTypeToFreeCap
			: ($ld_lWlgLoadingType=<>wlg_lType_LoadToCapacity)
				$ld_lCalculationType:=<>ld_lTypeToCap
			: ($ld_lWlgLoadingType=<>wlg_lType_LoadOnlyExtraToCapaci)
				$ld_lCalculationType:=<>ld_lTypeToCap  //AK: 2005-05-03
				$ld_lCalculationOnlyExtratime:=kTrue
			Else 
				$ld_lCalculationType:=$ld_lCalculationType  //don't change
		End case 
	End if 
	
	
	//moves work inside one load group, but does _not_ move work's other work phases  
	$ld_rExtraTime:=0
	Case of 
		: ($ld_lDirection=1)  //forward
			For ($ld_lIndex; $ld_lStartIndex; $ld_lEndIndex)
				IDLE:C311
				
				If (ld_work_asWork_Load_Group_id{$ld_lIndex}=<>w_tRawMaterialLoadGroupId)  //PM: 2006-06-06
					$ld_dMatStartDateTmp:=ld_work_adStart_Date{$ld_lIndex}
					$ld_lMatStartTimeTmp:=ld_work_ahStart_Time{$ld_lIndex}
					$ld_dMatEndDateTmp:=ld_work_adEnd_Date{$ld_lIndex}
					$ld_lMatEndTimeTmp:=ld_work_ahEnd_Time{$ld_lIndex}
				End if 
				
				//AK: 2005-03-30
				Case of 
					: ($ld_lUseExtraTime=kTrue)
						$ld_rExtraTimeHours:=ld_work_arExtra_Hours{$ld_lIndex}
					Else 
						$ld_rExtraTimeHours:=0
				End case 
				
				//AK: 2005-04-20        
				If ($ld_lCalculationOnlyExtratime=kTrue)
					$ld_rSetup_Time:=ld_work_arSetup_Time{$ld_lIndex}
					$ld_rWork_Time:=ld_work_arWork_Time{$ld_lIndex}
					ld_work_arSetup_Time{$ld_lIndex}:=0
					ld_work_arWork_Time{$ld_lIndex}:=0
				End if 
				//        
				Case of 
					: ($ld_lCalculationType=<>ld_lTypeRecalcToCapFromEnd)  //recalculate to capacity (from end)
						$ld_rTime:=_dt ToReal(ld_work_adEnd_Date{$ld_lIndex}; ld_work_ahEnd_Time{$ld_lIndex})
					: ($ld_lCalculationType=<>ld_lTypeRecalcToCapFromStart)  //recalculate to capacity (from start)
						$ld_rTime:=_dt ToReal(ld_work_adStart_Date{$ld_lIndex}; ld_work_ahStart_Time{$ld_lIndex})
						
					: (($ld_lCalculationType=<>ld_lTypeToCap) | ($ld_lCalculationType=<>ld_lTypeToCapFromEnd) | (ld_work_afSubcontract{$ld_lIndex}=True:C214))  //AK: 2004-07-28
						If ($ld_lIndex>$ld_lStartIndex)  //queue starting from 'second' phase
							If (ld_work_afSubcontract{$ld_lIndex-1})  //is subcontract, do not care about it
								ld_work_adStart_Date{$ld_lIndex}:=ld_work_adStart_Date{$ld_lIndex-1}
								ld_work_ahStart_Time{$ld_lIndex}:=ld_work_ahStart_Time{$ld_lIndex-1}
							Else 
								ld_work_adStart_Date{$ld_lIndex}:=ld_work_adEnd_Date{$ld_lIndex-1}
								ld_work_ahStart_Time{$ld_lIndex}:=ld_work_ahEnd_Time{$ld_lIndex-1}
							End if   //            If (ld_work_afSubcontract{$ld_lIndex-1})  `is subcontract, do not ca
							$ld_rTime:=_dt ToReal(ld_work_adStart_Date{$ld_lIndex}; ld_work_ahStart_Time{$ld_lIndex})
							
						Else   //first calculation, set to min allowed time
							$ld_rTime:=$ld_rMinAllowedTime
						End if   //          If ($ld_lIndex>$ld_lStartIndex)  `queue starting from 'second' phase
					: ($ld_lCalculationType=<>ld_lTypeToFreeCap)  //find last free so that cumulative free never goes below zero
						If (ld_work_asWork_Load_Group_id{$ld_lIndex}=<>w_tRawMaterialLoadGroupId)
							$ld_rTime:=$ld_rMinAllowedTime
						Else 
							$ld_rTime:=ld_WorkEndCalculate($ld_lIndex; 1; ld_work_arSetup_Time{$ld_lIndex}+ld_work_arWork_Time{$ld_lIndex}; $ld_lCalcLoadFromCriticalDate)
						End if 
					Else 
						TRACE:C157
						_err MESSAGE_PARAMETER(_lang Current("Wrong calculation type"); Current method name:C684; kFalse)
				End case   //      Case of 
				
				If ($ld_rTime#0)
					
					Case of 
						: ($ld_lCalculationType=<>ld_lTypeRecalcToCapFromEnd)  //repair to capacity (recalculate phase start time)
							If ($ld_rExtraTimeHours#0)  //calculate end time
								ld_WORK_MOVE_EXTRA($ld_lIndex; kTrue; $ld_rTime; $ld_rExtraTimeHours)
								$ld_rEndTime:=_dt ToReal(ld_work_adEnd_Date{$ld_lIndex}; ld_work_ahEnd_Time{$ld_lIndex})
							End if   //            If ($ld_rExtraTimeHours#0)              
							ld_WORK_MOVE($ld_lIndex; kFalse; $ld_rTime)  //move work segment from end 
							ld_EXTRA_HOUR_ARR_SET($ld_lIndex; $ld_rExtraTimeHours)
							
						: ($ld_lCalculationType=<>ld_lTypeRecalcToCapFromStart)  //repair to capacity (recalculate phase end time)
							If ($ld_rExtraTimeHours#0)  //calculate end time
								ld_WORK_MOVE_EXTRA($ld_lIndex; kTrue; $ld_rTime; ld_work_arSetup_Time{$ld_lIndex}+ld_work_arWork_Time{$ld_lIndex}+$ld_rExtraTimeHours)
								$ld_rEndTime:=_dt ToReal(ld_work_adEnd_Date{$ld_lIndex}; ld_work_ahEnd_Time{$ld_lIndex})
							End if   //            If ($ld_rExtraTimeHours#0)
							ld_WORK_MOVE($ld_lIndex; kTrue; $ld_rTime)  //move work segment from start     
							ld_EXTRA_HOUR_ARR_SET($ld_lIndex; $ld_rExtraTimeHours)
							
							
						: (($ld_rTime<=$ld_rMinAllowedTime) | (ld_work_afSubcontract{$ld_lIndex}=True:C214))  //AK: 2004-08-05
							$ld_rTime:=$ld_rMinAllowedTime
							If ($ld_rExtraTimeHours#0)  //calculate end time
								ld_WORK_MOVE_EXTRA($ld_lIndex; kTrue; $ld_rTime; ld_work_arSetup_Time{$ld_lIndex}+ld_work_arWork_Time{$ld_lIndex}+$ld_rExtraTimeHours)
								$ld_rEndTime:=_dt ToReal(ld_work_adEnd_Date{$ld_lIndex}; ld_work_ahEnd_Time{$ld_lIndex})
							End if   //            If ($ld_rExtraTimeHours#0)
							ld_WORK_MOVE($ld_lIndex; kTrue; $ld_rTime)  //move work segment from start
							ld_EXTRA_HOUR_ARR_SET($ld_lIndex; $ld_rExtraTimeHours)
							
						: ($ld_rTime>$ld_rMaxAllowedTime)
							$ld_rTime:=$ld_rMaxAllowedTime
							$ld_rEndTime:=$ld_rMaxAllowedTime
							If ($ld_rExtraTimeHours#0)  //calculate end time
								ld_WORK_MOVE_EXTRA($ld_lIndex; kFalse; $ld_rTime; ld_work_arSetup_Time{$ld_lIndex}+ld_work_arWork_Time{$ld_lIndex})  //from end
								$ld_rTime:=_dt ToReal(ld_work_adStart_Date{$ld_lIndex}; ld_work_ahStart_Time{$ld_lIndex})
								$ld_rEndTime:=_dt ToReal(ld_work_adEnd_Date{$ld_lIndex}; ld_work_ahEnd_Time{$ld_lIndex})
							End if 
							ld_WORK_MOVE($ld_lIndex; kFalse; $ld_rTime)  //move work segment from end   
							ld_EXTRA_HOUR_ARR_SET($ld_lIndex; $ld_rExtraTimeHours)
							
						Else 
							If ($ld_rExtraTimeHours#0)  //calculate end time
								ld_WORK_MOVE_EXTRA($ld_lIndex; kTrue; $ld_rTime; $ld_rExtraTimeHours)  //from end                
								$ld_rEndTime:=_dt ToReal(ld_work_adEnd_Date{$ld_lIndex}; ld_work_ahEnd_Time{$ld_lIndex})
							End if   //            If ($ld_rExtraTimeHours#0)              
							ld_WORK_MOVE($ld_lIndex; kFalse; $ld_rTime)  //move work segment from end     
							ld_EXTRA_HOUR_ARR_SET($ld_lIndex; $ld_rExtraTimeHours)
							$ld_lCalculationType:=<>ld_lTypeToCap  //rest to 'tube'  
							
					End case   //        Case of 
					
					If ($ld_lCalculationType>=0)  //AK: 2004-11-11
						$ld_rTime:=_dt ToReal(ld_work_adStart_Date{$ld_lIndex}; ld_work_ahStart_Time{$ld_lIndex})
						If ($ld_rTime<$ld_rMinAllowedTime)  //recheck min time
							$ld_rTime:=$ld_rMinAllowedTime
							If ($ld_rExtraTimeHours#0)  //calculate end time
								ld_WORK_MOVE_EXTRA($ld_lIndex; kTrue; $ld_rTime; ld_work_arSetup_Time{$ld_lIndex}+ld_work_arWork_Time{$ld_lIndex}+$ld_rExtraTimeHours)  //from end            
								$ld_rEndTime:=_dt ToReal(ld_work_adEnd_Date{$ld_lIndex}; ld_work_ahEnd_Time{$ld_lIndex})
							End if   //            If ($ld_rExtraTimeHours#0)
							ld_WORK_MOVE($ld_lIndex; kTrue; $ld_rTime)  //move work segment from start  
							ld_EXTRA_HOUR_ARR_SET($ld_lIndex; $ld_rExtraTimeHours)
							
						End if   //        If ($ld_rTime<$ld_rMinAllowedTime)  `recheck min time
					End if 
					
					If ($ld_rExtraTimeHours=0)
						$ld_rEndTime:=_dt ToReal(ld_work_adEnd_Date{$ld_lIndex}; ld_work_ahEnd_Time{$ld_lIndex})
					End if 
					$ld_rMinAllowedTime:=$ld_rEndTime
					
				Else 
					_err MESSAGE(_lang Current("Work end time was zero"); Current method name:C684; kFalse)
				End if   //      If ($ld_rTime#0)
				//AK: 2005-04-20        
				If ($ld_lCalculationOnlyExtratime=kTrue)
					ld_work_arSetup_Time{$ld_lIndex}:=$ld_rSetup_Time
					ld_work_arWork_Time{$ld_lIndex}:=$ld_rWork_Time
				End if 
				
				If (ld_work_asWork_Load_Group_id{$ld_lIndex}=<>w_tRawMaterialLoadGroupId)  //PM: 2006-06-06
					ld_MATERIAL_START_END_SET($ld_lIndex; $ld_dMatStartDateTmp; $ld_lMatStartTimeTmp; $ld_dMatEndDateTmp; $ld_lMatEndTimeTmp)
				End if 
				
			End for   //    For ($ld_lIndex;$ld_lStartIndex;$ld_lEndIndex)
			
			
		: ($ld_lDirection=-1)  //backward = end to start
			For ($ld_lIndex; $ld_lStartIndex; $ld_lEndIndex; -1)
				
				If (ld_work_asWork_Load_Group_id{$ld_lIndex}=<>w_tRawMaterialLoadGroupId)  //PM: 2006-06-06
					$ld_dMatStartDateTmp:=ld_work_adStart_Date{$ld_lIndex}
					$ld_lMatStartTimeTmp:=ld_work_ahStart_Time{$ld_lIndex}
					$ld_dMatEndDateTmp:=ld_work_adEnd_Date{$ld_lIndex}
					$ld_lMatEndTimeTmp:=ld_work_ahEnd_Time{$ld_lIndex}
				End if 
				
				//AK: 2005-03-30
				Case of 
					: ($ld_lUseExtraTime=kTrue)
						$ld_rExtraTimeHours:=ld_work_arExtra_Hours{$ld_lIndex}
						//AK: 2006-05-03 commented:
						//          : (((ld_work_arSetup_Time{$ld_lIndex}+ld_work_arWork_Time{$ld_lIndex
						//~})<=0) & (ld_work_afSubcontract{$ld_lIndex}=False) & (ld_work_asWork_Load_Grou
						//~p_id{$ld_lIndex}#<>w_tRawMaterialLoadGroupId))  `recalc $ld_rMinAllowedTime   
						//~     
						//            $ld_rExtraTimeHours:=ld_work_arExtra_Hours{$ld_lIndex}  `remove th
						//~is
					Else 
						$ld_rExtraTimeHours:=0
				End case 
				//AK: 2005-04-20        
				If ($ld_lCalculationOnlyExtratime=kTrue)
					$ld_rSetup_Time:=ld_work_arSetup_Time{$ld_lIndex}
					$ld_rWork_Time:=ld_work_arWork_Time{$ld_lIndex}
					ld_work_arSetup_Time{$ld_lIndex}:=0
					ld_work_arWork_Time{$ld_lIndex}:=0
				End if 
				
				Case of 
					: ($ld_lCalculationType=<>ld_lTypeToCapFromEnd)  //calculate frome end time to capacity
						$ld_rTime:=$ld_rMaxAllowedTime
					: ($ld_lCalculationType=<>ld_lTypeRecalcToCapFromEnd)  //recalculate capacity (from end)
						$ld_rTime:=_dt ToReal(ld_work_adEnd_Date{$ld_lIndex}; ld_work_ahEnd_Time{$ld_lIndex})
					: ($ld_lCalculationType=<>ld_lTypeRecalcToCapFromStart)  //recalculate capacity (from start)
						$ld_rTime:=_dt ToReal(ld_work_adStart_Date{$ld_lIndex}; ld_work_ahStart_Time{$ld_lIndex})
						
					: (($ld_lCalculationType=<>ld_lTypeToCap) | (ld_work_afSubcontract{$ld_lIndex}=True:C214))  //AK: 2004-07-28
						If ($ld_lIndex<$ld_lStartIndex)  //queue starting from 'second'
							If (ld_work_afSubcontract{$ld_lIndex+1})  //is subcontract, do not care about it
								ld_work_adEnd_Date{$ld_lIndex}:=ld_work_adEnd_Date{$ld_lIndex+1}
								ld_work_ahEnd_Time{$ld_lIndex}:=ld_work_ahEnd_Time{$ld_lIndex+1}
							Else   //end set to previous start
								ld_work_adEnd_Date{$ld_lIndex}:=ld_work_adStart_Date{$ld_lIndex+1}
								ld_work_ahEnd_Time{$ld_lIndex}:=ld_work_ahStart_Time{$ld_lIndex+1}
							End if   //            If (ld_work_afSubcontract{$ld_lIndex+1})  `is subcontract, do not ca
						End if 
				End case   //      Case of 
				
				
				Case of 
					: ($ld_lCalculationType=<>ld_lTypeToCapFromEnd)  //calculate from end time to capacity (not from extra time to cap)
						//called from: ldfl_WorkMovedCallb when moving phases manually
						If ($ld_rExtraTimeHours#0)  //calculate end 
							ld_WORK_MOVE_EXTRA($ld_lIndex; kTrue; $ld_rTime; $ld_rExtraTimeHours)
						End if 
						ld_WORK_MOVE($ld_lIndex; kFalse; $ld_rTime)
						ld_EXTRA_HOUR_ARR_SET($ld_lIndex; $ld_rExtraTimeHours)
						
					: ($ld_lCalculationType=<>ld_lTypeRecalcToCapFromEnd)  //repair to capacity (recalculate phase start time)
						If ($ld_rExtraTimeHours#0)  //calculate end time
							ld_WORK_MOVE_EXTRA($ld_lIndex; kTrue; $ld_rTime; $ld_rExtraTimeHours)
						End if   //            If ($ld_rExtraTimeHours#0)              
						ld_WORK_MOVE($ld_lIndex; kFalse; $ld_rTime)  //move work segment from end 
						ld_EXTRA_HOUR_ARR_SET($ld_lIndex; $ld_rExtraTimeHours)
						
					: ($ld_lCalculationType=<>ld_lTypeRecalcToCapFromStart)  //repair to capacity (recalculate phase end time)
						If ($ld_rExtraTimeHours#0)  //calculate end time
							ld_WORK_MOVE_EXTRA($ld_lIndex; kTrue; $ld_rTime; ld_work_arSetup_Time{$ld_lIndex}+ld_work_arWork_Time{$ld_lIndex}+$ld_rExtraTimeHours)
						End if   //            If ($ld_rExtraTimeHours#0)
						ld_WORK_MOVE($ld_lIndex; kTrue; $ld_rTime)  //move work segment from start  
						ld_EXTRA_HOUR_ARR_SET($ld_lIndex; $ld_rExtraTimeHours)
						
					Else 
						
						If ($ld_rMaxAllowedTime<=$ld_rMinAllowedTime)
							$ld_rTime:=$ld_rMinAllowedTime
							If ($ld_rExtraTimeHours#0)  //calculate end time
								ld_WORK_MOVE_EXTRA($ld_lIndex; kTrue; $ld_rTime; ld_work_arSetup_Time{$ld_lIndex}+ld_work_arWork_Time{$ld_lIndex}+$ld_rExtraTimeHours)
							End if   //            If ($ld_rExtraTimeHours#0)                
							ld_WORK_MOVE($ld_lIndex; kTrue; $ld_rTime)  //from start 
							ld_EXTRA_HOUR_ARR_SET($ld_lIndex; $ld_rExtraTimeHours)
							
						Else 
							//          If ($ld_rTime<$ld_rMaxAllowedTime)
							$ld_rTime:=$ld_rMaxAllowedTime
							// End if   `          If ($ld_rTime<=$ld_rMaxAllowedTime)
							If ($ld_rExtraTimeHours#0)
								ld_WORK_MOVE_EXTRA($ld_lIndex; kFalse; $ld_rTime; $ld_rExtraTimeHours)
								$ld_rTime:=_dt ToReal(ld_work_adStart_Date{$ld_lIndex}; ld_work_ahStart_Time{$ld_lIndex})
								$ld_rMaxAllowedTime:=$ld_rTime
							End if 
							If (($ld_lCalculationType=<>ld_lTypeToFreeCap) & (ld_work_afSubcontract{$ld_lIndex}=False:C215))  //$ld_lCalculationType=<>ld_lTypeToFreeCap =free capacity
								Case of 
									: ((ld_work_arSetup_Time{$ld_lIndex}+ld_work_arWork_Time{$ld_lIndex})<0)
										ld_WORK_MOVE($ld_lIndex; kFalse; $ld_rTime)  //from end
										_info MESSAGE(kError; _lang Current("Work time was less than zero")+". "+ksCR+_lang Current("Work Load Group")+": "+ld_work_asWork_Load_Group_id{$ld_lIndex}+" ("+ld_work_asProduction_Lot__work_{$ld_lIndex}+")"; _lang Current("Backward Loading"); kFalse)
									: ((ld_work_arSetup_Time{$ld_lIndex}+ld_work_arWork_Time{$ld_lIndex})=0)
										ld_WORK_MOVE($ld_lIndex; kFalse; $ld_rTime)  //from end
									Else 
										$ld_rFreeCumulativeCapacity:=ldcap_FreeHoursGet(ld_work_asWork_Load_Group_id{$ld_lIndex}; $ld_rTime; kTrue; $ld_lCalcLoadFromCriticalDate)
										If ($ld_rFreeCumulativeCapacity>=(ld_work_arSetup_Time{$ld_lIndex}+ld_work_arWork_Time{$ld_lIndex}))
											If (True:C214)
												ld_WORK_MOVE($ld_lIndex; kFalse; $ld_rTime)  //from end                  
											Else 
												$ld_rSetupTime_tmp:=ld_work_arSetup_Time{$ld_lIndex}  //just to be sure
												$ld_rWorkTime_tmp:=ld_work_arWork_Time{$ld_lIndex}
												ld_work_arWork_Time{$ld_lIndex}:=ld_work_arWork_Time{$ld_lIndex}-$ld_rFreeCumulativeCapacity
												$ld_rTime:=ld_WorkEndCalculate($ld_lIndex; 1; ld_work_arSetup_Time{$ld_lIndex}+ld_work_arWork_Time{$ld_lIndex}; $ld_lCalcLoadFromCriticalDate)  //$3 = $ld_rMinLengthNeeded
												ld_work_arSetup_Time{$ld_lIndex}:=$ld_rSetupTime_tmp
												ld_work_arWork_Time{$ld_lIndex}:=$ld_rWorkTime_tmp
												ld_WORK_MOVE($ld_lIndex; kTrue; $ld_rTime)  //from start
												
												If ($ld_rTime>$ld_rMaxAllowedTime)
													ld_WORK_MOVE($ld_lIndex; kFalse; $ld_rMaxAllowedTime)  //from end
												End if 
												
											End if 
										Else 
											ld_WORK_MOVE($ld_lIndex; kFalse; $ld_rTime)  //from end
											_info MESSAGE(kInfo; _lang Current("Free capacity was not found")+". "+ksCR+_lang Current("Work Load Group")+": "+ld_work_asWork_Load_Group_id{$ld_lIndex}+" ("+ld_work_asProduction_Lot__work_{$ld_lIndex}+")"; _lang Current("Backward Loading"); kFalse)
										End if 
								End case 
							Else 
								ld_WORK_MOVE($ld_lIndex; kFalse; $ld_rTime)  //from end  
							End if 
							ld_EXTRA_HOUR_ARR_SET($ld_lIndex; $ld_rExtraTimeHours)
							
						End if   //        If ($ld_rMaxAllowedTime<=$ld_rMinAllowedTime)
						
						If ($ld_rMaxAllowedTime<$ld_rMinAllowedTime)  //recheck min time
							$ld_rTime:=$ld_rMinAllowedTime
							If ($ld_rExtraTimeHours#0)  //calculate end time
								ld_WORK_MOVE_EXTRA($ld_lIndex; kTrue; $ld_rTime; ld_work_arSetup_Time{$ld_lIndex}+ld_work_arWork_Time{$ld_lIndex}+$ld_rExtraTimeHours)
							End if   //            If ($ld_rExtraTimeHours#0)                          
							ld_WORK_MOVE($ld_lIndex; kTrue; $ld_rTime)  //from start   
							ld_EXTRA_HOUR_ARR_SET($ld_lIndex; $ld_rExtraTimeHours)
							
						End if   //        If ($ld_rMaxAllowedTime<$ld_rMinAllowedTime)  `recheck min time
				End case 
				$ld_rStartTime:=_dt ToReal(ld_work_adStart_Date{$ld_lIndex}; ld_work_ahStart_Time{$ld_lIndex})
				$ld_rMaxAllowedTime:=$ld_rStartTime
				
				//AK: 2005-04-20        
				If ($ld_lCalculationOnlyExtratime=kTrue)
					ld_work_arSetup_Time{$ld_lIndex}:=$ld_rSetup_Time
					ld_work_arWork_Time{$ld_lIndex}:=$ld_rWork_Time
				End if 
				
				If (ld_work_asWork_Load_Group_id{$ld_lIndex}=<>w_tRawMaterialLoadGroupId)  //PM: 2006-06-06
					ld_MATERIAL_START_END_SET($ld_lIndex; $ld_dMatStartDateTmp; $ld_lMatStartTimeTmp; $ld_dMatEndDateTmp; $ld_lMatEndTimeTmp)
				End if 
				
			End for   //    For ($ld_lIndex;$ld_lStartIndex;$ld_lEndIndex;-1)
			
		Else 
			_err MESSAGE_PARAMETER(_lang Current("Wrong direction parameter"); Current method name:C684; kFalse)
	End case   //Case of 
	
	//AK: 2004-11-01
	If ($ld_lWlgLoadingType=<>wlg_lType_NotLoaded)
		If (ld_work_asWork_Load_Group_id{$ld_lStartIndex}#<>w_tRawMaterialLoadGroupId)  //PM: 2006-11-09
			//  if added because raw material extra time was not used
			Case of   //return previous values
				: ($ld_lDirection=1)
					$ld_rMinAllowedTime:=$6
				: ($ld_lDirection=-1)
					$ld_rMaxAllowedTime:=$7
				Else 
					$ld_rMinAllowedTime:=$6
			End case   //Case of      
		End if 
	End if 
	
End if 

Case of 
	: ($ld_lDirection=1)
		$0:=$ld_rMinAllowedTime
	: ($ld_lDirection=-1)
		$0:=$ld_rMaxAllowedTime
	Else 
		$0:=$ld_rMinAllowedTime
End case   //Case of 

If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStop; Current method name:C684)
End if 
