//%attributes = {}
// Method: ld_WORK_MOVE_CALCULATE
// 2004.02.17-02:13:23 / Pasi Mankinen
// © Copyright 2004 Manage Applications
// Purpose: 
// 
// ------------------------------------------------------------

//TO DO: tutki osuuko tismaalleen kapasiteetin rajalle, jos osuu niin siirrä
//seuraavan / edellisen kapasiteetin sopivaan kohtaan

If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStart; Current method name:C684)
End if 

C_LONGINT:C283($1; $ld_lFromStart; $ld_lCapIndex; $ld_lWorkStartFound; $ld_lCapArrSize)
C_REAL:C285($3; $ld_rWorkTime; $4; $ld_rMovedDateTime; $ld_rWorkStart; $ld_rWorkEnd; $ld_rWorkTime; $ld_rWorkTimeRemaining; $ld_rPhaseTimeRemaining; $ld_rMultiplier)  //new datetime
C_TEXT:C284($2; $ld_tLoadGroup; $7; $ld_tProdLotPhase)
C_POINTER:C301($5; $ld_pStartDateTime; $6; $ld_pEndDateTime)
C_REAL:C285($8; $ld_rPhaseLoadMultiplier)
C_DATE:C307($ld_dWorkDate)
//COMPILER_ld_ 
//COMPILER_ldc_   `load capasity
//COMPILER_ldf_   `fine load
$ld_lFromStart:=$1
$ld_tLoadGroup:=$2
$ld_rWorkTime:=$3
$ld_rMovedDateTime:=$4
$ld_pStartDateTime:=$5
$ld_pEndDateTime:=$6
$ld_tProdLotPhase:=$7  //for error messages only
$ld_rPhaseLoadMultiplier:=$8

$ld_rExtraTimeMultiplierStatic:=0  //use only capacity multipliers
$ld_rExtraTimeMultiplierMax:=0  //use only capacity multipliers

ld_wlg_ARR_LOAD
ldcap_ARR_LOAD_SAVE(kLoad; $ld_tLoadGroup; kFalse)


//find next capacity containing capacity
$ld_lCapIndex:=ldcap_IndexNextCapacity($ld_tLoadGroup; $ld_rMovedDateTime; $ld_lFromStart; $ld_tProdLotPhase)

If ($ld_lCapIndex<1)
	IDLE:C311
	//_err MESSAGE (_lang Current ("Capacity not found");Current method name;kFalse 
	//~)
Else 
	$ld_lCapArrSize:=ldcap_ CapacityArrSize
	
	$ld_rWorkTimeRemaining:=$ld_rWorkTime
	//move to first possible place
	$ld_rMovedDateTime:=ldcap_TimeToCapacityMove($ld_lCapIndex; $ld_rMovedDateTime)  //;$ld_lFromStart)
	$ld_rWorkStart:=$ld_rMovedDateTime
	
	While ($ld_rWorkTimeRemaining>0)
		IDLE:C311
		If ($ld_lFromStart=kTrue)
			$ld_rPhaseTimeRemaining:=_dt Difference(ldcap_arEnd{$ld_lCapIndex}; $ld_rWorkStart)
		Else 
			$ld_rPhaseTimeRemaining:=_dt Difference($ld_rWorkStart; ldcap_arStart{$ld_lCapIndex})
		End if 
		$ld_rMultiplier:=ldcap_PhaseTimeMultiplier($ld_lCapIndex; $ld_rPhaseLoadMultiplier; $ld_tLoadGroup)
		
		$ld_rPhaseTimeRemaining:=$ld_rPhaseTimeRemaining*$ld_rMultiplier
		Case of 
			: ($ld_rWorkTimeRemaining<$ld_rPhaseTimeRemaining)
				//PM: 2004-12-24 : was: ($ld_rWorkTimeRemaining<=$ld_rPhaseTimeRemaining)
				If ($ld_lFromStart=kTrue)  //from start
					$ld_rWorkStart:=$ld_rWorkStart+_dt HoursToReal($ld_rWorkTimeRemaining/$ld_rMultiplier)
				Else 
					$ld_rWorkStart:=$ld_rWorkStart-_dt HoursToReal($ld_rWorkTimeRemaining/$ld_rMultiplier)
				End if 
				$ld_rWorkTimeRemaining:=0  //end loop                
			: (($ld_rWorkTimeRemaining=$ld_rPhaseTimeRemaining) & ($ld_lFromStart=kTrue))
				//from start
				$ld_rWorkStart:=$ld_rWorkStart+_dt HoursToReal($ld_rWorkTimeRemaining/$ld_rMultiplier)
				$ld_rWorkTimeRemaining:=0  //end loop        
			Else 
				//loop to next/previous capacity        
				$ld_rWorkTimeRemaining:=$ld_rWorkTimeRemaining-$ld_rPhaseTimeRemaining
				$ld_lWorkStartFound:=kFalse
				Repeat 
					If ($ld_lFromStart=kTrue)  //from start
						$ld_lCapIndex:=$ld_lCapIndex+1
						If ($ld_lCapIndex>$ld_lCapArrSize)
							$ld_tErr:=_lang Current(", load group: ")+$ld_tLoadGroup+_lang Current(", work time: ")+String:C10($ld_rWorkTime)+_lang Current(", work phase")+": "+$ld_tProdLotPhase
							$ld_dWorkDate:=_dt RealToDate($ld_rWorkStart)
							$ld_dCapDate:=_dt RealToDate(ldcap_arStart{$ld_lCapArrSize})
							_err MESSAGE(_lang Current("Capacity not found, work remaining date is bigger than capacity last date")+$ld_tErr+ksSpace+String:C10($ld_dWorkDate)+" < "+String:C10($ld_dCapDate)+$ld_tErr; Current method name:C684; kFalse)
							$ld_rWorkTimeRemaining:=0  //end loop
							$ld_lWorkStartFound:=kTrue
						Else 
							If (ldcap_arStart{$ld_lCapIndex}<ldcap_arEnd{$ld_lCapIndex-1})
								$ld_tErr:=_lang Current(", load group: ")+$ld_tLoadGroup+_lang Current(", work time: ")+String:C10($ld_rWorkTime)+_lang Current(", work phase")+": "+$ld_tProdLotPhase
								_err MESSAGE(_lang Current("Overlapping capacity")+": "+ldcap_tCapacityPrfName+", "+String:C10(_dt RealToDate(ldcap_arStart{$ld_lCapIndex}))+$ld_tErr; Current method name:C684; kFalse)
							End if 
							If (ldcap_PhaseTimeMultiplier($ld_lCapIndex; $ld_rPhaseLoadMultiplier; $ld_tLoadGroup)#0)
								$ld_lWorkStartFound:=kTrue
								$ld_rWorkStart:=ldcap_arStart{$ld_lCapIndex}
							End if 
						End if 
					Else 
						$ld_lCapIndex:=$ld_lCapIndex-1
						If ($ld_lCapIndex<1)
							$ld_tErr:=_lang Current(", load group: ")+$ld_tLoadGroup+_lang Current(", work time: ")+String:C10($ld_rWorkTime)+_lang Current(", work phase")+": "+$ld_tProdLotPhase
							$ld_dWorkDate:=_dt RealToDate($ld_rWorkStart)
							$ld_dCapDate:=_dt RealToDate(ldcap_arStart{1})
							_err MESSAGE(_lang Current("Capacity not found, work remaining date is smaller than capacity first date")+$ld_tErr+ksSpace+String:C10($ld_dWorkDate)+" > "+String:C10($ld_dCapDate)+$ld_tErr; Current method name:C684; kFalse)
							
							$ld_rWorkTimeRemaining:=0  //end loop
							$ld_lWorkStartFound:=kTrue
						Else 
							If (ldcap_PhaseTimeMultiplier($ld_lCapIndex; $ld_rPhaseLoadMultiplier; $ld_tLoadGroup)#0)
								$ld_lWorkStartFound:=kTrue
								$ld_rWorkStart:=ldcap_arEnd{$ld_lCapIndex}
							End if 
						End if 
					End if 
				Until ($ld_lWorkStartFound=kTrue)
		End case 
	End while 
	
	If ($ld_lFromStart=kTrue)
		$ld_rWorkEnd:=$ld_rWorkStart  //we use $ld_rWorkStart when calculating end time
		$ld_rWorkStart:=$ld_rMovedDateTime
	Else 
		$ld_rWorkEnd:=$ld_rMovedDateTime
		//already calculated: $ld_rWorkStart
	End if 
	If ($ld_rWorkEnd<$ld_rWorkStart)
		$ld_tErr:=_lang Current(", load group: ")+$ld_tLoadGroup+_lang Current(", work time: ")+String:C10($ld_rWorkTime)+_lang Current(", work phase")+": "+$ld_tProdLotPhase
		_err MESSAGE(_lang Current("Work calculation problem, work end time is smaller than start time")+$ld_tErr; Current method name:C684; kFalse)
		$ld_rWorkEnd:=$ld_rWorkStart
	End if 
	$ld_pStartDateTime->:=$ld_rWorkStart
	$ld_pEndDateTime->:=$ld_rWorkEnd
End if 

If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStop; Current method name:C684)
End if 
