//%attributes = {}
// Method: ld_CapBetweenGet
// 2004.11.04-23:33:17 / Pasi Mankinen + AK
// © Copyright 2004 Manage Applications
// Purpose: 
// 
// ------------------------------------------------------------
C_REAL:C285($0; $ld_rCapacity; $2; $ld_rStartTime; $3; $ld_rEndTime; $ld_rMultiplier)
C_TEXT:C284($1; $ld_tLoadGroup; $4; $ld_tWorkId; $ld_tErr)  //load group
C_LONGINT:C283($ld_lCapIndex; $ld_lCapFirst; $ld_lCapArrSize; $ld_lCapFirstIndex; $ld_lCapEndIndex)
// COMPILER_ld_ 
// COMPILER_ld_cap_   `load capasity, caled in: ld_CAP_ARR_LOAD_SAVE

$ld_rCapacity:=0

If (<>ld_lCumulativeCapCalculate=kTrue)
	$ld_tLoadGroup:=$1
	$ld_rStartTime:=$2
	$ld_rEndTime:=$3
	$ld_tWorkId:=$4
	ldcap_ARR_LOAD_SAVE(kLoad; $ld_tLoadGroup; kFalse)
	
	$ld_dCapacityStartDate:=_dt RealToDate($ld_rStartTime)
	
	$ld_lCapFirst:=ldcap_IndexFirst($ld_tLoadGroup; $ld_dCapacityStartDate)
	$ld_lCapArrSize:=ldcap_ CapacityArrSize
	Case of 
		: ($ld_lCapArrSize<1)
			_err MESSAGE(_lang Current("Capasity array size is zero for load group")+": "+ksQuoteStart+$ld_tLoadGroup+ksQuoteEnd; Current method name:C684; kFalse)
		: ($ld_rEndTime<$ld_rStartTime)
			_err MESSAGE(_lang Current("Needed capacity end time is smaller than needed capacity start time")+_lang Current(", work: ")+$ld_tWorkId+_dt RealToDateTimeString($ld_rStartTime)+" > "+_dt RealToDateTimeString($ld_rEndTime)+_lang Current(", load group: ")+$ld_tLoadGroup+_lang Current(", capacity start time: ")+String:C10(ldcap_adStartDate{1}); Current method name:C684; kFalse)
		: ($ld_lCapFirst<1)
			_err MESSAGE(_lang Current("Needed capacity start time is smaller than capacity start time")+_lang Current(", work: ")+$ld_tWorkId+String:C10($ld_dCapacityStartDate)+" / "+_lang Current(", load group: ")+$ld_tLoadGroup+": "+String:C10(ldcap_adStartDate{1}); Current method name:C684; kFalse)
		Else 
			//deal with start time part of capacity:
			//should be like this (test):
			// ld_arCapStart{$ld_lCapFirst}<= $ld_rStartTime <=ld_arCapEnd{$ld_lCapFirst}
			//$ld_rCapacity:=$ld_rCapacity+
			
			If (False:C215)
				_err FIX("make new ld_CapIndexFirst that cheks time by real, not by date")
				_err FIX("include this code to that new function")
			End if 
			
			If (cap_ ArrLoadType($ld_tLoadGroup)=2)
				cap_LG_START_END_INDEX_GET($ld_tLoadGroup; ->$ld_lCapFirstIndex; ->$ld_lCapEndIndex)
			Else 
				$ld_lCapFirstIndex:=0
			End if 
			Repeat 
				$ld_lCapIndex:=$ld_lCapFirstIndex  //1  //continue loop
				
				Case of 
					: ($ld_lCapFirst<1)
						$ld_lCapIndex:=0  // exit loop
						$ld_tErr:=_lang Current("First capacity start time is bigger than needed capacity start, capacity")+": "+ldcap_tCapacityName+ksSpace
						$ld_tErr:=$ld_tErr+String:C10($ld_dCapacityStartDate)+" > "+String:C10(ldcap_adStartDate{1})
						$ld_tErr:=$ld_tErr+_lang Current(", load group: ")+$ld_tLoadGroup+_lang Current(", work: ")+$ld_tWorkId
						_err MESSAGE($ld_tErr; Current method name:C684; kFalse)
						
					: ($ld_rEndTime<ldcap_arStart{$ld_lCapIndex})
						$ld_lCapFirst:=$ld_lCapFirst-1  //go to previous capacity                
						
					: ($ld_rStartTime<ldcap_arStart{$ld_lCapFirst})
						$ld_lCapFirst:=$ld_lCapFirst-1  //go to previous capacity     
						
					: ($ld_rStartTime>ldcap_arEnd{$ld_lCapFirst})
						$ld_lCapFirst:=$ld_lCapFirst+1  //come back to next capacity            
						$ld_lCapIndex:=0  // exit loop  
					Else 
						$ld_lCapIndex:=0  // exit loop
				End case 
			Until ($ld_lCapIndex=0)
			
			If ($ld_lCapFirst>0)
				
				For ($ld_lCapIndex; $ld_lCapFirst; $ld_lCapArrSize)  //count capacity between dates
					Case of 
						: ($ld_rEndTime<ldcap_arStart{$ld_lCapIndex})
							$ld_lCapIndex:=$ld_lCapArrSize+1  //end loop     
						: (($ld_rStartTime<=ldcap_arStart{$ld_lCapIndex}) & ($ld_rEndTime>=ldcap_arEnd{$ld_lCapIndex}))
							$ld_rCapacity:=$ld_rCapacity+ldcap_arCapacity{$ld_lCapIndex}
						: (($ld_rStartTime>=ldcap_arStart{$ld_lCapIndex}) & ($ld_rEndTime<=ldcap_arEnd{$ld_lCapIndex}))  //inside one shift
							$ld_rMultiplier:=($ld_rEndTime-$ld_rStartTime)/(ldcap_arEnd{$ld_lCapIndex}-ldcap_arStart{$ld_lCapIndex})
							$ld_rCapacity:=$ld_rCapacity+(ldcap_arCapacity{$ld_lCapIndex}*$ld_rMultiplier)
							$ld_lCapIndex:=$ld_lCapArrSize+1  //end loop 
						: ($ld_rStartTime>ldcap_arStart{$ld_lCapIndex})
							//first capacity starts before StartTime          
							If ((ldcap_arEnd{$ld_lCapIndex}-ldcap_arStart{$ld_lCapIndex})#0)
								$ld_rMultiplier:=(ldcap_arEnd{$ld_lCapIndex}-$ld_rStartTime)/(ldcap_arEnd{$ld_lCapIndex}-ldcap_arStart{$ld_lCapIndex})
							Else 
								$ld_rMultiplier:=0
							End if 
							$ld_rCapacity:=$ld_rCapacity+(ldcap_arCapacity{$ld_lCapIndex}*$ld_rMultiplier)
						: ($ld_rEndTime<ldcap_arEnd{$ld_lCapIndex})
							//last capacity starts before EndTime but ends after EndTime           
							If ((ldcap_arEnd{$ld_lCapIndex}-ldcap_arStart{$ld_lCapIndex})#0)
								$ld_rMultiplier:=($ld_rEndTime-ldcap_arStart{$ld_lCapIndex})/(ldcap_arEnd{$ld_lCapIndex}-ldcap_arStart{$ld_lCapIndex})
							Else 
								$ld_rMultiplier:=0
							End if 
							$ld_rCapacity:=$ld_rCapacity+(ldcap_arCapacity{$ld_lCapIndex}*$ld_rMultiplier)
							
							$ld_lCapIndex:=$ld_lCapArrSize+1  //end loop 
						Else 
							TRACE:C157
					End case 
				End for 
				
			End if 
	End case 
End if 
$0:=$ld_rCapacity
