//%attributes = {}
// Method: ldcap_BlobLoad
// 2009.02.27-15:20:01 / Pasi Mankinen
// © Copyright 2009 Manage Applications
// Purpose: 
// see: ldcap_BLOB_SAVE
// ------------------------------------------------------------
If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStart; Current method name:C684)
End if 

C_LONGINT:C283($0; $ld_lIndex; $3; $ld_lForceLoad_Save; $ld_lLength)
C_TEXT:C284($1; $ld_tLoadGroup; $2; $ld_tPrfName; $ld_tPrefix)
//COMPILER_ld_cap_
COMPILER_cap_

$0:=kFalse  //was not found from blob
$ld_tLoadGroup:=$1
$ld_tPrfName:=$2
$ld_lForceLoad_Save:=$3
$ld_tPrefix:=ldcap_ PrfNamePrefix($ld_tLoadGroup)

If (Size of array:C274(ldcap_atBlobAllPrfName)<1)
	_prf_ NAME_TO_ARR("ld_Capacity_"+ksWildcard; ->ldcap_atBlobAllPrfName)
	If (cap_ ArrLoadType("")>0)
		ARRAY TEXT:C222($ldcap_atBlobAllPrfName; 0)
		_prf_ NAME_TO_ARR(<>cap_tPrfNamePrefix+ksWildcard; ->$ldcap_atBlobAllPrfName)
		_arr UNION(->ldcap_atBlobAllPrfName; ->$ldcap_atBlobAllPrfName; ->ldcap_atBlobAllPrfName)
	End if 
End if 

C_LONGINT:C283($ldcap_lLoadType)
$ld_lLoadType:=cap_ ArrLoadType($ld_tLoadGroup)
Case of 
	: ($ld_lLoadType=0)
		$ld_lIndex:=Find in array:C230(ldcap_atBlobAllPrfName; $ld_tPrfName)
		If ($ld_lIndex<1)
			$ld_tPrfName:="ld_Capacity_Default"
		End if 
	: ($ld_lLoadType=1)  // ak 2013-05-08
		$ld_lIndex:=Find in array:C230(ldcap_atBlobAllPrfName; $ld_tPrfName)
		If ($ld_lIndex<1) | ($ld_lForceLoad_Save=kTrue)
			ldcap_ NEXT_LOAD_FORCE
		End if 
	Else 
		
End case 

Case of 
	: (cap_lCacheInUse=0)  // calculate always
	: (ldcap_tCapacityPrfName=$ld_tPrfName)
		$0:=kTrue
	: (cap_lCacheInUse=-1)  // calculate if ldcap_tCapacityPrfName # $ld_tPrfName
	Else 
		$ld_lIndex:=Find in array:C230(ldcap_atBlobCapacity; $ld_tPrfName)
		If ($ld_lIndex>0)
			
			If (<>_info_ fProfile)
				_info_ CALL_PROFILE(kStart; Current method name:C684+" - real load")
			End if 
			$ld_lPosStart:=ldcap_alBlobStartPos{$ld_lIndex}
			$ld_lLength:=ldcap_alBlobEndPos{$ld_lIndex}-$ld_lPosStart+1
			
			SET BLOB SIZE:C606(ldcap_xBlobTmp; 0)
			COPY BLOB:C558(ldcap_xBlobLoadGroupAll; ldcap_xBlobTmp; $ld_lPosStart; 0; $ld_lLength)
			_blob_ COMPRESS(kGet; ->ldcap_xBlobTmp)  //blobs are generally 150 - 200 kb, will take much memory if not compressed
			
			If (_arr apBlob(kLoad; ->ldcap_xBlobTmp; ->ldcap_apCapArr)=kFalse)
				_err MESSAGE(_lang Current("Capacity arrays could not be loaded from blob")+": "+ksQuoteStart+$ld_tLoadGroup+"|"+$ld_tPrfName+ksQuoteEnd; Current method name:C684; kFalse)
			Else 
				$0:=kTrue  //was found and loaded from blob
				ldcap_tCapacityPrfName:=$ld_tPrfName
			End if 
			If (<>_info_ fProfile)
				_info_ CALL_PROFILE(kStop; Current method name:C684+" - real load")
			End if 
			
		End if 
End case 

If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStop; Current method name:C684)
End if 
