//%attributes = {}
// Method: tree_UPDATE
// 2002.11.05-20:19:36 / Pasi Mankinen
// © Copyright 2002 Manage Applications
// Purpose: 
// 
// ------------------------------------------------------------
C_LONGINT:C283($1; $2)

tree_lCells:=Size of array:C274(tree_asTreeStructure)
ARRAY INTEGER:C220(tree_aiGraph; tree_lCells; tree_lBars)
SET CURSOR:C469(kCursorWatch)


C_TEXT:C284(tree_tRef; tree_tRect)
C_TEXT:C284($tree_tTxt; $tree_tFont; $tree_tBarBorderColor; $tree_tBarColor)

C_LONGINT:C283($tree_lCellIndex; $tree_lColIndex; $tree_lColCount; $tree_lCellIndex; $tree_lCellCount; $tree_lMaxDepth; $tree_lInSameDepth)
C_LONGINT:C283($tree_lAreaWidth; $tree_lAreaHeigth)
C_LONGINT:C283(tree_lCellWidth; tree_lCellHeigth; tree_lMargin; $tree_lPosWidth; $tree_lPosHeigth; $tree_lLeft)
C_LONGINT:C283($tree_lDepthIndex; $tree_lDepth; $tree_lDepthIndex; $tree_lDrawLine)

C_LONGINT:C283($tree_lCellFullLoadLine; $tree_lCellFullLoadLineGap; $tree_lCellBarLeft1; $tree_lCellBarLeft2; $tree_lCellBarWidth; $tree_lBarTop; $tree_lBarHeigth; $tree_lPixels)

C_REAL:C285($tree_rCellFullLoadPercent; $tree_rCellBarLeftPercent)
C_REAL:C285($tree_rCellBarWidthPercent; $tree_rCellBarGapPercent; $tree_rCellFullLoadGapPercent)

C_REAL:C285($tree_rBorderWidth; $tree_rTxtFromBorder; $tree_rFontSize)

$tree_rCellFullLoadPercent:=0.5  //100-60% = 40% from top
$tree_rCellBarLeftPercent:=0.3  //30%
$tree_rCellBarWidthPercent:=0.25  //25%
$tree_rCellBarGapPercent:=0.01  //1%
$tree_rCellFullLoadGapPercent:=0.05  //5%
//30+20=50+5+30=85% = 2. bar right

//trS_TEXT ARRAY (tree_lplgArea;tree_atText)
//trS_GRAPH ARRAY (tree_lplgArea;tree_aiGraph;tree_lBars)
//trS_ID ARRAY (tree_lplgArea;tree_asTreeStructure)

$tree_lCellCount:=tree_lCells

tree_lCellWidth:=200
tree_lCellHeigth:=56
tree_lMargin:=10
tree_lCellHeigthGap:=4
tree_lCellWidthGap:=40

$tree_rTxtFromBorder:=3
$tree_tFont:=_fi IncludeFontName
$tree_rFontSize:=_fi DialogFontSize

//calculate max depth and every cell depth
ARRAY LONGINT:C221($tree_alDepth; $tree_lCellCount)
$tree_lMaxDepth:=0
For ($tree_lCellIndex; 1; $tree_lCellCount)
	$tree_alDepth{$tree_lCellIndex}:=_str AsciiCount(tree_asTreeStructure{$tree_lCellIndex}; ".")
	If ($tree_lMaxDepth<$tree_alDepth{$tree_lCellIndex})
		$tree_lMaxDepth:=$tree_alDepth{$tree_lCellIndex}
	End if 
End for 
$tree_lPosWidth:=tree_lMargin+($tree_lMaxDepth*(tree_lCellWidthGap+tree_lCellWidth))

//_var_ OBJECT_SIZE_GET (->tree_gArea;->$tree_lAreaWidth;->$tree_lAreaHeigth)
$tree_lAreaWidth:=$tree_lPosWidth+tree_lCellWidth+(tree_lMargin*2)
$tree_lAreaHeigth:=($tree_lCellCount*(tree_lCellHeigth+tree_lCellHeigthGap))+(tree_lMargin*2)  //too big if net is same level as parent
tree_tRef:=SVG_New($tree_lAreaWidth; $tree_lAreaHeigth; "Tree"; "Tree"; True:C214; Truncated non centered:K6:4)

//draw white box on background
$tree_rBorderWidth:=0
tree_tRect:=SVG_New_rect(tree_tRef; 0; 0; $tree_lAreaWidth; $tree_lAreaHeigth; 0; 0; "black"; "white"; $tree_rBorderWidth)

$tree_lCellFullLoadLine:=Round:C94(tree_lCellHeigth*$tree_rCellFullLoadPercent; 0)
$tree_lCellFullLoadLineGap:=Round:C94(tree_lCellWidth*$tree_rCellFullLoadGapPercent; 0)

$tree_lCellBarLeft1:=Round:C94(tree_lCellWidth*$tree_rCellBarLeftPercent; 0)
$tree_lCellBarWidth:=Round:C94(tree_lCellWidth*$tree_rCellBarWidthPercent; 0)
$tree_lCellBarLeft2:=$tree_lCellBarLeft1+$tree_lCellBarWidth+Round:C94(tree_lCellWidth*$tree_rCellBarGapPercent; 0)

$tree_rBorderWidth:=0.25
$tree_lPosWidth:=tree_lMargin
$tree_lPosHeigth:=0


ARRAY LONGINT:C221(tree_alGraph; $tree_lCellCount; 9)  //should be declared before
//_arr CLEAR_2D (0;->tree_alGraph) 

ARRAY LONGINT:C221($tree_alDepthFirstHeigth; 0)
$tree_lDepthIndex:=0

$tree_lInSameDepth:=0
$tree_lPosHeigth:=tree_lMargin
For ($tree_lCellIndex; 1; $tree_lCellCount)
	
	If ($tree_lCellIndex>1)  //keep .001 -element at the same level as parent
		If ($tree_alDepth{$tree_lCellIndex}#($tree_alDepth{$tree_lCellIndex-1}+1))
			//=  (_str LastPart (tree_asTreeStructure{$tree_lCellIndex};".")="001") ?
			$tree_lPosHeigth:=$tree_lPosHeigth+tree_lCellHeigth+tree_lCellHeigthGap
		End if 
	End if 
	$tree_lPosWidth:=tree_lMargin+($tree_alDepth{$tree_lCellIndex}*(tree_lCellWidthGap+tree_lCellWidth))
	
	// save "line to up" height to array
	$tree_lDepthIndex:=$tree_alDepth{$tree_lCellIndex}
	Case of 
		: ($tree_lDepthIndex<($tree_alDepth{$tree_lCellIndex-1}))
			ARRAY LONGINT:C221($tree_alDepthFirstHeigth; $tree_lDepthIndex)  // delete upper level heights when going to lower level
		: (Size of array:C274($tree_alDepthFirstHeigth)<$tree_lDepthIndex)
			$tree_lDepthIndex:=$tree_alDepth{$tree_lCellIndex}
			INSERT IN ARRAY:C227($tree_alDepthFirstHeigth; $tree_lDepthIndex)
			$tree_alDepthFirstHeigth{$tree_lDepthIndex}:=$tree_lPosHeigth+(tree_lCellHeigth\2)
		Else 
			IDLE:C311
	End case 
	
	//draw cell outer rect
	$tree_rBorderWidth:=0.25
	tree_tRect:=SVG_New_rect(tree_tRef; $tree_lPosWidth; $tree_lPosHeigth; tree_lCellWidth; tree_lCellHeigth; 0; 0; "black"; "white"; $tree_rBorderWidth)
	SVG_SET_ID(tree_tRect; tree_asTreeStructure{$tree_lCellIndex}+":"+String:C10($tree_lPosWidth)+ksPeriod+String:C10($tree_lPosHeigth))
	
	If ($tree_alDepth{$tree_lCellIndex}#($tree_alDepth{$tree_lCellIndex-1}+1))
		$tree_lInSameDepth:=$tree_lInSameDepth+1
	Else 
		$tree_lInSameDepth:=0
	End if 
	
	If ($tree_alDepth{$tree_lCellIndex}>0)
		
		Case of 
			: (_str LastPart(tree_asTreeStructure{$tree_lCellIndex}; ".")="001")
				//draw line left to parent
				$tree_lBarTop:=$tree_lPosHeigth+(tree_lCellHeigth\2)
				tree_tRect:=SVG_New_line(tree_tRef; $tree_lPosWidth-tree_lCellWidthGap; $tree_lBarTop; $tree_lPosWidth; $tree_lBarTop; "mediumblue"; $tree_rBorderWidth)
			: ($tree_lCellIndex=$tree_lCellCount)  // to prevent next case index error
				//draw line to left
				$tree_lLeft:=$tree_lPosWidth-(tree_lCellWidthGap\2)
				$tree_lBarTop:=$tree_lPosHeigth+(tree_lCellHeigth\2)
				tree_tRect:=SVG_New_line(tree_tRef; $tree_lLeft; $tree_lBarTop; $tree_lPosWidth; $tree_lBarTop; "mediumblue"; $tree_rBorderWidth)
				//draw line to up
				$tree_lDepthIndex:=$tree_alDepth{$tree_lCellIndex}
				tree_tRect:=SVG_New_line(tree_tRef; $tree_lLeft; $tree_alDepthFirstHeigth{$tree_lDepthIndex}; $tree_lLeft; $tree_lBarTop; "mediumblue"; $tree_rBorderWidth)
				
			: ($tree_alDepth{$tree_lCellIndex}#$tree_alDepth{$tree_lCellIndex+1})
				//draw half line to left
				$tree_lLeft:=$tree_lPosWidth-(tree_lCellWidthGap\2)
				$tree_lBarTop:=$tree_lPosHeigth+(tree_lCellHeigth\2)
				tree_tRect:=SVG_New_line(tree_tRef; $tree_lLeft; $tree_lBarTop; $tree_lPosWidth; $tree_lBarTop; "mediumblue"; $tree_rBorderWidth)
				//draw line to up
				$tree_lDepthIndex:=$tree_lCellIndex
				$tree_lDrawLine:=kFalse
				Repeat 
					$tree_lDepthIndex:=$tree_lDepthIndex+1
					Case of 
						: ($tree_lDepthIndex>=$tree_lCellCount)
							$tree_lDrawLine:=kTrue
							$tree_lDepthIndex:=-1
						: ($tree_alDepth{$tree_lDepthIndex}<$tree_alDepth{$tree_lCellIndex})
							$tree_lDrawLine:=kTrue
						: ($tree_alDepth{$tree_lDepthIndex}=$tree_alDepth{$tree_lCellIndex})
							$tree_lDepthIndex:=-1
						Else 
							IDLE:C311
					End case 
				Until ($tree_lDepthIndex<0)
				If ($tree_lDrawLine=kTrue)
					$tree_lDepthIndex:=$tree_alDepth{$tree_lCellIndex}
					tree_tRect:=SVG_New_line(tree_tRef; $tree_lLeft; $tree_alDepthFirstHeigth{$tree_lDepthIndex}; $tree_lLeft; $tree_lBarTop; "mediumblue"; $tree_rBorderWidth)
					//tree_tRect:=SVG_New_line (tree_tRef;$tree_lLeft;$tree_lBarTop-($tree_lInSameDepth*(tree_lCellHeigth+tree_lCellHeigthGap));$tree_lLeft;$tree_lBarTop;"mediumblue";$tree_rBorderWidth) 
				End if 
			Else 
				//draw line to left
				$tree_lLeft:=$tree_lPosWidth-(tree_lCellWidthGap\2)
				$tree_lBarTop:=$tree_lPosHeigth+(tree_lCellHeigth\2)
				tree_tRect:=SVG_New_line(tree_tRef; $tree_lLeft; $tree_lBarTop; $tree_lPosWidth; $tree_lBarTop; "mediumblue"; $tree_rBorderWidth)
		End case 
		
	End if 
	
	If (False:C215)
		//see: tree_CELL_DRAW
		//tree_alGraph{$tree_lCellIndex}{4}:=0  ` orange  
		//tree_alGraph{$tree_lCellIndex}{5}:=0  ` green
		//tree_alGraph{$tree_lCellIndex}{6}:=0  ` red
		//tree_alGraph{$tree_lCellIndex}{7}:=100 `grey 100% bar
		$tree_tBarBorderColor:="white"
		$tree_tBarColor:="black"
		Case of 
			: (tree_alGraph{$tree_lCellIndex}{4}>0)  // orange
				$tree_tBarColor:="orange"
				$tree_lPixels:=Round:C94((100-tree_alGraph{$tree_lCellIndex}{4})*(tree_lCellHeigth-$tree_lCellFullLoadLine)/100; 0)
				$tree_lBarTop:=$tree_lPosHeigth+$tree_lCellFullLoadLine+$tree_lPixels
				$tree_lBarHeigth:=$tree_lPosHeigth+tree_lCellHeigth-$tree_lBarTop-1
			: (tree_alGraph{$tree_lCellIndex}{6}>0)  // red
				$tree_tBarColor:="tomato"
				$tree_lPixels:=Round:C94((tree_alGraph{$tree_lCellIndex}{6})*($tree_lCellFullLoadLine)/100; 0)
				$tree_lBarTop:=$tree_lPosHeigth+$tree_lCellFullLoadLine-$tree_lPixels
				If ($tree_lBarTop<($tree_lPosHeigth+3))
					$tree_lBarTop:=$tree_lPosHeigth+3  //limit red at the top
				End if 
				$tree_lBarHeigth:=$tree_lPosHeigth+$tree_lCellFullLoadLine-$tree_lBarTop
			Else 
				$tree_lBarHeigth:=0
		End case 
		If ($tree_lBarHeigth>0)
			If ($tree_lBarHeigth<3)
				$tree_lBarTop:=$tree_lBarTop-1
				$tree_lBarHeigth:=$tree_lBarHeigth+1
			End if 
			tree_tRect:=SVG_New_rect(tree_tRef; $tree_lPosWidth+$tree_lCellBarLeft1; $tree_lBarTop; $tree_lCellBarWidth; $tree_lBarHeigth; 0; 0; $tree_tBarBorderColor; $tree_tBarColor; $tree_rBorderWidth)
		End if 
		
		If (tree_alGraph{$tree_lCellIndex}{5}>0)  //green
			$tree_tBarColor:="lightgreen"
			$tree_lPixels:=Round:C94((100-tree_alGraph{$tree_lCellIndex}{5})*(tree_lCellHeigth-$tree_lCellFullLoadLine)/100; 0)
			$tree_lBarTop:=$tree_lPosHeigth+$tree_lCellFullLoadLine+$tree_lPixels
			$tree_lBarHeigth:=$tree_lPosHeigth+tree_lCellHeigth-$tree_lBarTop-1
			tree_tRect:=SVG_New_rect(tree_tRef; $tree_lPosWidth+$tree_lCellBarLeft1; $tree_lBarTop; $tree_lCellBarWidth; $tree_lBarHeigth; 0; 0; $tree_tBarBorderColor; $tree_tBarColor; $tree_rBorderWidth)
		End if 
		
		If (tree_alGraph{$tree_lCellIndex}{7}>0)  //grey
			$tree_tBarColor:="lightgrey"
			$tree_lPixels:=Round:C94((100-tree_alGraph{$tree_lCellIndex}{7})*(tree_lCellHeigth-$tree_lCellFullLoadLine)/100; 0)
			$tree_lBarTop:=$tree_lPosHeigth+$tree_lCellFullLoadLine+$tree_lPixels
			$tree_lBarHeigth:=$tree_lPosHeigth+tree_lCellHeigth-$tree_lBarTop-1
			tree_tRect:=SVG_New_rect(tree_tRef; $tree_lPosWidth+$tree_lCellBarLeft2; $tree_lBarTop; $tree_lCellBarWidth; $tree_lBarHeigth; 0; 0; $tree_tBarBorderColor; $tree_tBarColor; $tree_rBorderWidth)
		End if 
	End if 
	
	//draw cell text
	$tree_tTxt:=Replace string:C233(tree_asTreeStructure{$tree_lCellIndex}+ksCR+tree_atText{$tree_lCellIndex}; ksCR; "\r")  //remove tree_asTreeStructure{$tree_lCellIndex}+ksCR
	tree_tRect:=SVG_New_text(tree_tRef; $tree_tTxt; $tree_lPosWidth+$tree_rTxtFromBorder; $tree_lPosHeigth+$tree_rTxtFromBorder; $tree_tFont; $tree_rFontSize)
	
	If (False:C215)
		//draw 100% line
		//$tree_rBorderWidth:=0,5
		$tree_lBarTop:=$tree_lPosHeigth+$tree_lCellFullLoadLine
		tree_tRect:=SVG_New_line(tree_tRef; $tree_lPosWidth+$tree_lCellFullLoadLineGap; $tree_lBarTop; $tree_lPosWidth+tree_lCellWidth-($tree_lCellFullLoadLineGap*2); $tree_lBarTop; "mediumblue"; $tree_rBorderWidth)
	End if 
	
End for 

SVG EXPORT TO PICTURE:C1017(tree_tRef; tree_gArea)

SET CURSOR:C469(kCursorNormal)
GOTO OBJECT:C206(tree_lbRefresh)
