//%attributes = {}
// Method: vor_REPORT_DEFINITION_CHECK
// 2002.02.26-11:09:16 / Mika Vuorinen
// © Copyright 2002 Manage Applications
// Purpose: 
// 
//1. Checks within definition arrays that all definition Accounts exist
// in Definition value1
//2. Checks from vor selection that all accounts are found from
// definition Account.
// -----------------------------------------------------------
C_TEXT:C284($1; $vor_tPrfName; $vor_tLog)
_O_C_STRING:C293(k20; $2; $vor_sAccount; $3; $vor_sQryOperator)
C_POINTER:C301($vor_pFld)
C_LONGINT:C283($vor_lArrSize; $vor_lIndex)
_O_ARRAY STRING:C218(k20; $vor_asAccount_id; 0)

$vor_tPrfName:=$1

$vor_sAccount:=""
$vor_sQryOperator:=""

If (Count parameters:C259>1)
	$vor_sAccount:=$2
	$vor_sQryOperator:=$3
End if 

$vor_tLog:=""

If ($vor_tPrfName="")
	_err MESSAGE_PARAMETER("$1"; "vor_REPORT_DEFINITION_CHECK"; kFalse)
Else 
	COMPILER_vor
	ARRAY POINTER:C280(vor_apReportDefinitionArr; 7)
	vor_apReportDefinitionArr{1}:=->vor_alReportRowNum
	vor_apReportDefinitionArr{2}:=->vor_atReportAccount
	vor_apReportDefinitionArr{3}:=->vor_atReportText
	vor_apReportDefinitionArr{4}:=->vor_atReportDefinition_Value1
	vor_apReportDefinitionArr{5}:=->vor_atReportDefinition_Value2
	vor_apReportDefinitionArr{6}:=->vor_atReportDefinition_Value3
	vor_apReportDefinitionArr{7}:=->vor_atReportDefinition_Value4
	
	If (_prf_ Data(kLoad; ""; $vor_tPrfName; kFalse; ->vor_apReportDefinitionArr)=kFalse)
		_err MESSAGE(_lang Current("Can't load report definition")+":"+ksSpace+$vor_tPrfName; "vor_REPORT_DEFINITION_CHECK"; kFalse)
	Else 
		
		$vor_lArrSize:=Size of array:C274(vor_atReportAccount)
		_thm OPEN($vor_lArrSize; _lang Current("Checking arrays")+"..."; _lang Current("Report Definition Check"); False:C215)
		For ($vor_lIndex; 1; $vor_lArrSize)
			_thm UPDATE($vor_lIndex)
			If (vor_atReportAccount{$vor_lIndex}#"")
				If (Position:C15(vor_atReportAccount{$vor_lIndex}; vor_atReportDefinition_Value1{$vor_lIndex})<=0)
					$vor_tLog:=_lang Current("Error in line")+":"+ksSpace+String:C10(vor_alReportRowNum{$vor_lIndex})+ksPeriod
					$vor_tLog:=$vor_tLog+ksSpace+_lang Current("Preference name")+":"+ksSpace+$vor_tPrfName
					_err LOG($vor_tLog; "vor_REPORT_DEFINITION_CHECK")
				End if 
			End if 
		End for 
		
		_arr DISTINCT(->vor_atReportAccount)
		
		If (($vor_sAccount#"") & ($vor_sQryOperator#""))
			_str:=$vor_sAccount
			$vor_lArrSize:=_qry Fld(0; vor_kAccount_id; $vor_sQryOperator; ->_str; ""; kTrue)
		Else 
			$vor_lArrSize:=_sel RecsInSel(vor_kTbl)
		End if 
		
		_err LOG(String:C10($vor_lArrSize)+ksSpace+_lang Current("Selected record in table")+":"+ksSpace+_tbl Name(vor_kTbl); "vor_REPORT_DEFINITION_CHECK")
		
		$vor_pFld:=_fld NumToPtr(vor_kAccount_id)
		DISTINCT VALUES:C339($vor_pFld->; $vor_asAccount_id)
		SORT ARRAY:C229($vor_asAccount_id)
		_thm CLOSE
		
		$vor_lArrSize:=Size of array:C274($vor_asAccount_id)
		_thm OPEN($vor_lArrSize; _lang Current("Checking accounts")+"..."; _lang Current("Report Definition Check"); False:C215)
		For ($vor_lIndex; 1; $vor_lArrSize)
			_thm UPDATE($vor_lIndex)
			If (Find in array:C230(vor_atReportAccount; $vor_asAccount_id{$vor_lIndex})<0)
				$vor_tLog:=_lang Current("Can't find account from definition")+ksPeriod+ksSpace+_lang Current("Account")+":"+ksSpace+$vor_asAccount_id{$vor_lIndex}+ksPeriod
				$vor_tLog:=$vor_tLog+ksSpace+_lang Current("Preference name")+ksSpace+$vor_tPrfName
				_err LOG($vor_tLog; "vor_REPORT_DEFINITION_CHECK")
			End if 
		End for 
		_thm CLOSE
		
	End if 
End if 
