//%attributes = {}
// Method: wme_AMOUNT_AND_UNIT_REPAIR
// 2008.01.07-15:42:31 / Arto Kokkila
// © Copyright 2008 Manage Applications
// Purpose: 

//SOP
// Check if wme units are different than product design units and
//repair units and amounts if needed
// -----------------------------------------------
C_LONGINT:C283($1; <>wme_lRepairedFindOnly; $wme_lIndex; $wme_lArrSize; $wme_lProductIndex; $wme_lChange; $wme_lDoOnlyQry; $wme_lCanNotRepair; $wme_lRepaired)
C_TEXT:C284($wme_tThmMessage)

C_TEXT:C284($wme_tName)
$wme_tName:=_lang Current("Repair amounts and units")  //+": "+
If (_prs_ SelfStartedByName($wme_tName)=kFalse)
	If (Count parameters:C259>=1)
		<>wme_lRepairedFindOnly:=$1
	Else 
		<>wme_lRepairedFindOnly:=kFalse
	End if 
	If (_el Where=_el_kInOutput)
		_fo SEL_USE(Into set:K19:2; "<>wme_RepairSet")
	Else 
		_set CREATE(wme_kTbl; "<>wme_RepairSet")
	End if 
End if 

If (_prs SelfStart(Current method name:C684; $wme_tName; _prs_kMemStack; kTrue)=kTrue)
	_prs NEW_INIT
	
	_el TBL_SET(wme_kTbl)
	_set USE(wme_kTbl; "<>wme_RepairSet")
	_set CLEAR(wme_kTbl; "<>wme_RepairSet")
	
	If (_sel RecsInSel(wme_kTbl)<=0)
		_err CRY(_lang Current("No records selected"); kFalse)
	Else 
		If ((<>wme_lRepairedFindOnly=kTrue) | Macintosh option down:C545)
			$wme_lDoOnlyQry:=kTrue
			_info_ CONFIRM_SET_OK(_lang Current("Do you want to find estimated materials with wrong units?"))
		Else 
			$wme_lDoOnlyQry:=kFalse
			_info_ CONFIRM_SET_OK(_lang Current("Do you want to repair amounts and get units from product?"))
		End if 
		If (OK=1)
			
			_thm OPEN(-1; _lang Current("Loading arrays")+"..."; _lang Current("Field Repairing"); True:C214)
			
			COMPILER_w
			COMPILER_wme
			COMPILER_pr
			C_POINTER:C301($wme_pFromFldNum; $wme_pFromFldArr)
			$wme_pFromFldNum:=_fld PtrToFldNumArr(wme_kRecord_ID; wme_kWork__Position_Num_id; wme_kRaw_Material_id; wme_kUnit; wme_kUnit_2; wme_kQuantity__Unit; wme_kQuantity__Unit_2)  //      $wme_pFromFldNum:=_app_ FldNumArrPtr (wme_kTbl )
			$wme_pFromFldArr:=_fld PtrToFldArr(wme_kRecord_ID; wme_kWork__Position_Num_id; wme_kRaw_Material_id; wme_kUnit; wme_kUnit_2; wme_kQuantity__Unit; wme_kQuantity__Unit_2)  //      $wme_pFromFldArr:=_app_ FldApArrPtr (wme_kTbl )     
			_sel SEL_TO_ARR($wme_pFromFldNum; $wme_pFromFldArr)
			_arr apORD($wme_pFromFldArr; "2")
			
			_sel RELATE ONE SELECTION(wme_kRaw_Material_id; pr_kProduct_ID)
			C_POINTER:C301($wme_pProductFldNumArr; $wme_pProductFldArr)
			$wme_pProductFldNumArr:=_fld PtrToFldNumArr(pr_kProduct_ID; pr_kUnit; pr_kUnit_2; pr_kConversion_Multiplier; pr_kDesign_Unit; pr_kDesign_Unit_2; pr_kDesign_Conversion_Multip; pr_kUnit__Design_Unit_Multip)
			$wme_pProductFldArr:=_fld PtrToFldArr(pr_kProduct_ID; pr_kUnit; pr_kUnit_2; pr_kConversion_Multiplier; pr_kDesign_Unit; pr_kDesign_Unit_2; pr_kDesign_Conversion_Multip; pr_kUnit__Design_Unit_Multip)
			_sel SEL_TO_ARR($wme_pProductFldNumArr; $wme_pProductFldArr)
			
			_thm CLOSE
			
			$wme_lCanNotRepair:=0
			$wme_lRepaired:=0
			_set EMPTY_CREATE(wme_kTbl; "<>wme_Can_Not_Repair_Set")
			_set EMPTY_CREATE(wme_kTbl; "<>wme_Repaired_Set")
			$wme_lArrSize:=Size of array:C274(wme_asUnit)
			
			If ($wme_lDoOnlyQry=kTrue)
				$wme_tThmMessage:="Finding wrong amounts and units (not changing anything)"
			Else 
				_tbl WRITE_STATE(wme_kTbl; kTrue)
				_tbl WRITE_STATE(w_kTbl; kTrue)
				$wme_tThmMessage:="Repairing amounts and units"
			End if 
			
			_thm OPEN($wme_lArrSize; _lang Current($wme_tThmMessage)+"..."; _lang Current("Field Repairing"); True:C214)
			For ($wme_lIndex; 1; $wme_lArrSize)
				_thm UPDATE($wme_lIndex)
				If (_thm Cancelled=kTrue)
					$wme_lIndex:=$wme_lArrSize+1
				Else 
					$wme_lChange:=0
					$wme_lProductIndex:=Find in array:C230(pr_asProduct_ID; wme_asRaw_Material_id{$wme_lIndex})
					Case of 
						: ($wme_lProductIndex<=0)
							_err MESSAGE(_lang Current("Raw material was not found")+": "+wme_asRaw_Material_id{$wme_lIndex}+ksCR+_fld Name(wme_kWork__Position_Num_id)+": "+wme_asWork__Position_Num_id{$wme_lIndex}; Current method name:C684; kFalse)
							
						: ((wme_asUnit{$wme_lIndex}=pr_asDesign_Unit{$wme_lProductIndex}) & (wme_asUnit_2{$wme_lIndex}=pr_asDesign_Unit_2{$wme_lProductIndex}))  //All units are correct
							IDLE:C311
							
						: ((wme_asUnit{$wme_lIndex}=pr_asDesign_Unit{$wme_lProductIndex}) & (wme_asUnit_2{$wme_lIndex}#pr_asDesign_Unit_2{$wme_lProductIndex}))  //wme_asUnit is correct but wme_asUnit_2 is wrong
							$wme_lChange:=1  //recalculate Quantity__Unit_2
							
						: ((wme_asUnit_2{$wme_lIndex}=pr_asDesign_Unit{$wme_lProductIndex}) & (wme_asUnit{$wme_lIndex}=pr_asDesign_Unit_2{$wme_lProductIndex}))  //unit2 = product unit & unit=product unit2
							Case of 
								: ((wme_arQuantity__Unit{$wme_lIndex}<=wme_arQuantity__Unit_2{$wme_lIndex}) & (pr_arDesign_Conversion_Multip{$wme_lProductIndex}>=1))
									wme_arQuantity__Unit{$wme_lIndex}:=wme_arQuantity__Unit_2{$wme_lIndex}
								: ((wme_arQuantity__Unit{$wme_lIndex}>=wme_arQuantity__Unit_2{$wme_lIndex}) & (pr_arDesign_Conversion_Multip{$wme_lProductIndex}<=1))
									wme_arQuantity__Unit{$wme_lIndex}:=wme_arQuantity__Unit_2{$wme_lIndex}
								Else 
									//change only units - amounts are maby right?         
									_err MESSAGE(_lang Current("Raw material amounts may be wrong. Check amounts manually")+ksCR+_fld Name(wme_kWork__Position_Num_id)+": "+wme_asWork__Position_Num_id{$wme_lIndex}+ksCR+_fld Name(wme_kRaw_Material_id)+": "+wme_asRaw_Material_id{$wme_lIndex}+ksCR; Current method name:C684; kFalse)
							End case 
							$wme_lChange:=1  //recalculate Quantity__Unit_2
							
						: (wme_asUnit_2{$wme_lIndex}=pr_asDesign_Unit{$wme_lProductIndex})  //wme_asUnit is wrong, but get amount from Quantity__Unit_2
							wme_arQuantity__Unit{$wme_lIndex}:=wme_arQuantity__Unit_2{$wme_lIndex}
							$wme_lChange:=1  //recalculate Quantity__Unit_2
							
						: (wme_asUnit_2{$wme_lIndex}=pr_asDesign_Unit_2{$wme_lProductIndex})  //wme_asUnit is wrong,  but wme_asUnit_2 is correct-> recalculate Quantity__Unit
							$wme_lChange:=2  //recalculate Quantity__Unit
						Else 
							$wme_lChange:=10  //add only to set
							_err MESSAGE(_lang Current("Can't repair Work Material Estimeted. Repair record manually")+ksCR+_fld Name(wme_kWork__Position_Num_id)+": "+wme_asWork__Position_Num_id{$wme_lIndex}+ksCR+_fld Name(wme_kRaw_Material_id)+": "+wme_asRaw_Material_id{$wme_lIndex}+ksCR; Current method name:C684; kFalse)
					End case 
					
					Case of 
						: ($wme_lChange=0)
							IDLE:C311  //everything OK
						: (_qry Fld(0; wme_kRecord_ID; "="; ->wme_atRecord_ID{$wme_lIndex}; ""; kFalse)<=0)
							_err MESSAGE(_lang Current("Work Material Estimeted was not found")+ksPeriod+ksCR+_fld Name(wme_kRecord_ID)+": "+wme_atRecord_ID{$wme_lIndex}; Current method name:C684; kFalse)
						Else 
							If (($wme_lDoOnlyQry=kFalse) & ($wme_lChange<10))  //    $wme_lChange=10 = add only to set
								_rec LOCKED_WAIT(wme_kTbl; kTrue)
								If (OK=1)
									//save old values to info-field                
									If ([Work_Material_Estimated:45]Info:11#"")
										[Work_Material_Estimated:45]Info:11:=[Work_Material_Estimated:45]Info:11+ksCR+_str TagInsert(_date CurrentDateTimeToString; "DateTime")
									Else 
										[Work_Material_Estimated:45]Info:11:=_str TagInsert(_date CurrentDateTimeToString; "DateTime")
									End if 
									[Work_Material_Estimated:45]Info:11:=[Work_Material_Estimated:45]Info:11+ksCR+_str TagInsert(String:C10([Work_Material_Estimated:45]Quantity__Unit:3); "wme_kQuantity__Unit")
									[Work_Material_Estimated:45]Info:11:=[Work_Material_Estimated:45]Info:11+ksCR+_str TagInsert([Work_Material_Estimated:45]Unit:22; "wme_kUnit")
									[Work_Material_Estimated:45]Info:11:=[Work_Material_Estimated:45]Info:11+ksCR+_str TagInsert(String:C10([Work_Material_Estimated:45]Quantity__Unit_2:4); "wme_kQuantity__Unit_2")
									[Work_Material_Estimated:45]Info:11:=[Work_Material_Estimated:45]Info:11+ksCR+_str TagInsert([Work_Material_Estimated:45]Unit_2:23; "wme_kUnit_2")
									//
									[Work_Material_Estimated:45]Unit:22:=pr_asDesign_Unit{$wme_lProductIndex}
									[Work_Material_Estimated:45]Unit_2:23:=pr_asDesign_Unit_2{$wme_lProductIndex}
									Case of 
										: ($wme_lChange=1)
											[Work_Material_Estimated:45]Quantity__Unit:3:=wme_arQuantity__Unit{$wme_lIndex}
											wme_ Script(wme_kQuantity__Unit)
										: ($wme_lChange=2)
											wme_ Script(wme_kQuantity__Unit_2)
										Else 
											_err MESSAGE(_lang Current("Something wrong with repair code"); Current method name:C684; kFalse)
									End case 
									_rec SAVE(wme_kTbl)
									wme_arQuantity__Unit{$wme_lIndex}:=[Work_Material_Estimated:45]Quantity__Unit:3
									wme_asUnit{$wme_lIndex}:=[Work_Material_Estimated:45]Unit:22
									wme_arQuantity__Unit_2{$wme_lIndex}:=[Work_Material_Estimated:45]Quantity__Unit_2:4
									wme_asUnit_2{$wme_lIndex}:=[Work_Material_Estimated:45]Unit_2:23
								End if 
							End if 
							If ($wme_lChange=10)
								$wme_lCanNotRepair:=$wme_lCanNotRepair+1
								_set ADD_TO_SET(wme_kTbl; "<>wme_Can_Not_Repair_Set")
							Else 
								$wme_lRepaired:=$wme_lRepaired+1
								_set ADD_TO_SET(wme_kTbl; "<>wme_Repaired_Set")
							End if 
					End case 
				End if 
			End for 
			_thm CLOSE
			
			If ($wme_lDoOnlyQry=kTrue)
				_err MESSAGE(_lang Current("Number of records that can be repaired")+": "+String:C10($wme_lRepaired)+ksCR; Current method name:C684; kFalse)
			Else 
				_tbl WRITE_STATE(wme_kTbl; kPrevious)
				_tbl WRITE_STATE(w_kTbl; kPrevious)
				_err MESSAGE(_lang Current("Number of repaired records")+": "+String:C10($wme_lRepaired)+ksCR; Current method name:C684; kFalse)
			End if 
			_err MESSAGE(_lang Current("Number of records that can't be repaired")+": "+String:C10($wme_lCanNotRepair)+ksCR; Current method name:C684; kFalse)  //can not repair
			
			If (_set RecsInSet(wme_kTbl; "<>wme_Repaired_Set")<=0)
				_set CLEAR(wme_kTbl; "<>wme_Repaired_Set")
			Else 
				_el RUN(_el_kmOutput; wme_kTbl; Into set:K19:2; "<>wme_Repaired_Set"; kFalse; _el_kmOutput; 0)
			End if 
			If (_set RecsInSet(wme_kTbl; "<>wme_Can_Not_Repair_Set")<=0)
				_set CLEAR(wme_kTbl; "<>wme_Can_Not_Repair_Set")
			Else 
				_el RUN(_el_kmOutput; wme_kTbl; Into set:K19:2; "<>wme_Can_Not_Repair_Set"; kFalse; _el_kmOutput; 0)
			End if 
		End if 
	End if 
	
	_prs_ NEW_QUIT
End if 
