//%attributes = {}
// Method: wpa_UnmannedMachineTime 
// 11.05.12, 16:20:07 / MG_PM
// © Copyright Manage Applications
// Purpose: 
// see: wpa_AUTOMATIC_WPA_TIMES_SET, wpa_UnmannedEndTime, wpa_UnmannedMachineTime
// ------------------------------------------------------------
If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStart; Current method name:C684)
End if 

C_REAL:C285($0; $wpa_rMachineHours)
C_TEXT:C284($1; $wpa_tLoadGroup; $wpa_tLoadGroupMachine; $wpa_tInfo)
C_REAL:C285($2; $wpa_rStart; $3; $wpa_rEnd)
C_LONGINT:C283($wpa_lCapIndex; $wpa_lCapIndexLast; $wpa_lInRunRatio)

$wpa_tLoadGroup:=$1
$wpa_tLoadGroupMachine:=$wpa_tLoadGroup+"_machine"
$wpa_rStart:=$2
$wpa_rEnd:=$3
$wpa_rMachineHours:=0

$wpa_dStartDate:=_dt RealToDate($wpa_rStart)
$wpa_dEndDate:=_dt RealToDate($wpa_rEnd)
ldcap_ MACHINE_LOAD_DATE_SET($wpa_dStartDate; $wpa_dEndDate)

// --- calculate UnmannedNotRunTime hours ---
// wpa_AUTOMATIC_WPA_TIMES_SET, wpa_UnmannedEndTime, wpa_UnmannedMachineTime, wpa_ UNPRODUCTIVE_WPA_CREATE 
$wpa_lCapIndex:=ldcap_ IndexFirstLoadedDt($wpa_tLoadGroupMachine; $wpa_rStart)
$wpa_lCapIndexLast:=ldcap_IndexLast($wpa_tLoadGroupMachine)

While ($wpa_lCapIndex>0)  // calculate run times
	IDLE:C311
	Case of 
		: ($wpa_lCapIndex>Size of array:C274(ldcap_arCapacity))
			TRACE:C157
			_err MESSAGE(_lang Current("Capacity index is bigger than capacity array size")+": "+String:C10($wpa_lCapIndex)+" / "+String:C10(Size of array:C274(ldcap_arCapacity))+", "+$wpa_tLoadGroupMachine; Current method name:C684; kFalse)
			$wpa_lCapIndex:=$wpa_lCapIndexLast+1  // end loop
			
		: (ldcap_arCapacity{$wpa_lCapIndex}<=0)
			IDLE:C311  // no capcity
			
		Else   // = end and start are the same?
			
			// calculate ldcap_InfoToBrushColor.json prf "ldcap_alBrushInRunRatio" array > 0 times to machine hours field
			$wpa_tInfo:=_str Parse(ldcap_atInfo{$wpa_lCapIndex}; ";"; 2)  // LOAD, CYCLE ON, ERROR and so on...
			$wpa_lInRunRatio:=Num:C11(ldcap_ InfoToBrushColor(3; "ldcap_InfoToBrushColor"; $wpa_tInfo))
			// calculate machine hours
			If ($wpa_lInRunRatio>0)
				Case of 
					: (($wpa_rStart>ldcap_arStart{$wpa_lCapIndex}) & ($wpa_rEnd<ldcap_arEnd{$wpa_lCapIndex}))
						//TRACE  // should never come here if wpa_ was created from this same capacity, may come with timer end time set
						$wpa_rMachineHours:=$wpa_rMachineHours+_dt Difference($wpa_rEnd; $wpa_rStart)  // all inside one machine capacity
						// should come here only once
					: ($wpa_rStart>ldcap_arStart{$wpa_lCapIndex})
						//TRACE  // should never come here if wpa_ was created from this same capacity
						$wpa_rMachineHours:=$wpa_rMachineHours+_dt Difference(ldcap_arEnd{$wpa_lCapIndex}; $wpa_rStart)  // must be end-start
					: ($wpa_rEnd<ldcap_arEnd{$wpa_lCapIndex})
						TRACE:C157  // should never come here if wpa_ was created from this same capacity
						$wpa_rMachineHours:=$wpa_rMachineHours+_dt Difference($wpa_rEnd; ldcap_arStart{$wpa_lCapIndex})  // must be end-start
					Else 
						//$wpa_rMachineHours:=$wpa_rMachineHours+_dt Difference (ldcap_arEnd{$wpa_lCapIndex};ldcap_arStart{$wpa_lCapIndex})  // =ldcap_arCapacity{$wpa_lCapIndex}  
						If (_dt Difference(ldcap_arEnd{$wpa_lCapIndex}; ldcap_arStart{$wpa_lCapIndex})#ldcap_arCapacity{$wpa_lCapIndex})
							TRACE:C157
						End if 
						$wpa_rMachineHours:=$wpa_rMachineHours+ldcap_arCapacity{$wpa_lCapIndex}  // must be end-start
				End case 
			End if 
			
	End case 
	
	// check for loop end
	Case of 
		: ($wpa_lCapIndex>=$wpa_lCapIndexLast)
			$wpa_lCapIndex:=-1  // end loop
		: (ldcap_arStart{$wpa_lCapIndex+1}>=$wpa_rEnd)
			$wpa_lCapIndex:=-1  // end loop
		Else 
			$wpa_lCapIndex:=$wpa_lCapIndex+1  // continue loop
	End case 
End while 

$0:=$wpa_rMachineHours

If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStop; Current method name:C684)
End if 