//%attributes = {}
//******************************************************************************
//Method: SDA_MacroExpand
//Written by  Cyril Harnisch on 2/17/99
//
//Purpose: Look for macros in the selected method, and replace them. This
// runs recursively so macros can contain macros.
//
//Taken from: K's Room on 98/06/21 (Japan)
//Modified Tod Gentille allow one parameter in the macro 
//using the ^ to designate it.  A sample call would be:
// /*RecLoop^[SomeTable]*/
//Copyright 1999 Syncor Systems, Inc.
//******************************************************************************
C_BOOLEAN:C305($bDoExpand; $bGo)
C_LONGINT:C283($MACRO_START_LEN; $MACRO_END_LEN; $l_StartPos; $l_StopPos)
C_TEXT:C284($t_SDA_Scrap; $t_SDA_FullScrap; $t_SDA_Return; $t_SDA_Macro; $tExpandText)
C_TEXT:C284($tMACRO_START; $tMACRO_END; $tMACRO_PARAMETER)

$tMACRO_START:="/*"
$tMACRO_END:="*/"
$tMACRO_PARAMETER:="^"
$MACRO_START_LEN:=Length:C16($tMACRO_START)
$MACRO_END_LEN:=Length:C16($tMACRO_END)

READ ONLY:C145([_Preference:1])
SDA_util_PostSelectAll
//<>tSDA_Scrap will already have the contents of the method
$t_SDA_FullScrap:=<>tSDA_Scrap
$t_SDA_Return:=""
$t_SDA_Scrap:=$t_SDA_FullScrap

Repeat   //until all embedded macros are converted
	$l_StartPos:=Position:C15($tMACRO_START; $t_SDA_Scrap)
	
	If ($l_StartPos#0)
		$t_SDA_Return:=$t_SDA_Return+Substring:C12($t_SDA_Scrap; 1; $l_StartPos-1)
		$t_SDA_Scrap:=Substring:C12($t_SDA_Scrap; $l_StartPos+$MACRO_START_LEN)
		$l_StopPos:=Position:C15($tMACRO_END; $t_SDA_Scrap)
		$t_SDA_Macro:=Substring:C12($t_SDA_Scrap; 1; $l_StopPos-1)
		$t_SDA_Scrap:=Substring:C12($t_SDA_Scrap; $l_StopPos+$MACRO_END_LEN)
		
		//first check for all of our special one letter macros- the real power of these
		//one letter macros is to allow you to put them inside other macros
		$bDoExpand:=True:C214
		
		Case of 
				
			: ($t_SDA_Macro="t")  // time
				$tExpandText:=String:C10(Current time:C178)
				
			: ($t_SDA_Macro="d")  // date
				$tExpandText:=String:C10(Current date:C33)
				
			: ($t_SDA_Macro="m")  // method name
				$tExpandText:=SDA_util_FrontmostMethodName
				
			: ($t_SDA_Macro="h")  // header
				$tExpandText:=SDA_MethodHeader
				
			: ($t_SDA_Macro="b")  // modified by
				$tExpandText:="`Modified by "+Current system user:C484+" on "+String:C10(Current date:C33)
				
			: ($t_SDA_Macro="-")  //comment line of dashes
				$tExpandText:="`-------------------------------------------------------------------------------"
				
			: ($t_SDA_Macro="o")  //machine owner
				$tExpandText:=Current system user:C484
				
			: ($t_SDA_Macro="i")  //if else end if 
				$tExpandText:=<>SDA_IF_CMD
				
			: ($t_SDA_Macro="c")  //case end case
				$tExpandText:=<>SDA_CASE_CMD
				
			: ($t_SDA_Macro="r")  //repeat until
				$tExpandText:=<>SDA_REPEAT_CMD
				
			: ($t_SDA_Macro="w")  //while
				$tExpandText:=<>SDA_WHILE_CMD
				
			: ($t_SDA_Macro="f")  //for end for 
				$tExpandText:=<>SDA_FOR_CMD
				
			Else   //handle the standard macros stored in the table
				
				_O_C_INTEGER:C282($iParamPos)
				C_TEXT:C284($tParameter)
				$iParamPos:=Position:C15($tMACRO_PARAMETER; $t_SDA_Macro)
				If ($iParamPos#0)
					$tParameter:=Substring:C12($t_SDA_Macro; $iParamPos+1)
					$t_SDA_Macro:=Substring:C12($t_SDA_Macro; 1; $iParamPos-1)
				End if 
				
				$tExpandText:=_prf_ Txt(""; $t_SDA_Macro)  //c: PM
				
				If ($tExpandText#"")
					If ($iParamPos#0)  //there are parameters to replace
						$tExpandText:=Replace string:C233($tExpandText; $tMACRO_PARAMETER; $tParameter)
					End if 
					
				Else 
					$bDoExpand:=False:C215
				End if 
				
		End case 
		
		If ($bDoExpand)
			$t_SDA_Return:=$t_SDA_Return+$tExpandText
			$t_SDA_Scrap:=$t_SDA_Return+$t_SDA_Scrap  //add the just expanded text in case there is another macro in it
			$t_SDA_Return:=""
			
		Else 
			$t_SDA_Return:=$t_SDA_Return+$tMACRO_START+$t_SDA_Macro+$tMACRO_END
		End if 
		
	End if 
	
Until ($l_StartPos=0)

$t_SDA_Return:=$t_SDA_Return+$t_SDA_Scrap
<>tSDA_Scrap:=$t_SDA_Return
$bGo:=SDA_ClipboardOps(<>SDA_PASTE; -><>tSDA_Scrap)
