//%attributes = {}
//******************************************************************************
//
//Method: SDA_TABLE_CHARFieldPopup(pToListRef)
//
//Written by  Tod Gentille on 10/14/97
//
//Purpose: Display a hierarchical list of all files and fields for the structure.
//paste the one the user selects into the current location in the design env
//called from the form object by passing Self
//$1 - pointer to List of Table Field names
//Copyright 1997 Syncor Systems, Inc.
//
//******************************************************************************
C_POINTER:C301($1; $pTableFieldPopup)
C_LONGINT:C283($iSelItem; $iGetItemRef)
C_LONGINT:C283($lItemParentRef; $lFieldNum)

$pTableFieldPopup:=$1

Case of 
	: (Form event code:C388=On Load:K2:1)
		SDA_TableFieldListInit($pTableFieldPopup)
		
	: (Form event code:C388=On Unload:K2:2)
		CLEAR LIST:C377($pTableFieldPopup->; *)  //clear lists and sublists
		
	: (Form event code:C388=On Clicked:K2:4)
		$iSelItem:=Selected list items:C379($pTableFieldPopup->)
		
		If ($iSelItem#0)
			//get what the user picked and put it into <>tScrap      
			GET LIST ITEM:C378($pTableFieldPopup->; $iSelItem; $iGetItemRef; <>tSDA_Scrap)
			
			//Modified by Tod Gentille on 3/3/98 Need to reconstruct the name to get
			//around the 31 character limit of hierarchical popups.
			//When the list was constructed SDA_TableFieldListInit the table and field
			//information was encoded into the list references.  So now just get it back      
			$lItemParentRef:=List item parent:C633($pTableFieldPopup->; $iGetItemRef)  //the parent ref is that table number
			$lFieldNum:=$iGetItemRef%<>iTABLE_OFFSET  //the field number is modulo the offset
			
			If ($lFieldNum=<>iTABLE_DESIGNATOR)
				<>tSDA_Scrap:=<>SDA_START_TABLE_CHAR+Table name:C256($lItemParentRef)+<>SDA_END_TABLE_CHAR
				
			Else 
				<>tSDA_Scrap:=<>SDA_START_TABLE_CHAR+Table name:C256($lItemParentRef)+<>SDA_END_TABLE_CHAR+Field name:C257($lItemParentRef; $lFieldNum)
			End if   //        If ($lFieldNum=<>iTABLE_DESIGNATOR)
			
			SDA_ClipboardOps(<>SDA_PASTE; -><>tSDA_Scrap)
			//The docs say the next line will select item 1 because 0 is out of range
			//but in fact it does deselect any item. That way if the next time the user
			//drags off the hier. popup without selecting anything nothing gets pasted
			//if we don't do this we always get the last item selected again        
			SELECT LIST ITEMS BY POSITION:C381($pTableFieldPopup->; 0)
			
		Else 
			BEEP:C151
		End if   //      If ($iSelItem # 0)
		
	Else   //ignore other events      
		
End case   //Case of
