//%attributes = {}
//******************************************************************************
//Method: SDA_util_GetMethDocs
//Written by  Cyril Harnisch on 2/2/99
//
//Purpose: Get a list of documents and strip of the .TXT endings
// which exist on the Windows platform.
//
//$1 - text -pathname
//$2 - pointer to document array
//
//Copyright 1999 Syncor Systems, Inc.
//
//Modified by: Cyril Harnisch, Syncor Systems, Inc., 2/9/99
//Reason: 
//******************************************************************************
C_TEXT:C284($1; $tPathName)
C_POINTER:C301($2; $pDocumentAry)
C_LONGINT:C283($lNbrDocuments; $lDocAryIdx)
_O_C_STRING:C293(4; $s4DocumentType)

$tPathName:=$1
$pDocumentAry:=$2

$s4DocumentType:="SDAM"  //Map File Types in SDA_Startup sets this for Mac & Win

//#### Get the documents
DOCUMENT LIST:C474($tPathName; $pDocumentAry->)

//#### Remove the non-methods
$lNbrDocuments:=Size of array:C274($pDocumentAry->)
ARRAY BOOLEAN:C223($abMethod; $lNbrDocuments)

For ($lDocAryIdx; 1; $lNbrDocuments)  //for each document
	
	If (_o_Document type:C528($tPathName+$pDocumentAry->{$lDocAryIdx})=$s4DocumentType)  //if the document is an SDA Method document
		
		If (Substring:C12($pDocumentAry->{$lDocAryIdx}; Length:C16($pDocumentAry->{$lDocAryIdx})-3; 4)=".SDA")  //if the document name ends in ".SDA"    
			$pDocumentAry->{$lDocAryIdx}:=Substring:C12($pDocumentAry->{$lDocAryIdx}; 1; Length:C16($pDocumentAry->{$lDocAryIdx})-4)  //strip off DOS ending
			$abMethod{$lDocAryIdx}:=True:C214  //indicate this is a document
			
		Else   //document name does not end in ".SDA", perhaps it's on a Mac
			$abMethod{$lDocAryIdx}:=True:C214  //indicate this is a document
		End if 
		
	Else   //document not a method
		$abMethod{$lDocAryIdx}:=False:C215  //indicate this is not a document
	End if 
	
End for 

SORT ARRAY:C229($abMethod; $pDocumentAry->; <)  //sort the arrays descending so the methods come first
C_BOOLEAN:C305($bFoundMethod; $bOutOfRange)
C_LONGINT:C283($lCurrMethodIdx)

$lCurrMethodIdx:=1
$bFoundMethod:=$abMethod{$lCurrMethodIdx}  //determine whether this is a method
$bOutOfRange:=False:C215
While ($bFoundMethod)  //while we are still finding methods
	$lCurrMethodIdx:=$lCurrMethodIdx+1
	
	If ($lCurrMethodIdx<=$lNbrDocuments)  //if we are still within range
		$bFoundMethod:=$abMethod{$lCurrMethodIdx}  //determine whether this is a method
		
	Else   //out of range
		$bFoundMethod:=False:C215  //terminate the loop   
		$bOutOfRange:=True:C214
	End if 
	
End while 

If (Not:C34($bOutOfRange))  //make sure some were found
	//#### delete the non-Methods
	DELETE FROM ARRAY:C228($pDocumentAry->; $lCurrMethodIdx; $lNbrDocuments-$lCurrMethodIdx+1)
End if 
