//%attributes = {}
//******************************************************************************
//Method: SDA_util_OpenMethodByPostDown
//Written by  Tod Gentille on 9/30/1998
//
//Purpose: This routine is generally used when Poststring does not open the right 
// method, usually this is caused because the poststring can
//post so many type ahead characters, methods with more than about 12 characters
//the same at the start do not get found. Try using the down arrow    
//
//$1 - text-name of method to open
//
//Copyright 1998 Syncor Systems, Inc.
//******************************************************************************

C_BOOLEAN:C305($bNotFound; $bStatus)
C_LONGINT:C283($iPostDownCount)
C_TEXT:C284($1; $tMethodNameToOpen)
$tMethodNameToOpen:=$1

$bNotFound:=True:C214
$iPostDownCount:=1
While (($iPostDownCount<=<>SDA_NUM_POST_DOWNS) & $bNotFound)
	
	$bStatus:=SDA_util_OpenNextExplorerMethod
	$iPostDownCount:=$iPostDownCount+1
	$bNotFound:=(SDA_util_GetWinTitleStripped#$tMethodNameToOpen)
	If ($bNotFound)
		$bStatus:=SDA_util_CloseWindowWait
		// `just ignore the status if for some reason the window doesn't close
		//there isn't much we can do about it and it doesn't cause a problem
	End if 
	
End while 

$0:=Not:C34($bNotFound)  //return true if the method was opened
//
