//%attributes = {}
// Method: ap_BANK_BARCODE_READ
// 2010.02.12-17:30:03 / Arto Kokkila
// © Copyright 2010 Manage Applications
// Purpose: 
// 
// ------------------------------------------------------------
C_TEXT:C284($ap_tBarcode; $ap_tType; $ap_tAccount; $ap_tCreditInt; $ap_tCreditDec; $ap_tReference; $ap_tStandby; $ap_tDueDate; $ap_tCheck1; $ap_tAccountOld)
C_DATE:C307($ap_dDueDate)
C_REAL:C285($ap_rSum)
$ap_tBarcode:=_info_ Request(_lang Current("Read barcode")+":"; "")
If ((OK=1) & ($ap_tBarcode#""))
	$ap_tType:=Substring:C12($ap_tBarcode; 1; 1)
	Case of 
		: ($ap_tType="2")
			$ap_tAccount:=Substring:C12($ap_tBarcode; 2; 14)
			$ap_tCreditInt:=Substring:C12($ap_tBarcode; 16; 6)
			$ap_tCreditDec:=Substring:C12($ap_tBarcode; 22; 2)
			$ap_tReference:=Substring:C12($ap_tBarcode; 24; 20)
			$ap_tDueDate:=Substring:C12($ap_tBarcode; 44; 6)  //yymmdd
			$ap_tStandby:="0000"
			$ap_tCheck1:=" "
		: ($ap_tType="3")  //not in use
			$ap_tType:=""
		: ($ap_tType="4")  //not until 1.12.2010 
			$ap_tAccount:=Substring:C12($ap_tBarcode; 2; 16)
			$ap_tCreditInt:=Substring:C12($ap_tBarcode; 16; 6)
			$ap_tCreditDec:=Substring:C12($ap_tBarcode; 22; 2)
			$ap_tStandby:="000"
			$ap_tReference:=Substring:C12($ap_tBarcode; 27; 20)
			$ap_tDueDate:=Substring:C12($ap_tBarcode; 47; 6)  //yymmdd
			$ap_tCheck1:=""
		Else 
			$ap_tType:=""
			IDLE:C311
	End case 
	If ($ap_tType#"")
		$ap_dDueDate:=_str ToDateFormat($ap_tDueDate; "YYMMDD")
		_fld VALUE_DATE_SET(kSet; ap_kDue_Date; $ap_dDueDate)
		xapp TblRun(ap_kDue_Date; ap_kTbl; kNoEvent)
		
		$ap_rSum:=Num:C11($ap_tCreditInt)+(Num:C11($ap_tCreditDec)/100)
		_fld VALUE_REAL_SET(kSet; ap_kSum_Of_Payable; $ap_rSum)
		xapp TblRun(ap_kSum_Of_Payable; ap_kTbl; kNoEvent)
		
		$ap_tReference:=_str FirstCharRemove($ap_tReference; "0"; kTrue)
		_fld VALUE_STR_SET(kSet; ap_kReference_Number; $ap_tReference)
		xapp TblRun(ap_kReference_Number; ap_kTbl; kNoEvent)
		
		$ap_tAccount:=bank_ AccountInMachineFormat($ap_tAccount; ""; kGet)
		$ap_tAccountOld:=_fld ValueStr(ap_kReceiver_Bank_Account)
		Case of 
			: ($ap_tAccount=$ap_tAccountOld)
				$ap_tAccount:=""
			: ($ap_tAccountOld#"")
				$ap_tAccount:=_info_ Request(_lang Current("Do you want to change bank account")+":"; $ap_tAccount)
				If (OK=0)
					$ap_tAccount:=""
				End if 
		End case 
		If ($ap_tAccount#"")
			_fld VALUE_STR_SET(kSet; ap_kReceiver_Bank_Account; $ap_tAccount)
			xapp TblRun(ap_kReceiver_Bank_Account; ap_kTbl; kNoEvent)
		End if 
		REDRAW WINDOW:C456
	End if 
End if 

