//%attributes = {}
// Method: wo_rep_AC_EST_ACT
// 2010.04.21-13:20:45 / Arto Kokkila
// © Copyright 2010 Manage Applications
// Purpose: 
// 
// ------------------------------------------------------------

// Purpose: 
// Creates the arrays used in wo aftercalc report.
// Estimated and actual amounts are calculated.
// Raw materials are handled in groups.
// ------------------------------------------------------------
C_LONGINT:C283($1; $wo_rep_lUseProducedAmount; $2; $wo_rep_lUseMaterialNetAmount; $wo_rep_lSales_Order_Row)
C_TEXT:C284($3; $wo_rep_tEstToActLoadGroups)
C_LONGINT:C283($wo_rep_lIndex; $wo_rep_lSelIndex; $wo_rep_lSelSize; $wo_rep_lProductsFound)
C_LONGINT:C283($wo_rep_lWmePos; $wo_rep_lWmaPos; $wo_rep_lWpePos; $wo_rep_lWpaPos; $wo_rep_lPorPos; $wo_rep_lWoPos)
C_REAL:C285($wo_rStarted_Amount)
C_TEXT:C284($wo_rep_tRaw_Material_Group; $wo_rep_tWork_Phase_Group; $wo_rep_tSubcontract_Group; $wo_rep_tProduct_Group)
C_TEXT:C284($wo_rep_tSales_Order; $wo_rep_tUnit; $wo_rep_tUnit2; $wo_rep_tHour; $wo_rep_tProduction_Lot; $wo_rep_tWork)
C_POINTER:C301($wo_rep_pFldArr; $wo_rep_pPtrArr)

If (Count parameters:C259>=1)
	$wo_rep_lUseProducedAmount:=$1
Else 
	$wo_rep_lUseProducedAmount:=kTrue  //kFalse =  use started amount
End if 
If (Count parameters:C259>=2)
	$wo_rep_lUseMaterialNetAmount:=$2
Else 
	$wo_rep_lUseMaterialNetAmount:=kFalse
End if 
If (Count parameters:C259>=3)
	$wo_rep_tEstToActLoadGroups:=$3
Else 
	$wo_rep_tEstToActLoadGroups:=""
End if 
COMPILER_wo_rep_AC_EST_ACT(0)

COMPILER_pr
COMPILER_wo
COMPILER_wme
COMPILER_wma
COMPILER_wpe
COMPILER_wpa
COMPILER_po  //AK: 2007-07-24

// work orders to array
$wo_rep_pFldArr:=_fld PtrToFldNumArr(wo_kProduction_Lot; wo_kWork__Position_Num_id; wo_kStarted_Amount; wo_kProduced_Amount; wo_kFailed_Amount; wo_kSales_Order_id; wo_kSales_Order_Row_id)
$wo_rep_pPtrArr:=_arr PtrToTmpArr(->wo_asProduction_Lot; ->wo_asWork__Position_Num_id; ->wo_arStarted_Amount; ->wo_arProduced_Amount; ->wo_arFailed_Amount; ->wo_asSales_Order_id; ->wo_alSales_Order_Row_id)
_sel SEL_TO_ARR($wo_rep_pFldArr; $wo_rep_pPtrArr)
//AK: 2007-07-24:  wo_kFailed_Amount added 

// estimated materials to array
_qry ARRAY(wme_kWork__Position_Num_id; ->wo_asWork__Position_Num_id)
$wo_rep_pFldArr:=_fld PtrToFldNumArr(wme_kWork__Position_Num_id; wme_kRaw_Material_id; wme_kQuantity__Unit; wme_kQuantity__Unit_2; wme_kCost_Price_Total; wme_kSales_Price_Total)
$wo_rep_pPtrArr:=_arr PtrToTmpArr(->wme_asWork__Position_Num_id; ->wme_asRaw_Material_id; ->wme_arQuantity__Unit; ->wme_arQuantity__Unit_2; ->wme_arCost_Price_Total; ->wme_arSales_Price_Total)
_sel SEL_TO_ARR($wo_rep_pFldArr; $wo_rep_pPtrArr)

// actual materials to array
_qry ARRAY(wma_kProduction_Lot; ->wo_asProduction_Lot)
$wo_rep_pFldArr:=_fld PtrToFldNumArr(wma_kProduction_Lot; wma_kRaw_Material_id; wma_kAmount__design_unit; wma_kAmount__design_unit_2; wma_kCost_Price_Total; wma_kSales_Price_Total; wma_kNet_Amount__Design_Unit; wma_kNet_Amount__Design_Unit_2)
$wo_rep_pPtrArr:=_arr PtrToTmpArr(->wma_asProduction_Lot; ->wma_asRaw_Material_id; ->wma_arAmount__design_unit; ->wma_arAmount__design_unit_2; ->wma_arCost_Price_Total; ->wma_arSales_Price_Total; ->wma_arNet_Amount__Design_Unit; ->wma_arNet_Amount__Design_Unit_2)
_sel SEL_TO_ARR($wo_rep_pFldArr; $wo_rep_pPtrArr)

// estimated work phases to array
_qry ARRAY(wpe_kWork__Position_Num_id; ->wo_asWork__Position_Num_id)
$wo_rep_pFldArr:=_fld PtrToFldNumArr(wpe_kWork__Position_Num_id; wpe_kPhase_Number; wpe_kWork_Load_Group_id; wpe_kWork_Description; wpe_kWork_Time__unit; wpe_kSetup_Time__lot; wpe_kWork_Cost__unit; wpe_kWork_Sales_Price__unit; wpe_kSubcontract; wlg_kName)
$wo_rep_pPtrArr:=_arr PtrToTmpArr(->wpe_asWork__Position_Num_id; ->wpe_alPhase_Number; ->wpe_asWork_Load_Group_id; ->wpe_atWork_Description; ->wpe_arWork_Time__unit; ->wpe_arSetup_Time__lot; ->wpe_arWork_Cost__unit; ->wpe_arWork_Sales_Price__unit; ->wpe_afSubcontract; ->wlg_asName)
_sel SEL_TO_ARR($wo_rep_pFldArr; $wo_rep_pPtrArr)

// actual work phases to array
_qry ARRAY(wpa_kProduction_Lot; ->wo_asProduction_Lot)
$wo_rep_pFldArr:=_fld PtrToFldNumArr(wpa_kProduction_Lot; wpa_kWork_Phase_Est_id; wpa_kWork_Load_Group_id; wpa_kWork_Description; wpa_kWork_Time__amount; wpa_kSetup_Time__amount; wpa_kWork_Cost_Price__amount; wpa_kWork_Sales_Price__amount; wpa_kSubcontract)
$wo_rep_pPtrArr:=_arr PtrToTmpArr(->wpa_asProduction_Lot; ->wpa_alWork_Phase_Est_id; ->wpa_asWork_Load_Group_id; ->wpa_atWork_Description; ->wpa_arWork_Time__amount; ->wpa_arSetup_Time__amount; ->wpa_arWork_Cost_Price__amount; ->wpa_arWork_Sales_Price__amount; ->wpa_afSubcontract)
_sel SEL_TO_ARR($wo_rep_pFldArr; $wo_rep_pPtrArr)

// subcontracts to array
_qry ARRAY(por_kProduction_Lot; ->wo_asProduction_Lot)
_qry Fld(0; por_kType_; "="; -><>po_tType_SubContract; ""; kTrue)  //AK: 2007-07-24
$wo_rep_pFldArr:=_fld PtrToFldNumArr(por_kProduction_Lot; por_kType_; po_kSupplier_id; por_kExplanation; por_kOrder_Amount; por_kOrder_Unit; por_kPurchase_Price_Total; por_kDelivered_Amount)
$wo_rep_pPtrArr:=_arr PtrToTmpArr(->por_asProduction_Lot; ->por_asType_; ->po_asSupplier_id; ->por_atExplanation; ->por_arOrder_Amount; ->por_asOrder_Unit; ->por_arPurchase_Price_Total; ->por_arDelivered_Amount)
_sel SEL_TO_ARR($wo_rep_pFldArr; $wo_rep_pPtrArr)

$wo_rep_tRaw_Material_Group:=_lang Current("Raw Materials")
$wo_rep_tWork_Phase_Group:=_lang Current("Work Phases")
$wo_rep_tSubcontract_Group:=_lang Current("Subcontracts")
$wo_rep_tHour:=_lang Current("h")

// go through all work orders in selection
$wo_rep_lSelSize:=Size of array:C274(wo_asProduction_Lot)
For ($wo_rep_lSelIndex; 1; $wo_rep_lSelSize)
	$wo_rep_tProduction_Lot:=wo_asProduction_Lot{$wo_rep_lSelIndex}
	$wo_rep_tWork:=wo_asWork__Position_Num_id{$wo_rep_lSelIndex}
	If ($wo_rep_lUseProducedAmount=kTrue)
		$wo_rStarted_Amount:=wo_arProduced_Amount{$wo_rep_lSelIndex}
	Else 
		$wo_rStarted_Amount:=wo_arStarted_Amount{$wo_rep_lSelIndex}
	End if 
	$wo_rep_tSales_Order:=wo_asSales_Order_id{$wo_rep_lSelIndex}
	$wo_rep_lSales_Order_Row:=wo_alSales_Order_Row_id{$wo_rep_lSelIndex}
	
	// estimated raw materials  
	$wo_rep_lWmePos:=Find in array:C230(wme_asWork__Position_Num_id; $wo_rep_tWork)
	While ($wo_rep_lWmePos>0)
		// find product group name for raw material
		// bind all materials belonging to this group together      
		$wo_rep_tProduct_Group:=""
		$wo_rep_tProductInfo:=""
		$wo_rep_tUnit:=""
		$wo_rep_tUnit2:=""
		$wo_rep_lProductsFound:=_qry Fld(0; pr_kProduct_ID; "="; ->wme_asRaw_Material_id{$wo_rep_lWmePos}; ""; kFalse)
		If ($wo_rep_lProductsFound<=0)
			_err MESSAGE(_lang Current("Product not found")+": "+wme_asRaw_Material_id{$wo_rep_lWmePos}; Current method name:C684; kTrue)
		Else 
			$wo_rep_tProduct_Group:=_fld ValueStr(pr_kProduct_ID)
			$wo_rep_tProductInfo:=_fld ValueStr(pr_kName)
			$wo_rep_tUnit:=_fld ValueStr(pr_kDesign_Unit)
			$wo_rep_tUnit2:=_fld ValueStr(pr_kDesign_Unit_2)
		End if 
		If ($wo_rep_tProduct_Group="")
			$wo_rep_tProduct_Group:="??"
		End if 
		
		$wo_rep_lWmaPos:=Find in array:C230(wma_asProduction_Lot; $wo_rep_tProduction_Lot)
		$wo_rep_lWpaPos:=Find in array:C230(wpa_asProduction_Lot; $wo_rep_tProduction_Lot)
		$wo_rep_lPorPos:=Find in array:C230(por_asProduction_Lot; $wo_rep_tProduction_Lot)
		
		// find if there already exists data for this product group; if not, add new row
		_txt:=$wo_rep_tProduction_Lot
		_txt2:=$wo_rep_tProduct_Group
		$wo_rep_lIndex:=_arr InTwoFind(->wo_rep_atProduction_Lot; ->_txt; ->wo_rep_atHeader_id; ->_txt2; 1)
		//$wo_rep_lIndex:=Find in array(wo_rep_atHeader_id;$wo_rep_tProduct_Group)
		If ($wo_rep_lIndex<1)
			$wo_rep_lIndex:=Size of array:C274(wo_rep_atProduction_Lot)+1
			_arr apINSERT(->wo_rep_apArr; $wo_rep_lIndex; 1)
			
			wo_rep_atProduction_Lot{$wo_rep_lIndex}:=$wo_rep_tProduction_Lot
			wo_rep_atWork__Position_Num_id{$wo_rep_lIndex}:=$wo_rep_tWork
			wo_rep_atProduct_Group{$wo_rep_lIndex}:=$wo_rep_tRaw_Material_Group
			wo_rep_atHeader_id{$wo_rep_lIndex}:=$wo_rep_tProduct_Group
			wo_rep_atHeader_Info{$wo_rep_lIndex}:=$wo_rep_tProductInfo
			
			wo_rep_atUnit{$wo_rep_lIndex}:=$wo_rep_tUnit
			wo_rep_atUnit2{$wo_rep_lIndex}:=$wo_rep_tUnit2
			
			wo_rep_atSales_Order{$wo_rep_lIndex}:=$wo_rep_tSales_Order
			wo_rep_alSales_Order_Row{$wo_rep_lIndex}:=$wo_rep_lSales_Order_Row
		End if 
		
		wo_rep_arEst_Amount{$wo_rep_lIndex}:=wo_rep_arEst_Amount{$wo_rep_lIndex}+(wme_arQuantity__Unit{$wo_rep_lWmePos}*$wo_rStarted_Amount)
		wo_rep_arEst_Amount2{$wo_rep_lIndex}:=wo_rep_arEst_Amount2{$wo_rep_lIndex}+(wme_arQuantity__Unit_2{$wo_rep_lWmePos}*$wo_rStarted_Amount)
		
		wo_rep_arEst_Self_Cost{$wo_rep_lIndex}:=wo_rep_arEst_Self_Cost{$wo_rep_lIndex}+wme_arCost_Price_Total{$wo_rep_lWmePos}
		If (wo_rep_arEst_Amount{$wo_rep_lIndex}#0)
			wo_rep_arEst_Self_Cost__Unit{$wo_rep_lIndex}:=wo_rep_arEst_Self_Cost{$wo_rep_lIndex}/wo_rep_arEst_Amount{$wo_rep_lIndex}
		Else 
			wo_rep_arEst_Self_Cost__Unit{$wo_rep_lIndex}:=wo_rep_arEst_Self_Cost{$wo_rep_lIndex}
		End if 
		
		wo_rep_arEst_Sales_Price{$wo_rep_lIndex}:=wo_rep_arEst_Sales_Price{$wo_rep_lIndex}+wme_arSales_Price_Total{$wo_rep_lWmePos}
		If (wo_rep_arEst_Amount{$wo_rep_lIndex}#0)
			wo_rep_arEst_Sales_Price__Unit{$wo_rep_lIndex}:=wo_rep_arEst_Sales_Price{$wo_rep_lIndex}/wo_rep_arEst_Amount{$wo_rep_lIndex}
		Else 
			wo_rep_arEst_Sales_Price__Unit{$wo_rep_lIndex}:=wo_rep_arEst_Sales_Price{$wo_rep_lIndex}
		End if 
		wo_rep_atOrder{$wo_rep_lIndex}:=$wo_rep_tProduction_Lot+"/"+$wo_rep_tRaw_Material_Group+"/"+$wo_rep_tProduct_Group
		
		$wo_rep_lWmePos:=Find in array:C230(wme_asWork__Position_Num_id; $wo_rep_tWork; $wo_rep_lWmePos+1)
	End while 
	
	// actual raw materials  
	While ($wo_rep_lWmaPos>0)
		// find product group name for raw material
		// bind all materials belonging to this group together      
		$wo_rep_tProduct_Group:=""
		$wo_rep_tProductInfo:=""
		$wo_rep_tUnit:=""
		$wo_rep_tUnit2:=""
		$wo_rep_lProductsFound:=_qry Fld(0; pr_kProduct_ID; "="; ->wma_asRaw_Material_id{$wo_rep_lWmaPos}; ""; kFalse)
		If ($wo_rep_lProductsFound<=0)
			_err MESSAGE(_lang Current("Product not found")+": "+wma_asRaw_Material_id{$wo_rep_lWmaPos}; Current method name:C684; kTrue)
		Else 
			$wo_rep_tProduct_Group:=_fld ValueStr(pr_kProduct_ID)
			$wo_rep_tProductInfo:=_fld ValueStr(pr_kName)
			$wo_rep_tUnit:=_fld ValueStr(pr_kDesign_Unit)
			$wo_rep_tUnit2:=_fld ValueStr(pr_kDesign_Unit_2)
		End if 
		If ($wo_rep_tProduct_Group="")
			$wo_rep_tProduct_Group:="??"
		End if 
		
		// find if there already exists data for this product group; if not, add new row
		_txt:=$wo_rep_tProduction_Lot
		_txt2:=$wo_rep_tProduct_Group
		$wo_rep_lIndex:=_arr InTwoFind(->wo_rep_atProduction_Lot; ->_txt; ->wo_rep_atHeader_id; ->_txt2; 1)
		//      $wo_rep_lIndex:=Find in array(wo_rep_atHeader_id;$wo_rep_tProduct_Group)
		If ($wo_rep_lIndex<1)
			$wo_rep_lIndex:=Size of array:C274(wo_rep_atProduction_Lot)+1
			_arr apINSERT(->wo_rep_apArr; $wo_rep_lIndex; 1)
			
			wo_rep_atProduction_Lot{$wo_rep_lIndex}:=$wo_rep_tProduction_Lot
			wo_rep_atWork__Position_Num_id{$wo_rep_lIndex}:=$wo_rep_tWork
			wo_rep_atProduct_Group{$wo_rep_lIndex}:=$wo_rep_tRaw_Material_Group
			wo_rep_atHeader_id{$wo_rep_lIndex}:=$wo_rep_tProduct_Group
			wo_rep_atHeader_Info{$wo_rep_lIndex}:=$wo_rep_tProductInfo
			
			wo_rep_atUnit{$wo_rep_lIndex}:=$wo_rep_tUnit
			wo_rep_atUnit2{$wo_rep_lIndex}:=$wo_rep_tUnit2
			
			wo_rep_atSales_Order{$wo_rep_lIndex}:=$wo_rep_tSales_Order
			wo_rep_alSales_Order_Row{$wo_rep_lIndex}:=$wo_rep_lSales_Order_Row
		End if 
		
		If ($wo_rep_lUseMaterialNetAmount=kFalse)
			wo_rep_arAct_Amount{$wo_rep_lIndex}:=wo_rep_arAct_Amount{$wo_rep_lIndex}+wma_arAmount__design_unit{$wo_rep_lWmaPos}
			wo_rep_arAct_Amount2{$wo_rep_lIndex}:=wo_rep_arAct_Amount2{$wo_rep_lIndex}+wma_arAmount__design_unit_2{$wo_rep_lWmaPos}
		Else 
			wo_rep_arAct_Amount{$wo_rep_lIndex}:=wo_rep_arAct_Amount{$wo_rep_lIndex}+wma_arNet_Amount__design_unit{$wo_rep_lWmaPos}
			wo_rep_arAct_Amount2{$wo_rep_lIndex}:=wo_rep_arAct_Amount2{$wo_rep_lIndex}+wma_arNet_Amount__design_unit_2{$wo_rep_lWmaPos}
		End if 
		
		If (wo_rep_arEst_Amount{$wo_rep_lIndex}>0)
			wo_rep_arDiffPercentage{$wo_rep_lIndex}:=(wo_rep_arAct_Amount{$wo_rep_lIndex}/wo_rep_arEst_Amount{$wo_rep_lIndex})*100
			wo_rep_arDiffAbsolute{$wo_rep_lIndex}:=wo_rep_arAct_Amount{$wo_rep_lIndex}-wo_rep_arEst_Amount{$wo_rep_lIndex}
		Else 
			wo_rep_arDiffPercentage{$wo_rep_lIndex}:=0
			wo_rep_arDiffAbsolute{$wo_rep_lIndex}:=0
		End if 
		
		wo_rep_arAct_Self_Cost{$wo_rep_lIndex}:=wo_rep_arAct_Self_Cost{$wo_rep_lIndex}+wma_arCost_Price_Total{$wo_rep_lWmaPos}
		If (wo_rep_arAct_Amount{$wo_rep_lIndex}#0)
			wo_rep_arAct_Self_Cost__Unit{$wo_rep_lIndex}:=wo_rep_arAct_Self_Cost{$wo_rep_lIndex}/wo_rep_arAct_Amount{$wo_rep_lIndex}
		Else 
			wo_rep_arAct_Self_Cost__Unit{$wo_rep_lIndex}:=wo_rep_arAct_Self_Cost{$wo_rep_lIndex}
		End if 
		
		wo_rep_arAct_Sales_Price{$wo_rep_lIndex}:=wo_rep_arAct_Sales_Price{$wo_rep_lIndex}+wma_arSales_Price_Total{$wo_rep_lWmaPos}
		If (wo_rep_arAct_Amount{$wo_rep_lIndex}#0)
			wo_rep_arAct_Sales_Price__Unit{$wo_rep_lIndex}:=wo_rep_arAct_Sales_Price{$wo_rep_lIndex}/wo_rep_arAct_Amount{$wo_rep_lIndex}
		Else 
			wo_rep_arAct_Sales_Price__Unit{$wo_rep_lIndex}:=wo_rep_arAct_Sales_Price{$wo_rep_lIndex}
		End if 
		wo_rep_atOrder{$wo_rep_lIndex}:=$wo_rep_tProduction_Lot+"/"+$wo_rep_tRaw_Material_Group+"/"+$wo_rep_tProduct_Group
		
		$wo_rep_lWmaPos:=Find in array:C230(wma_asProduction_Lot; $wo_rep_tProduction_Lot; $wo_rep_lWmaPos+1)
	End while 
	
	
	// estimated work phases
	$wo_rep_lWpePos:=Find in array:C230(wpe_asWork__Position_Num_id; $wo_rep_tWork)
	While ($wo_rep_lWpePos>0)
		$wo_rep_tProduct_Group:=wpe_asWork_Load_Group_id{$wo_rep_lWpePos}  //String(wpe_alPhase_Number{$wo_rep_lWpePos};"00")+" "+
		
		_txt:=$wo_rep_tProduction_Lot
		_txt2:=$wo_rep_tProduct_Group
		$wo_rep_lIndex:=_arr InTwoFind(->wo_rep_atProduction_Lot; ->_txt; ->wo_rep_atHeader_id; ->_txt2; 1)
		//      $wo_rep_lIndex:=Find in array(wo_rep_atHeader_id;$wo_rep_tProduct_Group)
		If ($wo_rep_lIndex<1)
			$wo_rep_lIndex:=Size of array:C274(wo_rep_atProduction_Lot)+1
			_arr apINSERT(->wo_rep_apArr; $wo_rep_lIndex; 1)
			wo_rep_atProduction_Lot{$wo_rep_lIndex}:=$wo_rep_tProduction_Lot
			wo_rep_atWork__Position_Num_id{$wo_rep_lIndex}:=$wo_rep_tWork
			wo_rep_atHeader_id{$wo_rep_lIndex}:=$wo_rep_tProduct_Group
			wo_rep_atHeader_Info{$wo_rep_lIndex}:=wlg_asName{$wo_rep_lWpePos}
			If (wpe_afSubcontract{$wo_rep_lWpePos}=True:C214)
				wo_rep_atProduct_Group{$wo_rep_lIndex}:=$wo_rep_tSubcontract_Group
			Else 
				wo_rep_atProduct_Group{$wo_rep_lIndex}:=$wo_rep_tWork_Phase_Group
			End if 
			
			wo_rep_atSales_Order{$wo_rep_lIndex}:=$wo_rep_tSales_Order
			wo_rep_alSales_Order_Row{$wo_rep_lIndex}:=$wo_rep_lSales_Order_Row
		End if 
		
		wo_rep_arEst_Amount{$wo_rep_lIndex}:=wpe_arWork_Time__unit{$wo_rep_lWpePos}*$wo_rStarted_Amount
		wo_rep_arEst_Amount2{$wo_rep_lIndex}:=wpe_arSetup_Time__lot{$wo_rep_lWpePos}
		wo_rep_arEst_Self_Cost{$wo_rep_lIndex}:=wpe_arWork_Cost__unit{$wo_rep_lWpePos}
		wo_rep_arEst_Sales_Price{$wo_rep_lIndex}:=wpe_arWork_Sales_Price__unit{$wo_rep_lWpePos}
		If (wo_rep_arEst_Amount{$wo_rep_lIndex}#0)
			wo_rep_arEst_Self_Cost__Unit{$wo_rep_lIndex}:=wo_rep_arEst_Self_Cost{$wo_rep_lIndex}/wo_rep_arEst_Amount{$wo_rep_lIndex}
			wo_rep_arEst_Sales_Price__Unit{$wo_rep_lIndex}:=wo_rep_arEst_Sales_Price{$wo_rep_lIndex}/wo_rep_arEst_Amount{$wo_rep_lIndex}
		Else 
			wo_rep_arEst_Self_Cost__Unit{$wo_rep_lIndex}:=wo_rep_arEst_Self_Cost{$wo_rep_lIndex}
			wo_rep_arEst_Sales_Price__Unit{$wo_rep_lIndex}:=wo_rep_arEst_Sales_Price{$wo_rep_lIndex}
		End if 
		
		wo_rep_atUnit{$wo_rep_lIndex}:=$wo_rep_tHour
		wo_rep_atUnit2{$wo_rep_lIndex}:=$wo_rep_tHour
		
		If (wpe_afSubcontract{$wo_rep_lWpePos}=True:C214)
			wo_rep_atOrder{$wo_rep_lIndex}:=$wo_rep_tProduction_Lot+"/"+ksSpace+wo_rep_atProduct_Group{$wo_rep_lIndex}+"/"+String:C10(wpe_alPhase_Number{$wo_rep_lWpePos}; "00")
		Else 
			wo_rep_atOrder{$wo_rep_lIndex}:=$wo_rep_tProduction_Lot+"/"+ksSpace+ksSpace+wo_rep_atProduct_Group{$wo_rep_lIndex}+"/"+String:C10(wpe_alPhase_Number{$wo_rep_lWpePos}; "00")
		End if 
		
		$wo_rep_lWpePos:=Find in array:C230(wpe_asWork__Position_Num_id; $wo_rep_tWork; $wo_rep_lWpePos+1)
	End while 
	
	// actual work phases
	While ($wo_rep_lWpaPos>0)
		$wo_rep_tProduct_Group:=wpa_asWork_Load_Group_id{$wo_rep_lWpaPos}  //String(wpa_alWork_Phase_Est_id{$wo_rep_lWpaPos};"00")+" "+
		
		_txt:=$wo_rep_tProduction_Lot
		_txt2:=$wo_rep_tProduct_Group
		$wo_rep_lIndex:=_arr InTwoFind(->wo_rep_atProduction_Lot; ->_txt; ->wo_rep_atHeader_id; ->_txt2; 1)
		//      $wo_rep_lIndex:=Find in array(wo_rep_atHeader_id;$wo_rep_tProduct_Group)
		If ($wo_rep_lIndex<1)
			$wo_rep_lIndex:=Size of array:C274(wo_rep_atProduction_Lot)+1
			_arr apINSERT(->wo_rep_apArr; $wo_rep_lIndex; 1)
			wo_rep_atProduction_Lot{$wo_rep_lIndex}:=$wo_rep_tProduction_Lot
			wo_rep_atWork__Position_Num_id{$wo_rep_lIndex}:=$wo_rep_tWork
			wo_rep_atHeader_id{$wo_rep_lIndex}:=$wo_rep_tProduct_Group
			wo_rep_atHeader_Info{$wo_rep_lIndex}:=wpa_atWork_Description{$wo_rep_lWpaPos}
			_txt:=wo_rep_atHeader_id{$wo_rep_lIndex}
			_qry Fld(0; wlg_kWork_Load_Group_ID; "="; ->_txt; ""; kFalse)
			If (_sel RecsInSel(wlg_kTbl)>0)
				wo_rep_atHeader_Info{$wo_rep_lIndex}:=_fld ValueStr(wlg_kName)
			End if 
			If (wpa_afSubcontract{$wo_rep_lWpaPos}=True:C214)
				wo_rep_atProduct_Group{$wo_rep_lIndex}:=$wo_rep_tSubcontract_Group
			Else 
				wo_rep_atProduct_Group{$wo_rep_lIndex}:=$wo_rep_tWork_Phase_Group
			End if 
			wo_rep_atSales_Order{$wo_rep_lIndex}:=$wo_rep_tSales_Order
			wo_rep_alSales_Order_Row{$wo_rep_lIndex}:=$wo_rep_lSales_Order_Row
		End if 
		
		wo_rep_arAct_Amount{$wo_rep_lIndex}:=wo_rep_arAct_Amount{$wo_rep_lIndex}+wpa_arWork_Time__amount{$wo_rep_lWpaPos}
		wo_rep_atUnit{$wo_rep_lIndex}:=$wo_rep_tHour
		wo_rep_arAct_Amount2{$wo_rep_lIndex}:=wo_rep_arAct_Amount2{$wo_rep_lIndex}+wpa_arSetup_Time__amount{$wo_rep_lWpaPos}
		wo_rep_atUnit2{$wo_rep_lIndex}:=$wo_rep_tHour
		
		If ((wo_rep_arEst_Amount{$wo_rep_lIndex}>0) & (wo_rep_arAct_Amount{$wo_rep_lIndex}>0))
			wo_rep_arDiffPercentage{$wo_rep_lIndex}:=(wo_rep_arAct_Amount{$wo_rep_lIndex}/wo_rep_arEst_Amount{$wo_rep_lIndex})*100
			wo_rep_arDiffAbsolute{$wo_rep_lIndex}:=wo_rep_arAct_Amount{$wo_rep_lIndex}-wo_rep_arEst_Amount{$wo_rep_lIndex}
		Else 
			wo_rep_arDiffPercentage{$wo_rep_lIndex}:=0
			wo_rep_arDiffAbsolute{$wo_rep_lIndex}:=0
		End if 
		
		wo_rep_arAct_Self_Cost{$wo_rep_lIndex}:=wo_rep_arAct_Self_Cost{$wo_rep_lIndex}+wpa_arWork_Cost_Price__amount{$wo_rep_lWpaPos}
		wo_rep_arAct_Sales_Price{$wo_rep_lIndex}:=wo_rep_arAct_Sales_Price{$wo_rep_lIndex}+wpa_arWork_Sales_Price__amount{$wo_rep_lWpaPos}
		If (wo_rep_arAct_Amount{$wo_rep_lIndex}#0)
			wo_rep_arAct_Self_Cost__Unit{$wo_rep_lIndex}:=wo_rep_arAct_Self_Cost{$wo_rep_lIndex}/wo_rep_arAct_Amount{$wo_rep_lIndex}
			wo_rep_arAct_Sales_Price__Unit{$wo_rep_lIndex}:=wo_rep_arAct_Sales_Price{$wo_rep_lIndex}/wo_rep_arAct_Amount{$wo_rep_lIndex}
		Else 
			wo_rep_arAct_Self_Cost__Unit{$wo_rep_lIndex}:=wo_rep_arAct_Self_Cost{$wo_rep_lIndex}
			wo_rep_arAct_Sales_Price__Unit{$wo_rep_lIndex}:=wo_rep_arAct_Sales_Price{$wo_rep_lIndex}
		End if 
		
		If (wpa_afSubcontract{$wo_rep_lWpaPos}=True:C214)
			wo_rep_atOrder{$wo_rep_lIndex}:=$wo_rep_tProduction_Lot+"/"+ksSpace+wo_rep_atProduct_Group{$wo_rep_lIndex}+"/"+String:C10(wpa_alWork_Phase_Est_id{$wo_rep_lWpaPos}; "00")
		Else 
			wo_rep_atOrder{$wo_rep_lIndex}:=$wo_rep_tProduction_Lot+"/"+ksSpace+ksSpace+wo_rep_atProduct_Group{$wo_rep_lIndex}+"/"+String:C10(wpa_alWork_Phase_Est_id{$wo_rep_lWpaPos}; "00")
		End if 
		
		$wo_rep_lWpaPos:=Find in array:C230(wpa_asProduction_Lot; $wo_rep_tProduction_Lot; $wo_rep_lWpaPos+1)
	End while 
	
	// subcontracts
	While ($wo_rep_lPorPos>0)
		$wo_rep_lIndex:=Size of array:C274(wo_rep_atProduction_Lot)+1
		_arr apINSERT(->wo_rep_apArr; $wo_rep_lIndex; 1)
		
		wo_rep_atProduction_Lot{$wo_rep_lIndex}:=$wo_rep_tProduction_Lot
		wo_rep_atWork__Position_Num_id{$wo_rep_lIndex}:=$wo_rep_tWork
		wo_rep_atProduct_Group{$wo_rep_lIndex}:=$wo_rep_tSubcontract_Group
		wo_rep_atHeader_id{$wo_rep_lIndex}:=po_asSupplier_id{$wo_rep_lPorPos}
		wo_rep_atHeader_Info{$wo_rep_lIndex}:=por_atExplanation{$wo_rep_lPorPos}
		
		wo_rep_atSales_Order{$wo_rep_lIndex}:=$wo_rep_tSales_Order
		wo_rep_alSales_Order_Row{$wo_rep_lIndex}:=$wo_rep_lSales_Order_Row
		
		wo_rep_arEst_Amount{$wo_rep_lIndex}:=por_arOrder_Amount{$wo_rep_lPorPos}
		wo_rep_arAct_Amount{$wo_rep_lIndex}:=por_arDelivered_Amount{$wo_rep_lPorPos}  //por_arOrder_Amount{$wo_rep_lPorPos}
		wo_rep_atUnit{$wo_rep_lIndex}:=por_asOrder_Unit{$wo_rep_lPorPos}
		wo_rep_arEst_Amount2{$wo_rep_lIndex}:=por_arOrder_Amount{$wo_rep_lPorPos}
		wo_rep_arAct_Amount2{$wo_rep_lIndex}:=por_arDelivered_Amount{$wo_rep_lPorPos}  //por_arOrder_Amount{$wo_rep_lPorPos}
		wo_rep_atUnit2{$wo_rep_lIndex}:=por_asOrder_Unit{$wo_rep_lPorPos}
		
		If (wo_rep_arEst_Amount{$wo_rep_lIndex}>0)
			wo_rep_arDiffPercentage{$wo_rep_lIndex}:=(wo_rep_arAct_Amount{$wo_rep_lIndex}/wo_rep_arEst_Amount{$wo_rep_lIndex})*100
			wo_rep_arDiffAbsolute{$wo_rep_lIndex}:=wo_rep_arAct_Amount{$wo_rep_lIndex}-wo_rep_arEst_Amount{$wo_rep_lIndex}
		Else 
			wo_rep_arDiffPercentage{$wo_rep_lIndex}:=0
			wo_rep_arDiffAbsolute{$wo_rep_lIndex}:=0
		End if 
		
		wo_rep_arEst_Self_Cost{$wo_rep_lIndex}:=por_arPurchase_Price_Total{$wo_rep_lPorPos}
		wo_rep_arAct_Self_Cost{$wo_rep_lIndex}:=por_arPurchase_Price_Total{$wo_rep_lPorPos}
		wo_rep_arEst_Sales_Price{$wo_rep_lIndex}:=wo_rep_arEst_Self_Cost{$wo_rep_lIndex}
		wo_rep_arAct_Sales_Price{$wo_rep_lIndex}:=wo_rep_arAct_Self_Cost{$wo_rep_lIndex}
		If (wo_rep_arEst_Amount{$wo_rep_lIndex}#0)
			wo_rep_arEst_Self_Cost__Unit{$wo_rep_lIndex}:=wo_rep_arEst_Self_Cost{$wo_rep_lIndex}/wo_rep_arEst_Amount{$wo_rep_lIndex}
			wo_rep_arEst_Sales_Price__Unit{$wo_rep_lIndex}:=wo_rep_arEst_Sales_Price{$wo_rep_lIndex}/wo_rep_arEst_Amount{$wo_rep_lIndex}
		Else 
			wo_rep_arEst_Self_Cost__Unit{$wo_rep_lIndex}:=wo_rep_arEst_Self_Cost{$wo_rep_lIndex}
			wo_rep_arEst_Sales_Price__Unit{$wo_rep_lIndex}:=wo_rep_arEst_Sales_Price{$wo_rep_lIndex}
		End if 
		If (wo_rep_arAct_Amount{$wo_rep_lIndex}#0)
			wo_rep_arAct_Self_Cost__Unit{$wo_rep_lIndex}:=wo_rep_arAct_Self_Cost{$wo_rep_lIndex}/wo_rep_arAct_Amount{$wo_rep_lIndex}
			wo_rep_arAct_Sales_Price__Unit{$wo_rep_lIndex}:=wo_rep_arAct_Sales_Price{$wo_rep_lIndex}/wo_rep_arAct_Amount{$wo_rep_lIndex}
		Else 
			wo_rep_arAct_Self_Cost__Unit{$wo_rep_lIndex}:=wo_rep_arAct_Self_Cost{$wo_rep_lIndex}
			wo_rep_arAct_Sales_Price__Unit{$wo_rep_lIndex}:=wo_rep_arAct_Sales_Price{$wo_rep_lIndex}
		End if 
		wo_rep_atOrder{$wo_rep_lIndex}:=$wo_rep_tProduction_Lot+"/"+ksSpace+$wo_rep_tSubcontract_Group+"/"+po_asSupplier_id{$wo_rep_lPorPos}
		
		$wo_rep_lPorPos:=Find in array:C230(por_asProduction_Lot; $wo_rep_tProduction_Lot; $wo_rep_lPorPos+1)
	End while 
	
	
	$wo_rep_lWoPos:=Find in array:C230(wo_rep_atProduction_Lot; $wo_rep_tProduction_Lot)
	If ($wo_rep_lWoPos<=0)
		$wo_rep_lIndex:=Size of array:C274(wo_rep_atProduction_Lot)+1
		_arr apINSERT(->wo_rep_apArr; $wo_rep_lIndex; 1)
		_arr apCLEAR(->wo_rep_apArr; $wo_rep_lIndex)
		wo_rep_atProduction_Lot{$wo_rep_lIndex}:=$wo_rep_tProduction_Lot
		wo_rep_atOrder{$wo_rep_lIndex}:=$wo_rep_tProduction_Lot
		wo_rep_atSales_Order{$wo_rep_lIndex}:=$wo_rep_tSales_Order
		wo_rep_alSales_Order_Row{$wo_rep_lIndex}:=$wo_rep_lSales_Order_Row
	End if 
End for 

//copy est. phase values to act values
If ($wo_rep_tEstToActLoadGroups#"")
	$wo_rep_tEstToActLoadGroups:=","+$wo_rep_tEstToActLoadGroups+","
	$wo_rep_lSelSize:=Size of array:C274(wo_rep_atProduction_Lot)
	For ($wo_rep_lSelIndex; 1; $wo_rep_lSelSize)
		If ((wo_rep_atProduct_Group{$wo_rep_lSelIndex}=$wo_rep_tWork_Phase_Group) & (wo_rep_arAct_Amount{$wo_rep_lSelIndex}=0))
			$wo_rep_tLoadGroupToCheck:=","+wo_rep_atHeader_id{$wo_rep_lSelIndex}+","
			If (Position:C15($wo_rep_tLoadGroupToCheck; $wo_rep_tEstToActLoadGroups)>0)
				wo_rep_arAct_Amount{$wo_rep_lSelIndex}:=wo_rep_arEst_Amount{$wo_rep_lSelIndex}
				wo_rep_arAct_Amount2{$wo_rep_lSelIndex}:=wo_rep_arEst_Amount2{$wo_rep_lSelIndex}
				wo_rep_arAct_Self_Cost{$wo_rep_lSelIndex}:=wo_rep_arEst_Self_Cost{$wo_rep_lSelIndex}
				wo_rep_arAct_Sales_Price{$wo_rep_lSelIndex}:=wo_rep_arEst_Sales_Price{$wo_rep_lSelIndex}
				wo_rep_arAct_Self_Cost__Unit{$wo_rep_lSelIndex}:=wo_rep_arEst_Self_Cost{$wo_rep_lSelIndex}
				wo_rep_arAct_Sales_Price__Unit{$wo_rep_lSelIndex}:=wo_rep_arEst_Sales_Price__Unit{$wo_rep_lSelIndex}
			End if 
		End if 
	End for 
End if 

