//%attributes = {}
//*****************************************************************************
//Method: SDA_4dK_GetResourceID(p4DK_ID;ResourceType;DocRef)->Status
//
//Written by  Tod Gentille on 4/11/98
//
//Purpose: Show the user the available 4dK resources and allow them
//to pick one. Return the ID of the selected resource in the passed parameter

//$1-pointer to longint var to hold selected resource ID
//$2 - text indicating resource type to get list of
//$3 - time document ref to opened resource file
// is required; optional, default=true
//Copyright 1998 Syncor Systems, Inc.
//
//******************************************************************************
C_POINTER:C301($1; $p4DK_ID)
_O_C_STRING:C293(4; $2; $s4ResourceType)
C_TIME:C306($3; $hDocRef)
C_BOOLEAN:C305($0)

$p4DK_ID:=$1
$s4ResourceType:=$2
$hDocRef:=$3

$0:=False:C215  //will get set to true if everything goes OK
SDA_ResEditorSetUp($s4ResourceType; $hDocRef)

//    `#### Show the user a list of available resource names
SORT ARRAY:C229(<>as254SDA_KonstantStrings_L; <>alSDA_ResourceIDs)
<>s80ResEditorTitle:="Resource Editor"
Open window:C153(80; 80; 479; 477; Movable dialog box:K34:7)
DIALOG:C40("SDA_ResEditor")

If (<>as254SDA_KonstantStrings_L>0)  //if a resource was selected
	//#### make sure they selected one
	$p4DK_ID->:=<>alSDA_ResourceIDs{<>as254SDA_KonstantStrings_L}
	$0:=True:C214  //indicate a resource selected
	//leave the window open to use for the resource element form
	
Else   //resource not selected
	CLOSE WINDOW:C154  //close the dialog window, since we won't use it for the element editor
End if   //If (<>as254SDA_KonstantStrings_L>0)  `if a resource was selected
