//%attributes = {}
//******************************************************************************
//Method: SDA_Replace_N_Methods
//Written by  Tod Gentille on 9/28/1998
//
//Purpose: Perform a find and replace loop on n methods in the database
//n is the number specified by the user from a prompt. We don't just do 
//all the methods because 4D tends to get slower and slower about
//sequentially opening a large number of methods.
//NOTE : This method starts from the currently highlighted
//method in the explorer. If the Methods Tab is not active this won't work
//you can't post a CMD-P to make the methods tab active because
//that also moves you to the top of the methods list on the method tab
//
//$1 - Find string (tramp data for SDA_Replace)
//$2 - Replace string (tramp data for SDA_Replace)
//
//Copyright 1998 Syncor Systems, Inc.
//
//******************************************************************************

C_TEXT:C284($1; $tFind; $2; $tReplace)
C_BOOLEAN:C305($bStatus)
C_LONGINT:C283($i; $lSize)
ARRAY LONGINT:C221(<>alWinRef_L; 0)
WINDOW LIST:C442(<>alWinRef_L)  //find out which windows are currently open. So we don't close one that
//was already open

$tFind:=$1
$tReplace:=$2

$lSize:=Num:C11(_info_ Request(<>SDA_HOW_MANY_PROMPT))

If (OK=1)
	For ($i; 1; $lSize)
		If (SDA_util_OpenNextExplorerMethod)
			SDA_util_PostSelectAll  //select all the contents of the window for replacement  
			SDA_Replace($tFind; $tReplace)
			$bStatus:=SDA_util_CloseIfNewWindow(-><>alWinRef_L)  //if it doesn't close there is not much we can do
			
		Else   //method window did not open for some reason   
			//      
		End if 
	End for 
	
	BEEP:C151  //let the user know they should get back to work
End if 
