//%attributes = {}
//******************************************************************************
//Method: SDA_ResEditorGetNextAvailResID
//Written by  Cyril Harnisch on 2/17/99
//
//Purpose: Tries to find an available resource ID in the range specified. If it
// can't it returns a resource ID of zero to indicate there was a problem.
//
//$1 - pointer - resource IDs already in use
//$2 - longint - resource ID to start with
//$3 - longint - last resource ID to consider
//$0 - longint - resource ID to use
//
//Copyright 1999 Syncor Systems, Inc.
//******************************************************************************
C_POINTER:C301($1; $pResourceID_Array)
C_LONGINT:C283($2; $3; $0; $lStartingResourceID; $lEndingResourceID)
C_LONGINT:C283($lResourceIDFoundPosition; $lResouceID_ToTry)

$pResourceID_Array:=$1
$lStartingResourceID:=$2
$lEndingResourceID:=$3

$lResouceID_ToTry:=$lStartingResourceID
$0:=0  //set resource to zero to indicate a problem    

While ($lResouceID_ToTry<=$lEndingResourceID)  //not past last ID to use
	$lResourceIDFoundPosition:=Find in array:C230($pResourceID_Array->; $lStartingResourceID)
	
	If ($lResourceIDFoundPosition=-1)  //if resource ID not found
		$0:=$lResouceID_ToTry  //use this resource ID
		$lResouceID_ToTry:=$lEndingResourceID  //terminate the loop
		
	Else   //resource found, can't use it
		$0:=0  //set resource to zero to indicate a problem    
	End if 
	
	$lResouceID_ToTry:=$lResouceID_ToTry+1  //try the next ID
End while 
