//%attributes = {}
//****************************************************************************
//
//Method: SDA_ToolOps(pPopup)
//
//Written by  Tod Gentille on 10/17/97
//
//Purpose: A general purpose routine to handle the Tools popup
//
//$1 -ptr to the pop up called via SELF from the popup
//
//Copyright 1997 Syncor Systems, Inc.
//
//******************************************************************************
C_POINTER:C301($1; $pToolPopup)
C_LONGINT:C283($lSelItem)
C_TEXT:C284($tChoice)
//
$pToolPopup:=$1

$lSelItem:=$pToolPopup->  //Find out which item was selected in the popup
$tChoice:=$pToolPopup->{$lSelItem}  //Get the selected item

If ($lSelItem>0)
	
	Case of 
			
		: ($tChoice="Find String Resource")
			SDA_FindSTRResource
			
		: ($tChoice="Show [Table]Field Information")
			SDA_FieldGetInfo
			
		: ($tChoice="Line Number")
			SDA_LineNumber
			
		: ($tChoice="Add Extra [ ] Popup Information")
			SDA_ExtraInfoAdd
			
		: ($tChoice="Toggle Verbose Popup Information")
			<>bSDA_VerboseFieldInfo:=Not:C34(<>bSDA_VerboseFieldInfo)
			SDA_TableFieldListInit(-><>lrSDA_TableList)
			SDA_TableFieldListInit(-><>lrSDA_TableList_horiz)
			
		: ($tChoice="Toggle Auto Comment Replacement")
			<>bSDA_ForceRplcComment:=Not:C34(<>bSDA_ForceRplcComment)
			<>atSDA_Header:=0  //Make sure we don't initiate any action
			SDA_HeaderOps(-><>atSDA_Header)
			
		: ($tChoice="Toggle Clipboard@")
			<>bPreserveClipboard:=Not:C34(<>bPreserveClipboard)
			SDA_ToolOpts_ClpbrdPrsrvToggle(<>bPreserveClipboard; -><>atSDA_ToolOps; $lSelItem)
			
		: ($tChoice="Remove Extra [ ] Popup Information")
			SDA_ExtraInfoRemove
			
		: ($tChoice="Rebuild [ ] Popup")
			//This is intended as a way to reflect additions and changes made
			// to tables and columns in the structure in the table and
			// column drop down list      
			SDA_TableFieldListInit(-><>lrSDA_TableList)
			SDA_TableFieldListInit(-><>lrSDA_TableList_horiz)
			
		: ($tChoice="Disable Shortcuts")
			SDA_DisableShortcuts($pToolPopup)
			
		: ($tChoice="Enable Shortcuts")
			SDA_EnableShortcuts($pToolPopup)
			
		: ($tChoice="Swap Equation Sides")
			SDA_SwapSides
			
		: (SDA_ToolOps_y($tChoice))  //Your added operations should be put in this method
			
		Else 
			SDA_util_BugAlert(<>SDA_UNEXPECTED_PARAM; "Method: SDA_ToolOps"; $tChoice)
	End case 
	
End if 
