//%attributes = {}
//******************************************************************************
//Method: SDA_WindowOps(pPopup)
//Written by  Tod Gentille on 9/29/1998
//
//Purpose: A general purpose routine to handle the Windows popup

//
//$1 -ptr to the pop up called via SELF from the popup
//
//Copyright 1998 Syncor Systems, Inc.
//
//Modified by: Cyril Harnisch, Syncor Systems, Inc., 3/3/99
//Reason: Added comments; moved instantiation of $tChoice inside of conditional.
//******************************************************************************
C_POINTER:C301($1)
C_LONGINT:C283($iSelItem)
C_TEXT:C284($tChoice)
//
$iSelItem:=$1->  //Find out which item was selected in the popup

If ($iSelItem>0)  //if an item was selected from the drop down
	$tChoice:=$1->{$iSelItem}  //Get the selected item
	
	Case of   //case of drop down choice
			
		: ($tChoice="Tile and Resize Method Windows")
			SDA_TileWindows(True:C214; True:C214; True:C214)
			
		: ($tChoice="Tile All Windows")
			SDA_TileWindows(False:C215; False:C215; False:C215)
			
		: ($tChoice="Tile Method Windows")
			SDA_TileWindows(False:C215; True:C214; False:C215)
			
		: ($tChoice="Tile and Resize All Windows")
			SDA_TileWindows(True:C214; False:C215; True:C214)
			
		: ($tChoice="Tile and Resize Large Windows")
			SDA_TileWindows(True:C214; False:C215; False:C215)
			
			
		: ($tChoice="Save Window Group")
			SDA_WindowGroupSave(True:C214)
			
		: ($tChoice="Load Window Group")
			SDA_WindowGroupLoad(True:C214)
			
		: ($tChoice="Save Named Window Group")
			SDA_WindowGroupSave(False:C215)
			
		: ($tChoice="Load Named Window Group")
			SDA_WindowGroupLoad(False:C215)
			
		: ($tChoice="Close Method Windows")
			SDA_WindowCloseMethods
			
		: ($tChoice="Close Form Windows")
			SDA_WindowCloseForms
			
		: (SDA_WindowOps_y($tChoice))  //Your added operations should be put in this method
			
		Else   //no recognized drop down choice
			SDA_util_BugAlert(<>SDA_UNEXPECTED_PARAM; " Method: SDA_WindowOps "; $tChoice)
			
	End case   //  Case of   `case of drop down choice
	
End if   //If ($iSelItem>0)  `if an item was selected from the drop down
