//%attributes = {"publishedSql":true}
//METHOD: ARR_Add_Elements_to_End
//
//This adds a specified number of elements to the end of an array
//   NOTE: the added array elements are initialized with a default value (NULL)
//
//$1 is dereferenced array to make larger
//$2 is number of elements to add
//
//Deep Sky Technologies, Inc.
//http://www.deepskytech.com/
//================================================================================
_O_C_STRING:C293(32; $_dss_sMethodName)
$_dss_sMethodName:="ARR_Add_Elements_to_End"
//--------------------------------------------------------------------------------
If (False:C215)  //methods and variables used indirectly herein (for Insider compatibility)
	//indirect_variables
	//indirect_method_calls
End if   //false  
//================================================================================
C_POINTER:C301($1; $_dss_pArray)
$_dss_pArray:=$1
C_LONGINT:C283($2; $_dss_lElementsToAdd)
$_dss_lElementsToAdd:=$2
//--------------------------------------------------------------------------------
//method_wide_constants_declarations
//--------------------------------------------------------------------------------
C_LONGINT:C283($_dss_lType)
C_LONGINT:C283($_dss_lSize)
C_POINTER:C301($_dss_pNULLByType)
C_LONGINT:C283($_dss_lLoopCounter01)
//================================================================================
$_dss_lType:=Type:C295($_dss_pArray)
If ($_dss_lType=Is pointer:K8:14)
	$_dss_lType:=Type:C295($_dss_pArray->)
	If (_dss_ArrIs($_dss_lType))
		//check how many elements have been specified to be added    
		Case of 
			: ($_dss_lElementsToAdd>0)  //more than one element being added
				//add the element(s)        
				$_dss_lSize:=Size of array:C274($_dss_pArray->)
				INSERT IN ARRAY:C227($_dss_pArray->; $_dss_lSize+1; $_dss_lElementsToAdd)
				//initialize the new elements
				$_dss_pNULLByType:=_dss_VarByTypeNullSet($_dss_lType)
				If ($_dss_pNULLByType#_dss_pNULL)
					For ($_dss_lLoopCounter01; $_dss_lSize+1; $_dss_lSize+$_dss_lElementsToAdd; 1)
						$_dss_pArray->{$_dss_lLoopCounter01}:=$_dss_pNULLByType->
					End for 
				End if 
				//
			: ($_dss_lElementsToAdd=0)  //no elements are to added
				//do_nothing
				//
			: ($_dss_lElementsToAdd<0)  //negative number of elements specified to be added        
				_err MESSAGE("Negative number of elements specified to be added: "+String:C10($_dss_lElementsToAdd); $_dss_sMethodName; kFalse)
		End case 
		//
	Else   //ERROR
		_err MESSAGE_PARAMETER("$1 is not pointer to array"; "_dss_ARR_CLEAR"; kFalse)
	End if 
	//  
Else   //ERROR
	_err MESSAGE_PARAMETER("$1 is not pointer"; "_dss_ARR_CLEAR"; kFalse)
End if 
//eom
