//%attributes = {}
//_prli_SetMiscOpts(AreaRef;ConstrainRightColumn;SizeArraysToZero;
//    PasteWidthsToClipboard)

//Part of the PrintTwist(tm) component by Business Brothers, Inc.
//Written by Tony Ringsmuth

//FUNCTION:
//Set some other options, beyond the scope of PrintList.

//PARAMETERS:
//$1: Longint: AreaReference
//$2: Longint: ConstrainRightColumn
//   Description: Normal PrintList stretches the right most column width in a
//     given area out to the right border of the area.  In cases where the column 
//     is a right-justified column, this can look akward.  If you specify this
//     option, then PrintTwist will constrict the width of the right-most column
//     to no wider than the developer-configured width.


//$3: Longint: SizeArraysToZeroWhenFinished
//  When finished printing this area, size all data arrays to zero

//$4: Longint: PasteWidthsToClipboard
//  This option will paste the auto-calculated column widths to the clip-board.
//  The intention of this is so that you can paste these widths into your code.

C_LONGINT:C283($1; $2; $_prli_iFindArea)
$_prli_iFindArea:=_prli_Util_FindAreaRef($1; Current method name:C684)
If ($_prli_iFindArea>-1)
	_prli_aConstrainRightColWidth{$_prli_iFindArea}:=($2=1)
	If (Count parameters:C259>2)
		_prli_aClearArraysWhenDone{$_prli_iFindArea}:=($3=1)
		If (Count parameters:C259>3)
			_prli_aPasteWidthsToClipboard{$_prli_iFindArea}:=($4=1)
		End if 
	End if 
End if 
