//%attributes = {}
//_prli_Util_DateString(Date;Format)

//Part of the PrintTwist(tm) component by Business Brothers, Inc.
//Written by Tony Ringsmuth

//FUNCTION
//Return the text of a date in specified format

//BB_DateString(Date;"TextFormat";{Opts})
//Tony Ringsmuth  12/14/99
//Part of the BB_Base Component, by Business Brothers.

//FUNCTION: Return a date string

//PARAMETERS: 
//$1: Date
//$2: Format String

//Keywords/characters include:

//D: Outputs Day_of_month in 1 or 2 character format
//DD: Outputs Day_of_month in 2 character format (leading zero if less than 10)
//ddd: Ouptuts Day_of_week in abbreviated name format: Sun
//DDD: Outputs Day_of_week in _str_ ToUpper abbreviated format: SUN
//Day: Outputs Day_of_week in DayName format: Sunday
//M: Outputs Month number in 1 or 2 char format
//MM: Outputs Month number in 2 char format (leading zero if less than 10)
//MMM: Outputs Month abbreviation: Jan
//Month: Outputs Month name
//Y: (same as YY): Outputs Year number in 2 char format
//YY: Outputs Year number in 2 char format
//YYYY: Outputs Year number in 4 char format


//Examples:
//BB_DateString(!1/1/00!;"m/d/y")->"1/1/00"
//BB_DateString(!1/1/00!;"mm/dd/yy")->"01/01/00"
//BB_DateString(!1/1/00!;"yyyy mm dd")->"2000 01 01"
//BB_DateString(!1/1/00!;"mmm dd")->"Jan 01"
//BB_DateString(!1/1/00!;"Month d, yyyy")->"January 1, 2000"
//BB_DateString(!1/1/00!;"DDD, Month d, yyyy")->"Mon, January 1, 2000"
//BB_DateString(!1/1/00!;"ddd, Month d, yyyy")->"Mon, January 1, 2000"
//BB_DateString(!1/1/00!;"Day, Month d, yyyy")->"Monday, January 1, 2000"


//REVISION HISTORY
//Rev: 11/20/06: Added 4DMethod format option
//Rev: 03/02/05: for 0/0/0 date, return null string for Day
//Rev: 09/27/00: Bug Fixes
//Rev: 09/21/00: Added DDD and Day options

C_DATE:C307($1)
C_TEXT:C284($2; $_prli_Format)
C_LONGINT:C283($3; $_prli_opts; $_prli_pDDD; $_prli_pDay; $_prli_iDayNumber)
//Opts is a Bitwise parameter:
$_prli_opts:=0
If (Count parameters:C259>2)
	$_prli_opts:=$3
End if 
$_prli_Format:=$2

If ($_prli_Format="@-")
	$_prli_ReturnNullForNullDate:=True:C214
	$_prli_Format:=Substring:C12($_prli_Format; 1; Length:C16($_prli_Format)-1)
Else 
	$_prli_ReturnNullForNullDate:=($_prli_opts ?? 0)  //+1   `If format ends with a minus sign, then return "" for null dates
End if 


Case of 
	: ($_prli_Format="4DMethod;@")
		C_DATE:C307(_prli_Date1)
		_prli_Date1:=$1
		_prli_Text1:=""
		$_prli_MethodName:=Substring:C12($_prli_Format; 10)
		_prli_Util_Execute("_prli_Text1:="+$_prli_MethodName+"(_prli_Date1)"; $_prli_MethodName)
		$0:=_prli_Text1
		_prli_Text1:=""
		_prli_Date1:=!00-00-00!
		
		
		
	: (($1=!00-00-00!) & $_prli_ReturnNullForNullDate)
		$0:=""
		
	: (Length:C16($_prli_Format)=0)
		$0:=String:C10($1; Internal date short special:K1:4)
		
	: ((Length:C16($_prli_Format)=1) & (Character code:C91($_prli_Format)>=48) & (Character code:C91($_prli_Format)<=57))  //The traditional PL Date/4D date string mechanism
		$0:=String:C10($1; Num:C11($_prli_Format))
		
		
	Else 
		
		
		$0:=$_prli_Format
		
		If ($1=!00-00-00!)
			$_prli_iDayNumber:=0
		Else 
			$_prli_iDayNumber:=Day number:C114($1)
		End if 
		
		$_prli_pDay:=Position:C15("Day"; $0)
		If ($_prli_pDay>0)
			$0:=Replace string:C233($0; "Day"; "x_1")
		End if 
		$_prli_pDDD:=Position:C15("DDD"; $0)
		If ($_prli_pDDD>0)
			$_prli_Uppercase:=((Character code:C91($0[[$_prli_pDDD]])=68) & (Character code:C91($0[[$_prli_pDDD+1]])=68) & (Character code:C91($0[[$_prli_pDDD+2]])=68))  //is it "DDD" (all _str_ ToUpper)
			$0:=Replace string:C233($0; "DDD"; "XXX")
		End if 
		
		Case of 
			: (Position:C15("YYYY"; $0)>0)
				$0:=Replace string:C233($0; "YYYY"; String:C10(Year of:C25($1); "0000"))
			: (Position:C15("YY"; $0)>0)
				$0:=Replace string:C233($0; "YY"; String:C10(Year of:C25($1)%100; "00"))
			: (Position:C15("Y"; $0)>0)
				$0:=Replace string:C233($0; "Y"; String:C10(Year of:C25($1)%100; "00"))
		End case 
		
		Case of 
			: (Position:C15("DD"; $0)>0)
				$0:=Replace string:C233($0; "DD"; String:C10(Day of:C23($1); "00"))
			: (Position:C15("D"; $0)>0)
				$0:=Replace string:C233($0; "D"; String:C10(Day of:C23($1)))
		End case 
		
		
		Case of 
			: (Position:C15("MMM"; $0)>0)
				If ((Month of:C24($1)>0) & (Month of:C24($1)<13))
					$_prli_Load:=(Type:C295(<>PTDates_aMonthAbbr)=Is undefined:K8:13)
					If ($_prli_Load=False:C215)
						$_prli_Load:=(Size of array:C274(<>PTDates_aMonthAbbr)#12)
					End if 
					If ($_prli_Load)
						_O_ARRAY STRING:C218(3; <>PTDates_aMonthAbbr; 12)
						_prli_Util_TextToArray("Jan;Feb;Mar;Apr;May;Jun;Jul;Aug;Sep;Oct;Nov;Dec"; -><>PTDates_aMonthAbbr; ";")
					End if 
					$0:=Replace string:C233($0; "MMM"; <>PTDates_aMonthAbbr{Month of:C24($1)})
				End if 
				
			: (Position:C15("Month"; $0)>0)
				If ((Month of:C24($1)>0) & (Month of:C24($1)<13))
					$_prli_Load:=(Type:C295(<>PTDates_aMonthName)=Is undefined:K8:13)
					If ($_prli_Load=False:C215)
						$_prli_Load:=(Size of array:C274(<>PTDates_aMonthName)#12)
					End if 
					If ($_prli_Load)
						_O_ARRAY STRING:C218(9; <>PTDates_aMonthName; 12)
						_prli_Util_TextToArray("January;February;March;April;May;June;July;August;September"+";October;November;December"; -><>PTDates_aMonthName; ";")
					End if 
					$0:=Replace string:C233($0; "Month"; <>PTDates_aMonthName{Month of:C24($1)})
				End if 
				
			: (Position:C15("MM"; $0)>0)
				$0:=Replace string:C233($0; "MM"; String:C10(Month of:C24($1); "00"))
				
			: (Position:C15("M"; $0)>0)
				$0:=Replace string:C233($0; "M"; String:C10(Month of:C24($1)))
		End case 
		
		
		Case of 
			: ($_prli_pDay>0)
				$_prli_Load:=(Type:C295(<>PTDates_aDayName)=Is undefined:K8:13)
				If ($_prli_Load=False:C215)
					$_prli_Load:=(Size of array:C274(<>PTDates_aDayName)#7)
				End if 
				If ($_prli_Load)
					_O_ARRAY STRING:C218(9; <>PTDates_aDayName; 7)
					_prli_Util_TextToArray("Sunday;Monday;Tuesday;Wednesday;Thursday;Friday;Saturday"; -><>PTDates_aDayName; ";")
				End if 
				$0:=Replace string:C233($0; "x_1"; <>PTDates_aDayName{$_prli_iDayNumber})
				
			: ($_prli_pDDD>0)
				$_prli_Load:=(Type:C295(<>PTDates_aDayAbbreviation)=Is undefined:K8:13)
				If ($_prli_Load=False:C215)
					$_prli_Load:=(Size of array:C274(<>PTDates_aDayAbbreviation)#7)
				End if 
				If ($_prli_Load)
					_O_ARRAY STRING:C218(3; <>PTDates_aDayAbbreviation; 7)
					_prli_Util_TextToArray("Sun;Mon;Tue;Wed;Thu;Fri;Sat"; -><>PTDates_aDayAbbreviation; ";")
				End if 
				If ($_prli_Uppercase)
					$0:=Replace string:C233($0; "XXX"; _str_ ToUpper(<>PTDates_aDayAbbreviation{$_prli_iDayNumber}))
				Else 
					$0:=Replace string:C233($0; "XXX"; (<>PTDates_aDayAbbreviation{$_prli_iDayNumber}))
				End if 
				
				
		End case 
End case 
