//%attributes = {}
//_prli_Util_SortArrays (Opts;"Directions";->Array1-n   or   ->ArrayGroup)
//Tony Ringsmuth  02/03/2000
//Part of the BB_Base Component, by Business Brothers.

//--------------------------------------------------------------------------------
//FUNCTION:
//Sort multile arrays by one, or multiple of those arrays.

//--------------------------------------------------------------------------------
//PARAMETERS


//This procedure does one of several things, depending on Opts:
//$1: longint: bitwise options:
//   +1 = Don't actually sort the arrays: just pass back a "Sort Key array" by
//        which you can sort your own arrays with a multi-sort.
//   +2 = Sort the arrays, AND pass back the "Sort Key Array"
//   +4 = Allow nil's and non array variables as columns without error reporting

//$2: Directions:  can be in one of 2 forms:
//  Numeric specifications:  examples following: positive=ascending, neg=descend.
//    "1;3" = Sort arrays by 1st array, ascending, 3rd array, descending
//    "-2;1" = Sort arrays by 2nd array, descending, 1st array, ascending
//  Directional arrows and spaces:  examples following: 
//    (> is ascending, < is descending, - is a non-sort array)
//     ">><"  = Sort the arrays: ascending on first 2 arrays, descending on 3rd.
//    "->-<" = Sort the arrays, ascending on 2nd array, descending on 4th.

//$3-$N:
//$3 can be a pointer array, pointing to the group of arrays you want to sort
//  else, $3-N are pointers to sortable data types, the arrays you want to sort.

//Directions: > = Ascending, < = Descending, anything else is a non-sort array.

//--------------------------------------------------------------------------------
//EXAMPLES:
//SortArrays (0;"-1;3;4";->aBalance;->aCliID;->aLstName;->aFrstName;->Addrs;->Cty)
//  Sort the arrays, descending Balance, Ascending Last name & first name.

//SortArrays (0;"<=>>";->aBalance;->aCliID;->aLstName;->aFrstName;->Addrs;->Cty)
//  Sort the arrays, descending Balance, Ascending Last name & first name.

//PointerToArray(->aPtr;->aBalance;->aCliID;->aLstName;->aFrstName;->Addrs;->Cty)
//SortArrays (0;"-1;3;4";->aPtr)
//  Sort the arrays, descending Balance, Ascending Last name & first name.

//SortArrays (1;"<>>";->aBalance;->aLastName;->aFirstName)
//Sort Array(aSortArraysKey;aBalance;aLastName;aFirstName;$aLastPayDt)
//  Produce a "Sort Key Array" for the 3 arrays, so that you can perform
//    the sort in the calling method

//--------------------------------------------------------------------------------
//REVISION HISTORY

//Rev: 11/14/07: Local Arrays Work
//Rev: 11/01/07: V11 Compatability work
//Rev: 05/14/07: Allow nil and non array columns to be passed (it opts +4): 
//      These are ignored during the actual sorting.
//Rev: 05/04/05: Made upwardly compatible with 4D 2004 Local arrays.
//Rev: 12/13/02: Check for size of all arrays in group
//Rev: 08/03/01: Allow Array Group to be a 2D Pointer array
//Rev: 02/17/00: error check for passing same array multiple times

//--------------------------------------------------------------------------------


C_LONGINT:C283($1; $_prli_Opts)
C_TEXT:C284($2; $_prli_SortDirections)
C_POINTER:C301(${3})


C_LONGINT:C283($_prli_i; $_prli_j; $_prli_iSizeArray1; $_prli_LenSize; $_prli_ArrayNo; $_prli_Ctr; $_prli_CntArrays; $_prli_CntColumns; $_prli_tableNum; $_prli_fieldNum; $_prli_iType)
C_LONGINT:C283($_prli_iSize; $_prli_iAddElements)
C_TEXT:C284($_prli_varName; $_prli_BB_ArrayPtrName)
C_POINTER:C301(${3}; $_prli_pArray1)
C_POINTER:C301($0)

$_prli_Opts:=$1
$_prli_SortTheArrays:=Not:C34($_prli_Opts ?? 0)  //+1: If pass +1, then don't actually sort the arrays: Just produce a Sort Key.
$_prli_OutputSortKeyArray:=($_prli_Opts ?? 0) | ($_prli_Opts ?? 1)  //+1 or +2
$_prli_IgnoreNonArrayTypes:=($_prli_Opts ?? 2)  //+4


$_prli_SortDirections:=$2

ARRAY POINTER:C280(PTUtil_aArrayPtr; 0)
RESOLVE POINTER:C394(->PTUtil_aArrayPtr; $_prli_BB_ArrayPtrName; $_prli_tableNum; $_prli_fieldNum)
ARRAY POINTER:C280($_prli_aArrayGroup; 0)
If (Is nil pointer:C315($3))
	$_prli_iType:=-1
Else 
	$_prli_iType:=Type:C295($3->)
End if 

If ($_prli_iType=Array 2D:K8:24)
	C_BLOB:C604($_prli_Blob)
	RESOLVE POINTER:C394($3; $_prli_varName; $_prli_tableNum; $_prli_fieldNum)
	If ($_prli_tableNum=-1)  //$tableNum=-1 indicates the 1st dimension of a 2d array: not allowed here.
		//The type remains "Array 2D"
	Else 
		$_prli_Ptr2:=Get pointer:C304($_prli_varName)
		If (Size of array:C274($_prli_Ptr2->)<$_prli_tableNum)
			_prli_Util_ErrorAlert("Tried to reference array "+String:C10($_prli_tableNum)+" of "+$_prli_varName+" which had only "+String:C10(Size of array:C274($_prli_Ptr2->))+" arrays."+Char:C90(13)+"The Array was added."; "MyType")
			INSERT IN ARRAY:C227($_prli_Ptr2->; Size of array:C274($_prli_Ptr2->)+1; $_prli_tableNum-Size of array:C274($_prli_Ptr2->))  //Add the necessary arrays.
		End if 
		VARIABLE TO BLOB:C532($3->{0}; $_prli_Blob)
		If (BLOB size:C605($_prli_Blob)>4)
			$_prli_Offset:=4  //the 5th character (blobs start at zero) holds the data type.
			$_prli_iType:=Character code:C91(BLOB to text:C555($_prli_Blob; Mac text without length:K22:10; $_prli_Offset; 1))
		End if 
	End if 
End if 


$_prli_ArraySet:=($_prli_iType=Pointer array:K8:23)
If ($_prli_ArraySet)
	COPY ARRAY:C226($3->; $_prli_aArrayGroup)
	$_prli_CntColumns:=Size of array:C274($_prli_aArrayGroup)
Else 
	$_prli_CntColumns:=Count parameters:C259-2
	ARRAY POINTER:C280($_prli_aArrayGroup; $_prli_CntColumns)
	For ($_prli_i; 1; $_prli_CntColumns)
		$_prli_aArrayGroup{$_prli_i}:=${$_prli_i+2}
	End for 
End if 

//Get all the Array Names (shortens code later on.)
ARRAY TEXT:C222($_prli_aArrayName; $_prli_CntColumns)
$_prli_ArrayList:=""
$_prli_RepeatArrays:=""
C_POINTER:C301($_prli_pArray)
For ($_prli_i; 1; $_prli_CntColumns)
	$_prli_pArray:=$_prli_aArrayGroup{$_prli_i}
	If (Is nil pointer:C315($_prli_pArray))
		$_prli_varName:="Nil"
	Else 
		RESOLVE POINTER:C394($_prli_pArray; $_prli_varName; $_prli_tableNum; $_prli_fieldNum)
		If ($_prli_tableNum>-1)
			$_prli_varName:=$_prli_varName+"{"+String:C10($_prli_tableNum)+"}"
		End if 
		If (Find in array:C230($_prli_aArrayGroup; $_prli_pArray)<$_prli_i)  //Has this array been passed multiple times?
			$_prli_RepeatArrays:=$_prli_RepeatArrays+$_prli_varName+", "
		End if 
	End if 
	$_prli_aArrayName{$_prli_i}:=$_prli_varName
	$_prli_ArrayList:=$_prli_ArrayList+";"+$_prli_varName
End for 

If (Length:C16($_prli_RepeatArrays)>0)
	_prli_Util_ErrorAlert("The Array "+Substring:C12($_prli_RepeatArrays; 1; Length:C16($_prli_RepeatArrays)-1)+" was passed multiple times."+Char:C90(13)+$_prli_ArrayList; "BB_SortArrays")
End if 

$_prli_CntArrays:=0
ARRAY BOOLEAN:C223($_prli_aIsAnArray; $_prli_CntColumns)
ARRAY INTEGER:C220($_prli_aArrayNumber; 0)
$_prli_iSizeArray1:=-1
For ($_prli_i; 1; $_prli_CntColumns)
	If (Is nil pointer:C315($_prli_aArrayGroup{$_prli_i}))
		$_prli_iType:=-1  //nil
	Else 
		$_prli_iType:=Type:C295($_prli_aArrayGroup{$_prli_i}->)
		If ($_prli_iType=Array 2D:K8:24)
			If (Application version:C493<="1100")  //11/1/07
				SET BLOB SIZE:C606($_prli_Blob; 0)
				VARIABLE TO BLOB:C532($_prli_aArrayGroup{$_prli_i}->{0}; $_prli_Blob)
				If (BLOB size:C605($_prli_Blob)>4)
					$_prli_Offset:=4  //the 5th character (blobs start at zero) holds the data type.
					$_prli_iType:=Character code:C91(BLOB to text:C555($_prli_Blob; Mac text without length:K22:10; $_prli_Offset; 1))
				End if 
				SET BLOB SIZE:C606($_prli_Blob; 0)
			Else 
				$_prli_iType:=Text array:K8:16  //An arbitrary type: just to specify an Array type.
				//This is a band-aid solution.
			End if 
		End if 
	End if 
	$_prli_aIsAnArray{$_prli_i}:=(($_prli_iType=Text array:K8:16) | ($_prli_iType=String array:K8:15) | ($_prli_iType=Integer array:K8:18) | ($_prli_iType=LongInt array:K8:19) | ($_prli_iType=Real array:K8:17) | ($_prli_iType=Date array:K8:20) | ($_prli_iType=Boolean array:K8:21) | ($_prli_iType=Picture array:K8:22) | ($_prli_iType=Pointer array:K8:23))
	
	If ($_prli_aIsAnArray{$_prli_i})
		If ($_prli_iSizeArray1=-1)
			$_prli_iSizeArray1:=Size of array:C274($_prli_aArrayGroup{$_prli_i}->)
		End if 
		$_prli_CntArrays:=$_prli_CntArrays+1
		INSERT IN ARRAY:C227(PTUtil_aArrayPtr; $_prli_CntArrays; 1)
		PTUtil_aArrayPtr{$_prli_CntArrays}:=$_prli_aArrayGroup{$_prli_i}
		ARRAY INTEGER:C220($_prli_aArrayNumber; $_prli_CntArrays)
		$_prli_aArrayNumber{$_prli_CntArrays}:=$_prli_i
	Else 
		If ($_prli_IgnoreNonArrayTypes=False:C215)
			_prli_Util_ErrorAlert("Parameter number "+String:C10($_prli_i)+" was not an array."+Char:C90(13)+"Type = "+String:C10($_prli_iType)+Char:C90(13)+$_prli_ArrayList; Current method name:C684)
		End if 
	End if 
	
End for 

$_prli_LenSize:=Length:C16(String:C10($_prli_iSizeArray1))
$_prli_Format:=("0"*$_prli_LenSize)


//-----------------------
//Check if all sizes are the same
$_prli_SizeError:=""
For ($_prli_i; 2; $_prli_CntArrays)
	If ($_prli_SortTheArrays & $_prli_aIsAnArray{$_prli_i})
		$_prli_iSize:=Size of array:C274(PTUtil_aArrayPtr{$_prli_i}->)
		If ($_prli_iSize#$_prli_iSizeArray1)
			$_prli_SizeError:=$_prli_SizeError+$_prli_aArrayName{$_prli_i}+": "+String:C10($_prli_iSize)+Char:C90(13)
			
			//Correct the problem
			$_prli_iSize:=Size of array:C274(PTUtil_aArrayPtr{$_prli_i}->)
			$_prli_iAddElements:=$_prli_iSizeArray1-$_prli_iSize
			Case of 
				: ($_prli_iAddElements<0)
					DELETE FROM ARRAY:C228(PTUtil_aArrayPtr{$_prli_i}->; $_prli_iSize+1+$_prli_iAddElements; -$_prli_iAddElements)
				: ($_prli_iAddElements>0)
					INSERT IN ARRAY:C227(PTUtil_aArrayPtr{$_prli_i}->; $_prli_iSize+1; $_prli_iAddElements)
			End case 
			
		End if 
	End if 
End for 

If (Length:C16($_prli_SizeError)>0)
	$_prli_SizeError:="Array Size mismatch: The Primary Array, "+Char:C90(34)+$_prli_aArrayName{1}+Char:C90(34)+" had a size of "+String:C10($_prli_iSizeArray1)+" but the following arrays were mis-sized:"+Char:C90(13)+$_prli_SizeError
	_prli_Util_ErrorAlert($_prli_SizeError; Current method name:C684)
End if 

//----------------Give error alert if any array was passed multiple times


//------------Build an array from $SortDirections to see if it is in the format
//  of numbers delimited by semicolons: ex: "1;5;4;-2"
$_prli_NumericDirections:=False:C215
$_prli_e:=0
$_prli_Last:=1
$_prli_Error:=False:C215
For ($_prli_i; 1; Length:C16($_prli_SortDirections))
	If ($_prli_SortDirections[[$_prli_i]]=";")
		$_prli_e:=$_prli_e+1
		ARRAY INTEGER:C220($_prli_aSortArrayDir; $_prli_e)
		$_prli_aSortArrayDir{$_prli_e}:=Num:C11(Substring:C12($_prli_SortDirections; $_prli_Last; $_prli_i-$_prli_Last))
		$_prli_NumericDirections:=($_prli_NumericDirections | ($_prli_aSortArrayDir{$_prli_e}#0))
		$_prli_Last:=$_prli_i+1
	End if 
End for 
$_prli_e:=$_prli_e+1
ARRAY INTEGER:C220($_prli_aSortArrayDir; $_prli_e)
$_prli_aSortArrayDir{$_prli_e}:=Num:C11(Substring:C12($_prli_SortDirections; $_prli_Last; $_prli_i-$_prli_Last))
$_prli_NumericDirections:=($_prli_NumericDirections | ($_prli_aSortArrayDir{$_prli_e}#0))


If (Not:C34($_prli_NumericDirections))
	C_LONGINT:C283($_prli_iSortSize)
	$_prli_iSortSize:=0
	If (Length:C16($_prli_SortDirections)>$_prli_CntColumns)
		$_prli_SortDirections:=Substring:C12($_prli_SortDirections; 1; $_prli_CntColumns)  //Don't try sorting arrays that weren't passed.
	End if 
	For ($_prli_i; 1; Length:C16($_prli_SortDirections))
		Case of 
			: ($_prli_SortDirections[[$_prli_i]]=">")
				$_prli_iSortSize:=$_prli_iSortSize+1
				ARRAY INTEGER:C220($_prli_aSortArrayDir; $_prli_iSortSize)
				$_prli_aSortArrayDir{$_prli_iSortSize}:=$_prli_i
			: ($_prli_SortDirections[[$_prli_i]]="<")
				$_prli_iSortSize:=$_prli_iSortSize+1
				ARRAY INTEGER:C220($_prli_aSortArrayDir; $_prli_iSortSize)
				$_prli_aSortArrayDir{$_prli_iSortSize}:=-$_prli_i
			Else 
				//ignore it.        
		End case 
	End for 
End if 

ARRAY TEXT:C222(_prli_aSortArraysKey; 0)

Case of 
	: (($_prli_CntArrays=1) & ($_prli_OutputSortKeyArray=False:C215))  //Are we sorting by just one array, and don't need to make the "Key"?
		//Only one sort level
		$_prli_iFindSort1:=Find in array:C230($_prli_aArrayNumber; Abs:C99($_prli_aSortArrayDir{1}))
		If ($_prli_iFindSort1>-1)
			$_prli_it:=Command name:C538(229)+"("+$_prli_BB_ArrayPtrName+"{"+String:C10($_prli_iFindSort1)+"}->"
			For ($_prli_i; 1; Size of array:C274(PTUtil_aArrayPtr))
				If ($_prli_i#$_prli_iFindSort1)
					$_prli_it:=$_prli_it+";"+$_prli_BB_ArrayPtrName+"{"+String:C10($_prli_i)+"}->"
				End if 
			End for 
			If ($_prli_aSortArrayDir{1}>0)
				$_prli_it:=$_prli_it+")"
			Else 
				$_prli_it:=$_prli_it+";<)"
			End if 
			EXECUTE FORMULA:C63($_prli_it)
		Else 
			//BB_ErrorLog(Current method name;"Tried to sort by array "+String($aSortArrayDir{
		End if 
		
	Else 
		//Multiple sort levels
		
		ARRAY TEXT:C222(_prli_aSortArraysKey; $_prli_iSizeArray1)
		
		For ($_prli_i; 1; Size of array:C274($_prli_aSortArrayDir))
			$_prli_Ascending:=($_prli_aSortArrayDir{$_prli_i}>0)
			$_prli_iFindSortN:=Find in array:C230($_prli_aArrayNumber; Abs:C99($_prli_aSortArrayDir{$_prli_i}))
			If ($_prli_iFindSortN>-1)
				
				$_prli_pArray:=PTUtil_aArrayPtr{$_prli_iFindSortN}
				SET BLOB SIZE:C606($_prli_Blob; 0)
				VARIABLE TO BLOB:C532($_prli_pArray->; $_prli_Blob; *)
				
				ARRAY LONGINT:C221($_prli_aSortAssistLongGoto; $_prli_iSizeArray1)
				For ($_prli_j; 1; $_prli_iSizeArray1)
					$_prli_aSortAssistLongGoto{$_prli_j}:=$_prli_j
				End for 
				
				If ($_prli_Ascending)
					SORT ARRAY:C229($_prli_pArray->; $_prli_aSortAssistLongGoto)
				Else 
					SORT ARRAY:C229($_prli_pArray->; $_prli_aSortAssistLongGoto; <)
				End if 
				ARRAY LONGINT:C221($_prli_aSortAssistLongFrom; $_prli_iSizeArray1)
				$_prli_Ctr:=0
				For ($_prli_j; 1; $_prli_iSizeArray1)
					If ($_prli_pArray->{$_prli_j}#$_prli_pArray->{$_prli_j-1})
						$_prli_Ctr:=$_prli_Ctr+1
					End if 
					$_prli_aSortAssistLongFrom{$_prli_j}:=$_prli_Ctr
				End for 
				
				SORT ARRAY:C229($_prli_aSortAssistLongGoto; $_prli_aSortAssistLongFrom)
				$_prli_Offset:=0
				BLOB TO VARIABLE:C533($_prli_Blob; $_prli_pArray->; $_prli_Offset)
				
				For ($_prli_j; 1; $_prli_iSizeArray1)
					_prli_aSortArraysKey{$_prli_j}:=_prli_aSortArraysKey{$_prli_j}+String:C10($_prli_aSortAssistLongFrom{$_prli_j}; $_prli_Format)
				End for   //$j
				
			Else 
				//_prli_Util_ErrorLog(Current method name;"Could not sort by array number "+String($a
			End if 
			
		End for   //$i
		
End case 

$0:=->_prli_aSortArraysKey

Case of 
	: (($_prli_SortTheArrays=False:C215) & $_prli_OutputSortKeyArray)
		//Leave the Sort Key Array in tact.
		
	: ($_prli_SortTheArrays & (($_prli_CntArrays>1) | $_prli_OutputSortKeyArray))
		
		If ($_prli_OutputSortKeyArray)
			COPY ARRAY:C226(_prli_aSortArraysKey; $_prli_aSortKeyOutput)
		End if 
		
		RESOLVE POINTER:C394(->_prli_aSortArraysKey; $_prli_varName; $_prli_tableNum; $_prli_fieldNum)
		$_prli_it:=Command name:C538(229)+"("+$_prli_varName  //in case an over ambitious programer uses insider to change var names.
		For ($_prli_i; 1; $_prli_CntArrays)
			$_prli_it:=$_prli_it+";"+$_prli_BB_ArrayPtrName+"{"+String:C10($_prli_i)+"}->"
		End for 
		$_prli_it:=$_prli_it+")"
		EXECUTE FORMULA:C63($_prli_it)
		
		If ($_prli_OutputSortKeyArray)
			COPY ARRAY:C226($_prli_aSortKeyOutput; _prli_aSortArraysKey)
		Else 
			ARRAY TEXT:C222(_prli_aSortArraysKey; 0)
		End if 
		
End case 
ARRAY POINTER:C280(PTUtil_aArrayPtr; 0)
