//%attributes = {}
// Method: ldfl_CAP_UPDATE
// 2004.01.19-18:55:26 / Pasi Mankinen
// © Copyright 2004 Manage Applications
// Purpose: 
// update capacity arrays
// ------------------------------------------------------------
If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStart; Current method name:C684)
End if 

C_LONGINT:C283($1; $ld_lCalcCapacityFree; $2; $fl_lCapHeigth; $ld_lIndex; $ld_lFlIndex; $ld_lLastIndex)
C_REAL:C285($ld_rStartDateTime; $ld_rEndDateTime; $ld_rEndTime; $ld_rCapacityStartDateTime)
C_DATE:C307($ld_dStartDate; $ld_dEndDate)

// COMPILER_ld_cap_, COMPILER_ldfl_
COMPILER_fl_

ldcap_ CURRENT_LOAD_GROUP_SET(ld_tLoad_Group_id)

$ld_lCalcCapacityFree:=$1
$fl_lCapHeigth:=$2
If ($fl_lCapHeigth=0)
	$fl_lCapHeigth:=12
End if 

$ld_rStartDateTime:=ldfl_rStartDateTime+(ldfl_lShiftStartDifference/(60*60*24))
$ld_rEndDateTime:=ldfl_rEndDateTime+(ldfl_lShiftStartDifference/(60*60*24))

$ld_dStartDate:=_dt RealToDate($ld_rStartDateTime)
$ld_dEndDate:=_dt RealToDate($ld_rEndDateTime)
$ld_dEndDate:=$ld_dEndDate+(($ld_dEndDate-$ld_dStartDate))  //if lots of days can be big amount of days shown after last date
$ld_rCapacityStartDateTime:=_dt ToReal(ldcap_dCapacityStartDate; ldcap_hCapacityStartTime)

If ($ld_lCalcCapacityFree=kTrue)
	If (ldfl_lGraphDialog=kFalse)
		ldcap_FREE_CACLULATE(ld_tLoad_Group_id; 0; ldfl_lCalcLoadFromCriticalDate)
	Else 
		//ldcap_ARR_LOAD_SAVE (kLoad ;ld_tLoad_Group_id;kFalse )
		ldcap_ CALC_ARR_FREE_CACLULATE(ld_tLoad_Group_id; 0; ldfl_lCalcLoadFromCriticalDate)
	End if 
End if 

$ld_lFlIndex:=0
$ld_lLastIndex:=ldcap_ IndexLastLoaded(ld_tLoad_Group_id)
If ($ld_lLastIndex>0)
	
	$ld_lIndex:=ldcap_ IndexFirstLoaded(ld_tLoad_Group_id; $ld_dStartDate)
	
	If ($ld_lIndex>0)
		If ($ld_lIndex>1)
			$ld_lIndex:=$ld_lIndex-1  //show 1 index earlier capacity too - it may start much earlier
			//this if for drawing zero capasity between previous and first shown real capacity
		End if 
		
		$ld_lArrSize:=1000
		_arr apRESIZE(->ldfl_apFLCapArr; $ld_lArrSize)
		$ld_lQuitLoop:=kFalse
		Repeat 
			$ld_lFlIndex:=$ld_lFlIndex+1  //draw normal cap
			If ($ld_lFlIndex>$ld_lArrSize)
				$ld_lArrSize:=$ld_lArrSize+1000
				_arr apRESIZE(->ldfl_apFLCapArr; $ld_lArrSize)
			End if 
			ldfl_asFLCapID{$ld_lFlIndex}:=String:C10($ld_lFlIndex)+"."+String:C10($ld_lIndex)+"."+ld_tLoad_Group_id
			ldfl_atFLCapRecordID{$ld_lFlIndex}:=""
			ldfl_arFLCapStartDateTime{$ld_lFlIndex}:=ldcap_arStart{$ld_lIndex}  // +(fl_lShiftStartDifference/(60*60*24))
			ldfl_arFLCapEndDateTime{$ld_lFlIndex}:=ldcap_arEnd{$ld_lIndex}
			ldfl_arFLCapCapacity{$ld_lFlIndex}:=ldcap_arCapacity{$ld_lIndex}
			ldfl_atFLCapColor{$ld_lFlIndex}:=ldcap_atColor{$ld_lIndex}
			ldfl_atFLCapInfo{$ld_lFlIndex}:=ldcap_atInfo{$ld_lIndex}
			ldfl_alFLCapShift{$ld_lFlIndex}:=ldcap_alShift{$ld_lIndex}
			
			ldfl_atFLCapSubtypeStart{$ld_lFlIndex}:=""
			ldfl_atFLCapSubtypeEnd{$ld_lFlIndex}:=""
			ldfl_alFLCapTop{$ld_lFlIndex}:=0  //fl_area_lLineTop  // ldfl_lCurrentDrawTop
			ldfl_alFLCapHeight{$ld_lFlIndex}:=$fl_lCapHeigth
			ldfl_arFLCapPosX{$ld_lFlIndex}:=0
			ldfl_arFLCapPosX2{$ld_lFlIndex}:=0
			
			Case of   //watch carefully what index you use!
				: (t_ld_lrbShowPhaseLength=1)
					ldfl_arFLCapFreeCapacity{$ld_lFlIndex}:=_dt Difference(ldfl_arFLCapEndDateTime{$ld_lFlIndex}; ldfl_arFLCapStartDateTime{$ld_lFlIndex})
				: (t_ld_lrbShowCapacity=1)
					ldfl_arFLCapFreeCapacity{$ld_lFlIndex}:=ldfl_arFLCapCapacity{$ld_lFlIndex}
				: (t_ld_lrbShowCurrentFree=1)
					ldfl_arFLCapFreeCapacity{$ld_lFlIndex}:=ldcap_arCurrentFree{$ld_lIndex}
				: (t_ld_lrbShowCumulativeFree=1)
					ldfl_arFLCapFreeCapacity{$ld_lFlIndex}:=ldcap_arCumulativeFree{$ld_lIndex}
				: (t_ld_lrbShowLoad=1)
					If (ldfl_arFLCapStartDateTime{$ld_lFlIndex}>=$ld_rCapacityStartDateTime)  //show  later capacity too         
						ldfl_arFLCapFreeCapacity{$ld_lFlIndex}:=ldfl_arFLCapCapacity{$ld_lFlIndex}-ldcap_arCurrentFree{$ld_lIndex}
					Else 
						ldfl_arFLCapFreeCapacity{$ld_lFlIndex}:=-ldcap_arCurrentFree{$ld_lIndex}
					End if 
				Else 
					ldfl_arFLCapFreeCapacity{$ld_lFlIndex}:=-1  //should not come here
			End case 
			ldfl_arFLCapFreeCapacity{$ld_lFlIndex}:=Round:C94(ldfl_arFLCapFreeCapacity{$ld_lFlIndex}; 2)
			If (ldcap_arCapacity{$ld_lIndex}>0)
				If (ldcap_adStartDate{$ld_lIndex}>=ldcap_dCapacityStartDate)  //show  later capacity too      
					ldfl_alFLCapColor{$ld_lFlIndex}:=_long_ RGBToColor(240; 240; 240)  //clLtGray
				Else 
					ldfl_alFLCapColor{$ld_lFlIndex}:=_long_ RGBToColor(210; 210; 210)  //clLtGray - slightly darker if zero capacity
				End if 
			Else 
				ldfl_alFLCapColor{$ld_lFlIndex}:=<>ldcap_lCapacityNullColor  //clRed
			End if 
			//ldfl_alFLCapTop{$ld_lFlIndex}:=ldfl_lCurrentDrawTop
			//ldfl_alFLCapHeight{$ld_lFlIndex}:=12
			//ldfl_arFLCapPosX{$ld_lFlIndex}:=0
			
			$ld_rEndTime:=ldcap_arEnd{$ld_lIndex}+_dt TimeToReal(?00:00:01?)  // Modified by: MG_PM (2011-11-29T20:44:32)
			// add 1 second, will be continuous still
			
			$ld_lDrawZeroCap:=kTrue
			Case of 
				: ($ld_lIndex>=$ld_lLastIndex)
					$ld_lQuitLoop:=kTrue
					$ld_lDrawZeroCap:=kFalse
				: (ldcap_adStartDate{$ld_lIndex}>$ld_dEndDate)  //show  later capacity too
					$ld_lQuitLoop:=kTrue
					$ld_lDrawZeroCap:=kFalse
				: (ldcap_arStart{$ld_lIndex+1}<=$ld_rEndTime)  //collapsing or continuous capacity
					$ld_lDrawZeroCap:=kFalse
			End case 
			If ($ld_lDrawZeroCap=kTrue)
				$ld_lFlIndex:=$ld_lFlIndex+1  //draw zero cap
				//ldfl_asFLCapID{$ld_lFlIndex}:=String($ld_lFlIndex)+"."+String($ld_lIndex)+"."+ld_tLoad_Group_id
				ldfl_asFLCapID{$ld_lFlIndex}:=String:C10($ld_lFlIndex)+".0."+ld_tLoad_Group_id
				ldfl_arFLCapStartDateTime{$ld_lFlIndex}:=ldcap_arEnd{$ld_lIndex}  // +(fl_lShiftStartDifference/(60*60*24))
				ldfl_arFLCapEndDateTime{$ld_lFlIndex}:=ldcap_arStart{$ld_lIndex+1}
				ldfl_alFLCapColor{$ld_lFlIndex}:=<>ldcap_lCapacityNullColor  //clRed
				ldfl_arFLCapCapacity{$ld_lFlIndex}:=0
				ldfl_arFLCapFreeCapacity{$ld_lFlIndex}:=0
				//ldfl_alFLCapTop{$ld_lFlIndex}:=ldfl_lCurrentDrawTop
				//ldfl_alFLCapHeight{$ld_lFlIndex}:=12
				//ldfl_arFLCapPosX{$ld_lFlIndex}:=0
			End if 
			$ld_lIndex:=$ld_lIndex+1
			
		Until ($ld_lQuitLoop=kTrue)
	End if 
End if 

If ($ld_lFlIndex>0)
	$ld_lArrSize:=$ld_lFlIndex  // -1
	_arr apRESIZE(->ldfl_apFLCapArr; $ld_lArrSize)
Else 
	_arr apRESIZE(->ldfl_apFLCapArr; 0)
End if 

If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStop; Current method name:C684)
End if 