//%attributes = {}
// Method: st_VALUES_TO_pr_UPDATE(UpdateStockBalance:L;UpdateAverageBalance:L;
// UpdateAveragePrice:L;UpdatePurchaseAveragePrice:L)
// 2007.04.24-12:54:53 / Arto Kokkila
// © Copyright 2007 Manage Applications
// Purpose: 

//Stock event must be current record !!!

// ------------------------------------------------------------
C_LONGINT:C283($1; $st_lUpdateStockBalance; $2; $st_lUpdateAverageBalance; $3; $st_lUpdatePurchasePrice)
C_LONGINT:C283($4; $st_lUpdateForeignPurchasePrice; $5; $st_lUpdateAveragePrice; $6; $st_lUpdatePurchaseAveragePrice)
C_LONGINT:C283($st_lProductSave; $st_lStockEventSave)
//C_REAL($1;$st_rPreviousStockBalance)
//$st_rPreviousStockBalance:=$1
$st_lUpdateStockBalance:=$1
$st_lUpdateAverageBalance:=$2
$st_lUpdatePurchasePrice:=$3  //NOT YET!
$st_lUpdateForeignPurchasePrice:=$4  //NOT YET!
$st_lUpdateAveragePrice:=$5
$st_lUpdatePurchaseAveragePrice:=$6
$st_lProductSave:=kFalse
$st_lStockEventSave:=kFalse

C_TEXT:C284($st_tProduct)
C_REAL:C285($st_rProductAverageBalance; $st_rProductAveragePrice; $st_rProductPurchaseAveragePrice; $st_rProductPurchAvgPriceAmou)
C_DATE:C307($st_dProductLastStockEventDate; $st_dProductAvgBalanceStartDate; $st_dPurchAvgPriceStartDate)
C_TEXT:C284($st_tStockEventType; $st_tStockEvent; $st_tStoragePlace)
C_REAL:C285($st_rStockEventAmount; $st_rStockEventPurchasePrice)  //$st_rStockEventStockBalance
C_DATE:C307($st_dDate)
C_REAL:C285($st_rOldStockBalance; $st_rOldAverageBalance; $st_rOldAveragePrice; $st_rOldPurchaseAveragePrice; $st_rOldPurchAvgPriceAmount)
C_REAL:C285($st_rNewStockBalance; $st_rNewAverageBalance; $st_rNewAveragePrice; $st_rNewPurchaseAveragePrice; $st_rNewPurchAvgPriceAmount)
C_TEXT:C284($st_tInfo; $st_tInfoTxt)
C_LONGINT:C283($st_lIsWaistStock; $st_lUpdateDate; $st_lUpdateProduct)

COMPILER_pr
COMPILER_st
_tbl WRITE_STATE(st_kTbl; kTrue)
_tbl WRITE_STATE(pr_kTbl; kTrue)

_sel RELATE_ONE(pr_kProduct_ID; st_kProduct_id)
$st_tProduct:=_fld ValueStr(st_kProduct_id)
$st_tStockEvent:=_fld ValueStr(st_kStock_Event_ID)
$st_tStoragePlace:=_fld ValueStr(st_kStorage_Place)

_rec LOCKED_WAIT(pr_kTbl; kTrue)
If (OK#1)
	_err MESSAGE(_lang Current("Product was locked")+": "+$st_tProduct+ksCR+_lang Current("Stock event values were not saved to product"); Current method name:C684; kFalse)
Else 
	_rec LOCKED_WAIT(st_kTbl; kTrue)
	If (OK#1)
		_err MESSAGE(_lang Current("Stock Event was locked")+": "+$st_tStockEvent+ksCR+_lang Current("Values were not saved to stock event"); Current method name:C684; kFalse)
	Else 
		
		$st_lIsWaistStock:=st_WaistStockParselIs($st_tProduct; $st_tStoragePlace)
		
		//get product fld values (previous values are saved to product)
		$st_rProductStockBalance:=_fld ValueReal(pr_kStock_Balance__unit)  //AK: 2007-05-08: $st_rPreviousStockBalance  
		$st_rProductAverageBalance:=_fld ValueReal(pr_kAverage_Balance)
		$st_rProductAveragePrice:=_fld ValueReal(pr_kAverage_Price)
		$st_rProductPurchaseAveragePrice:=_fld ValueReal(pr_kPurchase_Average_Price)
		$st_rProductPurchAvgPriceAmou:=_fld ValueReal(pr_kPurch_Avg_Price_Amount)
		$st_dProductLastStockEventDate:=_fld ValueDate(pr_kLast_Stock_Event_Date)
		$st_dProductAvgBalanceStartDate:=_fld ValueDate(pr_kAverage_Balance_Start_Date)
		//get stock event fld values
		$st_tStockEventType:=_fld ValueStr(st_kType_)
		$st_rStockEventAmount:=_fld ValueReal(st_kAmount__unit)
		If (<>st_lCalcAvgPriceFromPucrhPrice=kTrue)
			$st_rStockEventPurchasePrice:=_fld ValueReal(st_kPurchase_Price__unit)
		Else 
			$st_rStockEventPurchasePrice:=_fld ValueReal(st_kCost_Price__unit)
		End if 
		$st_dDate:=_fld ValueDate(st_kDate_)
		
		//stock balance
		Case of 
			: ($st_lIsWaistStock=kTrue)
				_fld VALUE_REAL_SET(kSet; st_kStock_Balance; $st_rProductStockBalance)  //save previous balance to stock event         
			: ($st_lUpdateStockBalance=kFalse)  //save previous balance to stock event    
				//  _fld VALUE_REAL_SET (kSet ;st_kStock_Balance ;$st_rProductStockBalance+$st_r
				//~StockEventAmount)
			Else 
				_fld VALUE_REAL_SET(kSet; st_kStock_Balance; $st_rProductStockBalance+$st_rStockEventAmount)
				$st_lStockEventSave:=kTrue
				//        If ($st_rStockEventAmount>0)
				//          _fld VALUE_REAL_SET (kAdd ;pr_kStock_Increase_Total ;$st_rStockEvent
				//~Amount)
				//        Else 
				//          _fld VALUE_REAL_SET (kAdd ;pr_kStock_Decrease_Total ;$st_rStockEvent
				//~Amount)
				//        End if         
				_fld VALUE_REAL_SET(kAdd; pr_kStock_Balance__unit; $st_rStockEventAmount)
				If ($st_tStockEventType=<>st_tTypeInventory)
					_fld VALUE_DATE_SET(kSet; pr_kInventory_Date; $st_dDate)
				End if 
				If ($st_tStockEventType=<>st_tTypeRemoval)
					_fld VALUE_DATE_SET(kSet; pr_kLast_Stock_Removal_Date; $st_dDate)  // Modified by: PM 2013-06-19
				End if 
				pr_ALARM_LEVEL_MESSAGE
				$st_lProductSave:=kTrue
		End case 
		
		//$st_rProductStockBalance: pr_kStock_Balance__unit
		//$st_dProductLastStockEventDate: pr_kLast_Stock_Event_Date
		//average balance
		If (($st_lUpdateAverageBalance=kFalse) | ($st_lIsWaistStock=kTrue))
			_fld VALUE_REAL_SET(kSet; st_kAverage_Balance; $st_rProductAverageBalance)  //save previous avg balance to stock event
		Else 
			$st_rNewAverageBalance:=st_ AverageBalanceCalculate($st_rProductStockBalance; $st_rProductAverageBalance; $st_dProductLastStockEventDate; $st_dDate; $st_dProductAvgBalanceStartDate; $st_rStockEventAmount)
			_fld VALUE_REAL_SET(kSet; st_kAverage_Balance; $st_rNewAverageBalance)
			//_fld VALUE_DATE_SET (kSet ;st_kAverage_Bal_Change_Date;$st_dDate) 
			//does not exist, is always same as stock event date
			$st_lStockEventSave:=kTrue
			_fld VALUE_REAL_SET(kSet; pr_kAverage_Balance; $st_rNewAverageBalance)
			$st_lProductSave:=kTrue
		End if 
		
		//AK: 2007-05-04
		If ($st_dDate#$st_dProductLastStockEventDate)
			_fld VALUE_DATE_SET(kSet; pr_kLast_Stock_Event_Date; $st_dDate)
			$st_lProductSave:=kTrue
		End if 
		
		//average price
		$st_lUpdateProduct:=kTrue
		$st_lUpdateDate:=kTrue
		If (($st_lUpdatePurchaseAveragePrice=kFalse) | ($st_tStockEventType#<>st_tTypeAddition) | ($st_lIsWaistStock=kTrue))
			$st_lUpdateDate:=kFalse
			If (($st_rProductAveragePrice<=0) | ($st_rProductStockBalance<=0))  // first event (Avg=0)
				$st_rNewAveragePrice:=$st_rStockEventPurchasePrice  //copy purchase price to avg price
			Else 
				$st_rNewAveragePrice:=$st_rProductAveragePrice  //copy previous avg price to stock event
				$st_lUpdateProduct:=kFalse  //do not save to product  
			End if 
		Else 
			If (($st_rProductAveragePrice<=0) | ($st_rProductStockBalance<=0))  //usually first event 
				$st_rNewAveragePrice:=$st_rStockEventPurchasePrice
			Else 
				$st_rNewAveragePrice:=st_ AveragePriceCalculate($st_rProductStockBalance; $st_rProductAveragePrice; $st_rStockEventAmount; $st_rStockEventPurchasePrice)
			End if 
		End if 
		//save to stock event 
		$st_rOldAveragePrice:=_fld ValueReal(st_kAverage_Price)
		If ($st_rOldAveragePrice#$st_rNewAveragePrice)
			_fld VALUE_REAL_SET(kSet; st_kAverage_Price; $st_rNewAveragePrice)
			If ($st_lUpdateDate=kTrue)
				_fld VALUE_DATE_SET(kSet; st_kAverage_Price_Change_Date; $st_dDate)
				If ($st_rOldAveragePrice#0)  //do not save info to new stock event (save only when fixing values)
					$st_tInfoTxt:=_lang Current("Average price change was made")+": "
					$st_tInfoTxt:=$st_tInfoTxt+_lang Current("Stock event")+" "+$st_tStockEvent+", "
					$st_tInfo:=_fld ValueStr(st_kInfo)
					$st_tInfo:=_str_ WithDelimeterAdd($st_tInfo; $st_tInfoTxt+String:C10($st_rOldAveragePrice)+" -> "+String:C10($st_rNewAveragePrice)+" ("+_date CurrentDateTimeToString+"/"+Current user:C182+")"; ksCR+ksCR)
					_fld VALUE_STR_SET(kSet; st_kInfo; $st_tInfo)
				End if 
			End if 
			$st_lStockEventSave:=kTrue
		End if 
		//save to product  
		If ($st_lUpdateProduct=kTrue)
			$st_rOldAveragePrice:=_fld ValueReal(pr_kAverage_Price)
			If ($st_rOldAveragePrice#$st_rNewAveragePrice)
				_fld VALUE_REAL_SET(kSet; pr_kAverage_Price; $st_rNewAveragePrice)  //save to product
				If (<>st_lSaveStockEventInfoToProduct=kTrue)
					$st_tInfo:=_fld ValueStr(pr_kInfo)
					$st_tInfo:=_str_ WithDelimeterAdd($st_tInfo; $st_tInfoTxt+String:C10($st_rOldAveragePrice)+" -> "+String:C10($st_rNewAveragePrice)+" ("+_date CurrentDateTimeToString+"/"+Current user:C182+")"; ksCR+ksCR)
					_fld VALUE_STR_SET(kSet; pr_kInfo; $st_tInfo)
				End if 
				$st_lProductSave:=kTrue
			End if 
		End if 
		//average price - end   
		
		
		//purchase average price
		$st_lUpdateProduct:=kTrue
		$st_lUpdateDate:=kTrue
		If (($st_lUpdatePurchaseAveragePrice=kFalse) | ($st_tStockEventType#<>st_tTypeAddition) | ($st_lIsWaistStock=kTrue))
			$st_lUpdateDate:=kFalse
			If (($st_rProductPurchaseAveragePrice<=0) | ($st_rProductPurchAvgPriceAmou<=0))  // first event (Avg=0)
				$st_rNewPurchaseAveragePrice:=$st_rStockEventPurchasePrice  //copy purchase price to avg price
				$st_rNewPurchAvgPriceAmount:=$st_rStockEventAmount  //copy Stock Event Amount to Purch Avg Price Amount
			Else 
				$st_rNewPurchaseAveragePrice:=$st_rProductPurchaseAveragePrice  //copy previous Purchase Average Price to stock event
				$st_rNewPurchAvgPriceAmount:=$st_rProductPurchAvgPriceAmou  //copy previous Purch Avg Price Amount to stock event
				$st_lUpdateProduct:=kFalse  //do not save to product  
			End if 
			If ($st_tStockEventType#<>st_tTypeAddition)
				$st_rNewPurchAvgPriceAmount:=0
			End if 
		Else 
			If (($st_rProductPurchaseAveragePrice<=0) | ($st_rProductPurchAvgPriceAmou<=0))  //usually first event 
				$st_rNewPurchaseAveragePrice:=$st_rStockEventPurchasePrice
			Else 
				$st_rNewPurchaseAveragePrice:=st_ PurchaseAvgPriceCalculate($st_rProductPurchAvgPriceAmou; $st_rProductPurchaseAveragePrice; $st_rStockEventAmount; $st_rStockEventPurchasePrice)
			End if 
			$st_rNewPurchAvgPriceAmount:=$st_rProductPurchAvgPriceAmou+$st_rStockEventAmount
		End if 
	End if 
	//save to stock event 
	$st_lStockEventSave:=kTrue
	$st_rOldPurchaseAveragePrice:=_fld ValueReal(st_kPurchase_Average_Price)
	If ($st_rOldPurchaseAveragePrice#$st_rNewPurchaseAveragePrice)
		_fld VALUE_REAL_SET(kSet; st_kPurchase_Average_Price; $st_rNewPurchaseAveragePrice)
		If ($st_lUpdateDate=kTrue)
			_fld VALUE_DATE_SET(kSet; st_kPurch_Avg_Price_Change_Date; $st_dDate)
			If ($st_rOldPurchaseAveragePrice#0)  //do not save info to new stock event (save only when fixing values)
				$st_tInfoTxt:=_lang Current("Purchase average price change was made")+": "
				$st_tInfoTxt:=$st_tInfoTxt+_lang Current("Stock event")+" "+$st_tStockEvent+", "
				$st_tInfo:=_fld ValueStr(st_kInfo)
				$st_tInfo:=_str_ WithDelimeterAdd($st_tInfo; $st_tInfoTxt+String:C10($st_rOldPurchaseAveragePrice)+" -> "+String:C10($st_rNewPurchaseAveragePrice)+" ("+_date CurrentDateTimeToString+"/"+Current user:C182+")"; ksCR+ksCR)
				_fld VALUE_STR_SET(kSet; st_kInfo; $st_tInfo)
			End if 
		End if 
	End if 
	_fld VALUE_REAL_SET(kSet; st_kPurch_Avg_Price_Amount; $st_rNewPurchAvgPriceAmount)
	//save to product  
	If ($st_lUpdateProduct=kTrue)
		$st_dPurchAvgPriceStartDate:=_fld ValueDate(pr_kPurch_Avg_Price_Start_Date)  //AK: 2007-05-04
		If (($st_dPurchAvgPriceStartDate=!00-00-00!) | ($st_dPurchAvgPriceStartDate>$st_dDate))
			_fld VALUE_DATE_SET(kSet; pr_kPurch_Avg_Price_Start_Date; $st_dDate)
		End if 
		$st_rOldPurchaseAveragePrice:=_fld ValueReal(pr_kPurchase_Average_Price)
		If ($st_rOldPurchaseAveragePrice#$st_rNewPurchaseAveragePrice)
			_fld VALUE_REAL_SET(kSet; pr_kPurchase_Average_Price; $st_rNewPurchaseAveragePrice)
			If (<>st_lSaveStockEventInfoToProduct=kTrue)
				$st_tInfo:=_fld ValueStr(pr_kInfo)
				$st_tInfo:=$st_tInfoTxt+String:C10($st_rOldPurchaseAveragePrice)+" -> "+String:C10($st_rNewPurchaseAveragePrice)+" ("+_date CurrentDateTimeToString+"/"+Current user:C182+")"+ksCR+$st_tInfo
				_fld VALUE_STR_SET(kSet; pr_kInfo; $st_tInfo)
			End if 
		End if 
		_fld VALUE_REAL_SET(kSet; pr_kPurch_Avg_Price_Amount; $st_rNewPurchAvgPriceAmount)
		$st_lProductSave:=kTrue
	End if 
	//purchase average price - end
	
	
	//If (False)
	//purchase price
	If ($st_lUpdatePurchasePrice=kTrue)
		If ($st_tStockEventType=<>st_tTypeAddition)  //& price > 0???      
			_fld VALUE_DATE_SET(kSet; st_kPurchase_Price_Change_Date; $st_dDate)
			If (False:C215)  //see:
				po_SUORITA TAPAH
				po_PRODUCT_PRICE_UPDATE
			End if 
		End if 
	End if 
	//foreign purchase price
	If ($st_lUpdateForeignPurchasePrice=kTrue)
		If ($st_tStockEventType=<>st_tTypeAddition)  //& price > 0???
			_fld VALUE_DATE_SET(kSet; st_kForeign_Price_Change_Date; $st_dDate)
			IDLE:C311
			If (False:C215)
				po_SUORITA TAPAH
				po_PRODUCT_PRICE_UPDATE
			End if 
		End if 
	End if 
	//supplier prices
	If (($st_lUpdatePurchasePrice=kTrue) | ($st_lUpdateForeignPurchasePrice=kTrue))
		If ($st_tStockEventType=<>st_tTypeAddition)  //& price > 0???      
			_bool:=False:C215
			_fld VALUE(kGet; pr_kSupplier_Price_In_Use; ->_bool)
			If (_bool=True:C214)
				//update supplier prices here
				If (False:C215)
					//copy from here:
					po_PRODUCT_PRICE_UPDATE
				End if 
			End if 
		End if 
	End if 
	// End if   `  If (False)
	
End if 
If ($st_lProductSave=kTrue)
	pr_MODIFIED
	_rec SAVE(pr_kTbl)
End if 
If ($st_lStockEventSave=kTrue)
	_rec SAVE(st_kTbl)
End if 

_tbl WRITE_STATE(st_kTbl; kPrevious)
_tbl WRITE_STATE(pr_kTbl; kPrevious)
