//%attributes = {}
//******************************************************************************
//Method: SDA_ClipboardLoadContents
//Written by  Tod Gentille on 10/19/1998
//
//Purpose: If the stored clipboard document exists load its data into the 
//clipboard arrays. This method is the counterpart to SDA_ClipboardSaveContents
//These two methods coupled together allow the SDA clipboards to be persistent 
//across multiple 4D sessions
//Copyright 1998 Syncor Systems, Inc.
//Modified by: Cyril Harnisch, Syncor Systems, Inc., 2/19/99
//Reason: Added Windows text document type suffix
//******************************************************************************

ARRAY TEXT:C222(<>atSDA_Clipboard; 5)
ARRAY PICTURE:C279(<>axSDA_Clipboard; 5)
ARRAY TEXT:C222(<>atSDA_ClipboardType; 5)


C_TIME:C306($hSDA_DocRef)
C_TEXT:C284($tPathName)
C_BLOB:C604($oClipboardContents)
C_LONGINT:C283($lOffset)

$tPathName:=Get 4D folder:C485+"SDA_ClipboardContents"

If (<>SDA_IN_WINDOWS)  //if Windows
	$tPathName:=$tPathName+".TXT"  //Add text type code
End if 

If (Test path name:C476($tPathName)=Is a document:K24:1)
	$hSDA_DocRef:=Open document:C264($tPathName)
	If (OK=1)  //the doc was opened 
		CLOSE DOCUMENT:C267($hSDA_DocRef)  //blob to doc must have the document closed
		//and we use the document system var to write to it  
		DOCUMENT TO BLOB:C525(Document; $oClipboardContents)
		If (OK=1)
			$lOffset:=0
			BLOB TO VARIABLE:C533($oClipboardContents; <>atSDA_Clipboard; $lOffset)
			BLOB TO VARIABLE:C533($oClipboardContents; <>axSDA_Clipboard; $lOffset)
			BLOB TO VARIABLE:C533($oClipboardContents; <>atSDA_ClipboardType; $lOffset)
		End if 
	End if 
End if 
