//%attributes = {}
//******************************************************************************
//
//Method: SDA_ExportOne(bPromptForFilename;{FilePath})
//
//Written by  Tod Gentille on 10/15/97
//
//Purpose: Export the frontmost open window
//
//$1 boolean -if true then prompt user for file name and directory
//$2- optional text path to directory for many export
//
//Modified by Tod Gentille on 4/20/98- uses status from SDA_ClipboardOps
//Modified by: Cyril Harnisch, Syncor Systems, Inc., 2/9/99
//Reason: lengthened Windows file names; removed leading text in file name
// and added file type to discern method files.
//
//Copyright 1998,1999 Syncor Systems, Inc.
//
//******************************************************************************

C_BOOLEAN:C305($1; $bPromptForFilename)
C_TEXT:C284($2; $tPathForManyExport)

C_TIME:C306(<>hSDA_DocRef)
C_TEXT:C284($tFileName)
C_TEXT:C284($tSaveClip)
C_BOOLEAN:C305($bGo)

$bPromptForFilename:=$1

If (Count parameters:C259>1)
	$tPathForManyExport:=$2
End if   //If (Count parameters>1)

If (SDA_util_IsMethod(Frontmost window:C447))
	//Get all the contents of that window into our scrap text variable  
	$tSaveClip:=Get text from pasteboard:C524
	CLEAR PASTEBOARD:C402  //so that copies from empty windows really return nothing
	SDA_util_PostSelectAll
	<>tSDA_Scrap:=""
	$bGo:=SDA_ClipboardOps(<>SDA_COPY; -><>tSDA_Scrap)
	SET TEXT TO PASTEBOARD:C523($tSaveClip)
	
	If ($bGo)
		//make sure name isn't too long and replace colons
		$tFileName:=SDA_util_FrontmostMethodName
		
		If (<>SDA_IN_WINDOWS)  //if on Windows
			$tFileName:=Substring:C12($tFileName; 1; 255)  //Win95 & WinNT limit file names to 256 characters
			
		Else   //on the mac      
			$tFileName:=Substring:C12($tFileName; 1; 31)  //MacOS 8.5 still limits file names to 32 characters
		End if   //    If (<>SDA_IN_WINDOWS)  `if on Windows
		
		$tFileName:=SDA_util_AdjustFileName($tFileName)
		
		If ($bPromptForFilename)  //The Export many calls this procedure with $1 false so we don't ask for filename
			
			If (<>bSDA_FilepackIsHere)
				//comment this out if you don't use filepack and want to compile
				//or create a blank method named PutFileName
				$tFileName:=_doc SavePathGet("Save Export As..."; $tFileName)
				
			Else   //test in SDA_Export prevents this else from ever being executed
				//if you don't want to use filepack
				//you could hard code a line, like the example below, it must match
				//where the files are looked for in SDA_ImportMany      
				//$tFileName:=ACI folder+<>DIR_SEP+"Export"+<>DIR_SEP+$tFileName
				//Also change the test in SDA_export that prevents this method from being called
			End if   //      If (<>bSDA_FilepackIsHere)
			
		Else   //we are doing many windows at once, use the pathname passed in $2
			$tFileName:=$tPathForManyExport+$tFileName  // add the path to the filename
		End if   //    If ($bPromptForFilename)  `The Export many calls this procedure with $1 fals
		
		If ($tFileName#"")  //if user canceled out of PutFIleName it will be blank     
			//Create a text doc and send our Scrap variable to it    
			<>hSDA_DocRef:=Create document:C266($tFileName; "SDAM")  //create an SDA document, overwrite if it exists
			
			If (OK=1)  //the doc was created and opened 
				_O_SET DOCUMENT CREATOR:C531($tFileName; "ttxt")  //make it a simple text file for Macs, this does nothing on Windows
				SEND PACKET:C103(<>hSDA_DocRef; <>tSDA_Scrap)
				CLOSE DOCUMENT:C267(<>hSDA_DocRef)
				SDA_util_PostKey(Up arrow key:K12:18; 0)  //force the selection to be blank
				
			Else 
				BEEP:C151
			End if   //      If (OK=1)  `the doc was created and opened 
			
		Else 
			SDA_util_PostKey(Up arrow key:K12:18; 0)  //force the selection to be blank    
		End if   //    If ($tFileName # "")  `if user canceled out of PutFIleName it will be blank 
		
	Else   //the copy command did not work
		SDA_util_BugAlert(<>SDA_GENERAL_ERROR; "Method: SDA_ExportOne")
	End if   //  If ($bGo)
	
Else   //the window didn't qualify for exporting
	//  BEEP
End if   //If (SDA_util_IsMethod (Frontmost window))
