//%attributes = {}
//******************************************************************************
//Method: SDA_ImportMany
//Written by  Tod Gentille on 10/15/97
//
//Purpose: Import all the files from the selected folder to open windows
//that have matching names, any that don't match are ignored
//
//Copyright 1997 Syncor Systems, Inc.
//Modified by: Cyril Harnisch, Syncor Systems, 2/2/99Method113
//Reason: cleaned up code; removed conditional testing $lError
//******************************************************************************
C_TEXT:C284($tPathName)
C_LONGINT:C283($lMethodNameIdx; $lWindowTitleIdx; $lFound; $lNewWindowRef)
C_LONGINT:C283($lCurWinRef)
C_TIME:C306(<>hSDA_DocRef)
C_TEXT:C284($tDocName; $tWindowTitle)
C_BOOLEAN:C305($bGo; $bImportErrors)

ARRAY TEXT:C222(<>SDA_atDocuments_L; 0)
ARRAY TEXT:C222(<>SDAatWinTitle_L; 0)  //local in scope but we must pass a pointer to it
ARRAY LONGINT:C221(<>SDA_alWinRef_L; 0)
ARRAY TEXT:C222($atFailedImportFIles; 0)

//Populate the array of window names
SDA_util_GetOpenWindowNmRef(-><>SDA_atWinTitle_L; -><>SDA_alWinRef_L)
//valid files had to have colon removed, make win title match file name
For ($lWindowTitleIdx; 1; Size of array:C274(<>SDA_atWinTitle_L))  //For each window title
	<>SDA_atWinTitle_L{$lWindowTitleIdx}:=SDA_util_AdjustFileName(<>SDA_atWinTitle_L{$lWindowTitleIdx})
End for 

//Find out which folder will hold all the methods
If (<>bSDA_FilepackIsHere)  //if File Pack exists
	$tPathName:=_doc FolderChoose(<>SDA_SEL_IMPORT_FOLDER)
	
Else   //FilePack does not exist
	BEEP:C151
	_info_ ALERT("FilePack is required to import methods. Aborting...")
	$tPathName:=""  //Make sure we cannot proceed
	//You may want to hard code a  path here and match it in  DA_ExportOne  
	//to enable this feature without FilePack. Then just take out the
	//test in DA_Import that requires FilePack
End if 

If (Length:C16($tPathname)>0)  // length is 0 if user hit Cancel in GetFolderName dialog 
	//Get a list of documents and strip of the .SDA ending (which happens with Windows
	SDA_util_GetMethDocs($tPathName; -><>SDA_atDocuments_L)
	$bImportErrors:=False:C215
	
	For ($lMethodNameIdx; 1; Size of array:C274(<>SDA_atDocuments_L))  //for each method to import
		$tDocName:=<>SDA_atDocuments_L{$lMethodNameIdx}
		$lFound:=Find in array:C230(<>SDA_atWinTitle_L; $tDocName)
		
		If ($lFound#-1)  //if a method window is open for the current method to import
			//#### Bring that window to the front    
			$lCurWInRef:=<>SDA_alWinRef_L{$lFound}
			SDA_util_BringWinToFront($lCurWinRef)
			SDA_util_PostSelectAll  //select all the contents of the window for replacement
			$bGo:=True:C214
			
		Else   //no open window for the current method to import
			//#### look for it in the explorer
			SDA_util_PostKey(<>SDA_EDIT_METHOD; Command key mask:K16:1)
			SDA_util_PostString($tDocName)
			SDA_util_PostKey(Enter:K15:35; 0)  //select the method, if it exists
			SDA_util_Wait(2)  //Wait for window to come to front
			$lNewWindowRef:=Frontmost window:C447
			$tWindowTitle:=SDA_util_AdjustFileName(Get window title:C450($lNewWindowRef))  //get the window title of the front-most window
			
			If ($tWindowTitle=$tDocName)  //if our method was successfully opened
				$bGo:=SDA_util_PostSelectAll  //select all the contents to be replaced
				$bGo:=True:C214
				
			Else   //window not open and method doesn't exist,
				//#### Create a new method          
				SDA_util_PostKey(<>SDA_NEW_METHOD; Command key mask:K16:1)
				<>tSDA_Scrap:=$tDocName
				SDA_ClipboardOps(<>SDA_PASTE; -><>tSDA_Scrap)
				SDA_util_PostKey(Enter:K15:35; 0)
				$bGo:=True:C214
			End if   //($tWindowTitle=$tDocName)  `if our method was successfully opened
			
		End if   //($lFound # -1)  `if a method window is open for the current method to import
		//-------------------------------------------------------------------------------
		
		If ($bGo)  //if everything OK with the import file
			//NOTE: need the unadulterated document name      
			<>hSDA_DocRef:=Open document:C264($tPathname+<>SDA_atDocuments_L{$lMethodNameIdx}; "SDAM")
			
			If (OK=1)  //If the document was opened
				SDA_ImportOne(<>hSDA_DocRef)
				
			Else   //The document was not opened
				CLOSE DOCUMENT:C267(<>hSDA_DocRef)  //just in case it opened
				BEEP:C151
			End if 
			
		Else   //import file not located
			$bImportErrors:=True:C214  //a persistent check so an error msg can be displayed at end    
			INSERT IN ARRAY:C227($atFailedImportFIles; 1)  //move existing errors down one
			$atFailedImportFIles{1}:=<>SDA_atDocuments_L{$lMethodNameIdx}  //insert the new error msg
		End if 
		
	End for   //($lMethodNameIdx;1;Size of array(<>SDA_atDocuments_L))  `for each method to impo
	
	If ($bImportErrors)  //if errors detected
		//NOTE TO PROGRAMMER: insert a trace here and use the debugger to see failures
		//by looking at the $atFailedImportFiles array    
		_info_ ALERT("Some of the designated files were not imported.")
		TRACE:C157
	End if 
	
End if   //(Length($tPathname)>0)  ` length is 0 if user hit Cancel in GetFolderName dialog

//#### Free memory
ARRAY TEXT:C222(<>SDA_atDocuments_L; 0)
ARRAY TEXT:C222(<>SDA_atWinTitle_L; 0)
ARRAY LONGINT:C221(<>SDA_alWinRef_L; 0)
