//%attributes = {}
//******************************************************************************
//Method: SDA_LineNumber
//Written by  Tod Gentille on 9/30/1998
//
//Purpose:  Count the line number of the current cursor position.
//Will paste in a special char sequence at the current location of the cursor
//and then copy the entire method. Then it will issue an undo command. 
//Then it will look for that sequence and count how may
//lines there were till that sequence was found
//
//Copyright 1998 Syncor Systems, Inc.
//******************************************************************************
C_LONGINT:C283($lLineNumberTokenLen; $lCursorPosition)
C_LONGINT:C283($lLineNumber)
_O_C_STRING:C293(1; $s1CarriageReturn)
C_TEXT:C284($tMethod; $tMethodWithoutCR; <>tSDA_Scrap)

$s1CarriageReturn:=Char:C90(13)  //the char value of a carriage return
$lLineNumberTokenLen:=Length:C16(<>SDA_LINE_NUMBER_TOKEN)

<>tSDA_Scrap:=<>SDA_LINE_NUMBER_TOKEN  //+<>tSDA_Scrap  `append any selected text
SDA_ClipboardOps(<>SDA_PASTE; -><>tSDA_Scrap)  //Paste unusual characters at cursor position
SDA_util_PostSelectAll
SDA_ClipboardOps(<>SDA_COPY; -><>tSDA_Scrap)  //Get the entire method contents
$tMethod:=<>tSDA_Scrap  //copy method text to local variable
SDA_util_PostKey(<>SDA_ASCII_UNDO_KEY; Command key mask:K16:1; True:C214)  //restore the method to original state

//*** Now find out which line our special characters are on
$lCursorPosition:=Position:C15(<>SDA_LINE_NUMBER_TOKEN; $tMethod)

If ($lCursorPosition>0)
	$tMethod:=Substring:C12($tMethod; 1; $lCursorPosition)  //get method up to cursor position
	//Per a suggestion from Dennis Little find the length without carriage returns
	//and subtract that from our current position to find the line number
	$tMethodWithoutCR:=Replace string:C233($tMethod; Char:C90(Carriage return:K15:38); "")
	$lLineNumber:=$lCursorPosition-Length:C16($tMethodWithoutCR)+1
	_info_ ALERT("Line Number "+String:C10($lLineNumber)+".")
	
Else   //special characters not found
	SDA_util_BugAlert(<>SDA_GENERAL_ERROR; " Method: SDA_LineNumber ")
End if 
//-------------------------------------------------------------------------------
