//%attributes = {}
//******************************************************************************
//
//Method: Method: SDA_MethodHeader
//
//Written by  Tod Gentille on 10/11/97
//
//Purpose: Create a method header that is pasted back into the 
//frontmost window in the design environment. Called from a button
//on a floating palette
//
//NOTE: The cursor should be at the top line of the procedure where
//the header is to be placed. If the design process is not the
//frontmost process, nothing will hapen. 
//ALSO note you will want to change the line that creates the copyright line
//to reflect your company's name
//
//Copyright 1997 Syncor Systems, Inc.
//
//******************************************************************************
//

C_TEXT:C284($tWinTitle; $tWho; $tSepChar; $tSepLine; $tBlank; $CR)
C_TEXT:C284($tMethodLine; $tWrittenBy; $tPurpose; $tParams; $tCopyright)
C_TEXT:C284($0)

C_DATE:C307($dTheDate)

//---------- Define some constants used by this method ----------
$CR:=Char:C90(Carriage return:K15:38)
$tBlank:=<>SDA_COMMENT_CHAR+" "+$CR
$tSepChar:="-"
$tSepLine:=<>SDA_COMMENT_CHAR+" "+(60*$tSepChar)+$CR

$tWinTitle:=SDA_util_FrontmostMethodName
$tMethodLine:="` "+$tWinTitle+$CR

$dTheDate:=Current date:C33
If ($dTheDate<!1999-01-01!)
	$dTheDate:=_date Add($dTheDate; 1; 0; 0)
End if 
$tWho:=Current user:C182  // Current machine owner
//if your machine name isn't what you want, trap it in the case and replace
//it as follows
Case of 
	: ($tWho="pm")
		$tWho:="Pasi Mankinen"
		
	: ($tWho="ak")
		$tWho:="Arto Kokkila"
		
	: ($tWho="ek")
		$tWho:="Erkka Keinänen"
		
	: ($tWho="mv")
		$tWho:="Mika Vuorinen"
		
	Else   //don't change it
End case 

$tWrittenBy:="` "+_date Format($dTheDate; "YYYY.MM.DD")+"-"+String:C10(Current time:C178; HH MM SS:K7:1)+" / "+$tWho+$CR

$tPurpose:="` Purpose: "+$CR
$tParams:=""  // "` C_LONGINT($1) ` purpose"+$CR

//!!!!!!!!!!-----Change the next line to add your company's name -----!!!!!!!!!!
$tCopyright:="` © Copyright "+String:C10(Year of:C25($dTheDate); "0000")+" Manage Applications"+$CR


// <>tSDA_MethodHeader:=$tSepLine+$tBlank+$tMethodLine+$tBlank+$tWrittenBy+$tBlank
$0:=$tMethodLine+$tWrittenBy  // +$tBlank
$0:=$0+$tCopyright+$tPurpose+$tBlank+$tSepLine
$0:=$0+$tParams
//End if