//%attributes = {}
//******************************************************************************
//Method: SDA_MethodOps(pPopup)
//Written by  Tod Gentille on 9/29/1998
//
//Purpose: A general purpose routine to handle the Methods popup
//
//$1 -ptr to the pop up called via SELF from the popup
//
//Copyright 1998 Syncor Systems, Inc.
//
//Modified by: Cyril Harnisch, Syncor Systems, Inc., 3/3/99
//Reason: cleaned up code; moved $tChoice instantiation inside of conditional
//******************************************************************************
C_POINTER:C301($1)
C_LONGINT:C283($iSelItem)
C_TEXT:C284($tChoice)
C_TEXT:C284(<>tSDA_MethodAnalysis)  //local in scope but used on dialog form and passed via pointer
//
//All variables that end with _L could be locals except we need to pass pointers
//to them
C_LONGINT:C283(<>lSDA_ma_ControlCounter_L; <>lSDA_ma_MaxDepth_L)

$iSelItem:=$1->  //Find out which item was selected in the popup

If ($iSelItem>0)  //If an item was selected from the drop down
	$tChoice:=$1->{$iSelItem}  //Get the selected item
	
	Case of   //case of drop down choice
			
		: ($tChoice="Analyze Method")
			<>tSDA_MethodAnalysis:=""
			SDA_util_PostSelectAll
			If (SDA_ma_MethodAnalysis(-><>lSDA_ma_ControlCounter_L; -><>lSDA_ma_MaxDepth_L))
				SDA_ma_BuildAnalysisMsg(<>lSDA_ma_ControlCounter_L; <>lSDA_ma_MaxDepth_L; -><>tSDA_MethodAnalysis)
				SDA_ma_ShowAnalysis
			End if 
			
		: ($tChoice="Analyze All Open Methods")
			<>tSDA_MethodAnalysis:=""
			SDA_ma_MethodAnalysisAllOpen(-><>lSDA_ma_ControlCounter_L; -><>lSDA_ma_MaxDepth_L; -><>tSDA_MethodAnalysis)
			SDA_ma_ShowAnalysis
			
		: ($tChoice="Expand Macros")
			SDA_MacroExpand
			
		: ($tChoice="Create Module Methods")
			SDA_CreateModule
			
		: ($tChoice="Open Similar Methods")
			SDA_SimilarOpen
			
		: ($tChoice="Close Similar Methods")
			SDA_SimilarClose
			
		: ($tChoice="Extract Method Comments")
			SDA_ExtractComments
			
		: (SDA_MethodOps_y($tChoice))  //Your added operations should be put in this method
			
		Else   //no recognized drop down choice
			SDA_util_BugAlert(<>SDA_UNEXPECTED_PARAM; " Method: SDA_MethodOps "; $tChoice)
	End case   //  Case of   `case of drop down choice
	
End if   //If ($iSelItem>0)  `If an item was selected from the drop down
