//%attributes = {}
//******************************************************************************
//Method: SDA_PasteOps(ptrToPasteOpsPopup)
//
//Written by  Tod Gentille on 10/16/97
//
//Purpose: Perform the paste operation chosen from the paste popup
//The list was defined with the variable on the layout
//use the Edit strings button on the DataControl tab to add other items
//then add a case here to process that item
//
//$1 -ptr to the pop up called via SELF from the popup
//
//Copyright 1997 Syncor Systems, Inc.
//******************************************************************************
C_POINTER:C301($1; $pPopupMenu)
C_LONGINT:C283($iSelItem)
C_TEXT:C284($tChoice)
C_BOOLEAN:C305($bGo)
//All variables that end with _L could be locals except we need to pass pointers
//to them
C_LONGINT:C283(<>lSDA_ma_ControlCounter_L; <>lSDA_ma_MaxDepth_L)
ARRAY TEXT:C222(<>atSDA_DestLine_L; 0)
_O_C_STRING:C293(1; $CR)
$CR:=Char:C90(Carriage return:K15:38)

$pPopupMenu:=$1

$bGo:=True:C214  //will set false on error
$iSelItem:=$pPopupMenu->  //Find out which item was selected in the popup
$tChoice:=$pPopupMenu->{$iSelItem}  //Get the selected item

If ($iSelItem>0)
	
	Case of 
			
		: ($tChoice="If-Else-EndIf")
			<>tSDA_Scrap:=<>SDA_IF_CMD
			
		: ($tChoice="For-EndFor")
			<>tSDA_Scrap:=<>SDA_FOR_CMD
			
		: ($tChoice="Case-Else-EndCase")
			<>tSDA_Scrap:=<>SDA_CASE_CMD
			
		: ($tChoice="While-EndWhile")
			<>tSDA_Scrap:=<>SDA_WHILE_CMD
			
		: ($tChoice="Repeat-Until")
			<>tSDA_Scrap:=<>SDA_REPEAT_CMD
			
		: ($tChoice="User")
			<>tSDA_Scrap:=Current user:C182
			
		: ($tChoice="Date")
			<>tSDA_Scrap:=String:C10(Current date:C33)
			
		: ($tChoice="Time")
			<>tSDA_Scrap:=String:C10(Current time:C178)
			
		: ($tChoice="Machine")
			<>tSDA_Scrap:=Current machine:C483
			
		: ($tChoice="Machine Owner")
			<>tSDA_Scrap:=Current system user:C484
			
		: (SDA_PasteOps_y($tChoice))  //Your added operations should be put in this method
			
		Else 
			$bGo:=False:C215
			SDA_util_BugAlert(<>SDA_UNEXPECTED_PARAM; "Method: SDA_PasteOps"; $tChoice)
	End case 
	
	If ($bGo)
		
		If (<>tSDA_Scrap="")
			//not a problem
			
		Else 
			SDA_ClipboardOps(<>SDA_PASTE; -><>tSDA_Scrap)
			//paste in the text and try to position the cursor to a logical position     
			
			Case of   //position the cursor to the most likely place to type next
					
				: ($tChoice="If-Else-EndIf")
					SDA_util_PostKey(Left arrow key:K12:16; 0; False:C215)
					SDA_util_PostKey(Up arrow key:K12:18; 0; False:C215)
					SDA_util_PostKey(Up arrow key:K12:18; 0; False:C215)
					SDA_util_PostKey(Left arrow key:K12:16; 0; False:C215)
					
				: ($tChoice="For-EndFor")
					SDA_util_PostKey(Left arrow key:K12:16; 0; False:C215)
					SDA_util_PostKey(Up arrow key:K12:18; 0; False:C215)
					SDA_util_PostKey(Left arrow key:K12:16; 0; False:C215)
					SDA_util_PostKey(Left arrow key:K12:16; 0; False:C215)
					SDA_util_PostKey(Left arrow key:K12:16; 0; False:C215)
					
				: ($tChoice="Case-Else-EndCase")
					SDA_util_PostKey(Left arrow key:K12:16; 0; False:C215)
					SDA_util_PostKey(Up arrow key:K12:18; 0; False:C215)
					SDA_util_PostKey(Up arrow key:K12:18; 0; False:C215)
					SDA_util_PostKey(Left arrow key:K12:16; 0; False:C215)
					
				: ($tChoice="While-EndWhile")
					SDA_util_PostKey(Left arrow key:K12:16; 0; False:C215)
					SDA_util_PostKey(Up arrow key:K12:18; 0; False:C215)
					SDA_util_PostKey(Left arrow key:K12:16; 0; False:C215)
					
				: ($tChoice="Repeat-Until")
					SDA_util_PostKey(Left arrow key:K12:16; 0; False:C215)
					SDA_util_PostKey(Left arrow key:K12:16; 0; False:C215)
					
				Else   //we don't need to do any special processing
					
			End case   //    Case of   `position the cursor to the most likely place to type next
			
			<>tSDA_Scrap:=""
		End if 
		
	End if 
	
End if 
