//%attributes = {}
//******************************************************************************
//Method: SDA_ReplaceOpenWIndows
//Written by  Tod Gentille on 9/28/1998
//
//Purpose: Perform a find and replace loop on all open windows
//
//$1 - Find string (tramp data for SDA_Replace)
//$2 - Replace string (tramp data for SDA_Replace)
//
//Copyright 1998 Syncor Systems, Inc.
//
//******************************************************************************

C_TEXT:C284($1; $tFind; $2; $tReplace)
C_LONGINT:C283($i; $lSize; $lCurWinRef)

$tFind:=$1
$tReplace:=$2

//Get all the open window references, create an array of window names
ARRAY LONGINT:C221($alWindowRefs; 0)
WINDOW LIST:C442($alWIndowRefs)

$lSize:=Size of array:C274($alWIndowRefs)

For ($i; 1; $lSize)
	$lCurWInRef:=$alWIndowRefs{$i}
	If (SDA_util_IsMethod($lCurWinRef))  //make sure it is a method window    
		SDA_util_BringWinToFront($lCurWinRef)
		SDA_util_PostSelectAll  //select all the contents of the window for replacement  
		SDA_Replace($tFind; $tReplace)
	Else   //not a method window just skip it
	End if 
	
End for 
BEEP:C151  //let the user know they should get back to work
