//%attributes = {}
//******************************************************************************
//Method: SDA_WindowGroupLoad
//Written by  Tod Gentille on 9/28/1998
//
//Purpose: Load from a document a previously saved group of window names
//and then open those windows in the design env.
//
//Copyright 1998 Syncor Systems, Inc.
//******************************************************************************
C_BOOLEAN:C305($1; $bUseDefaultFile)
C_TIME:C306($hSDA_DocRef)
C_BLOB:C604($xWindowNames)
ARRAY TEXT:C222($atWindowNames; 0)
C_LONGINT:C283($i)
C_TEXT:C284($tMethodName)
ARRAY TEXT:C222(<>atWinTitle_L; 0)  //local in scope but we must pass a pointer to it

$bUseDefaultFile:=$1

//Populate the array of window names
SDA_util_GetOpenWindowNames(-><>atWinTitle_L)

If ($bUseDefaultFile)
	$hSDA_DocRef:=Open document:C264(Get 4D folder:C485+"SDA_WindowGroup")
Else 
	$hSDA_DocRef:=Open document:C264("")  //let user specify a  document  
End if 

If (OK=1)  //the doc was created and opened 
	CLOSE DOCUMENT:C267($hSDA_DocRef)  //blob to doc must have the document closed
	//and we use the document system var to write to it  
	DOCUMENT TO BLOB:C525(Document; $xWindowNames)
	If (OK=1)
		BLOB TO VARIABLE:C533($xWindowNames; $atWindowNames)
		
		For ($i; 1; Size of array:C274($atWindowNames))
			
			If (Find in array:C230(<>atWinTitle_L; $atWindowNames{$i})=-1)  //then it isn't already open
				$tMethodName:=SDA_util_StripMethodPrefix($atWindowNames{$i})
				SDA_util_OpenExistingMethod($tMethodName)
			End if   //      If (Find in array(<>atWinTitle_L;$atWindowNames{$i})=-1)  `then it isn't al
			
		End for   //    For ($i;1;Size of array($atWindowNames))
		
	Else 
		SDA_util_BugAlert(<>SDA_GENERAL_ERROR; "Method: SDA_WindowGroupLoad")
	End if   //  If (OK=1)
	
	
End if   //If (OK=1)  `the doc was created and opened 
BEEP:C151
