//%attributes = {}
//******************************************************************************
//Method: SDA_ma_IsControl(text;->CharArray;->CommandArray)
//Written by  Tod Gentille on 4/21/98
//
//Purpose: Determine if the passed line is an open or closed 4d control statement

//$1 - text -line to test
//
//Copyright 1998 Syncor Systems, Inc.
//  `Portions copyright 1997 Richard Ray- used with permission
//******************************************************************************
//Local Vars
C_TEXT:C284($1; $srchStr1; $srchStr2)
C_POINTER:C301($2; $paControlChars)
C_POINTER:C301($3; $paControlCommands)
C_LONGINT:C283($i; $lSizeOfCharArray; $lLengthSearchStr; $lTokenCharacter)

$srchStr2:=""
C_LONGINT:C283($where; $iAsciiVal)
$where:=0
$iAsciiVal:=0
//#============  Begin Method: SDA_XbD_Is_Control_Open  ============
//
$srchStr1:=$1
$paControlChars:=$2
$paControlCommands:=$3

//Find any open parentheses and create the substring up to the (
//to save time since the flow control chars always precede the (
$where:=Position:C15("("; $srchStr1)
//
If ($where>0)
	$srchStr1:=Substring:C12($srchStr1; 1; ($where-1))
End if   //If ($where>0)
//    
//Strip out any white space and verify that the character is consistent with 
//a valid flow of control command. If not do a quick exit.
$lTokenCharacter:=1
$lLengthSearchStr:=Length:C16($srchStr1)
$lSizeOfCharArray:=Size of array:C274($paControlChars->)

For ($i; 1; $lLengthSearchStr)
	$iAsciiVal:=Character code:C91($SrchStr1[[$i]])
	
	//Check in the array that tells us what are valid chars for each position    
	
	Case of 
		: ($iAsciiVal=NBSP ASCII CODE:K15:43)
		: ($iAsciiVal=Space:K15:42)
		: ($iAsciiVal=Tab:K15:37)
		: ($iAsciiVal=Carriage return:K15:38)
			
		: ($lTokenCharacter>$lSizeOfCharArray)
			$i:=$lLengthSearchStr  //force an exit
			
		: (Position:C15($SrchStr1[[$i]]; $paControlChars->{$lTokenCharacter})=0)
			$i:=$lLengthSearchStr  //force an exit
			
		Else 
			$lTokenCharacter:=$lTokenCharacter+1
			$srchStr2:=$srchSTr2+$SrchStr1[[$i]]
	End case   //Case of 
	
	
End for   //For ($i;1;$lLengthSearchStr)
//    
//Now look for the string in the array of Flow control tokens
$0:=(Find in array:C230($paControlCommands->; $srchStr2)>0)

