//%attributes = {}
//******************************************************************************
//Method: SDA_strt_NAMED_CONSTANTS
//Written by  Tod Gentille on 9/29/1998
//
//Purpose: Use IP vars instead of resources. Makes moving SDA from app to app
//easier than using resources (ESPECIALLY ON WINDOWS)
//If an non-English version is desired almost all literals are define here 
// 
//Copyright 1998 Syncor Systems, Inc.
//Modified by: Cyril Harnisch, Syncor Systems, 2/2/99
//Reason: added <>SDA_NEW_METHOD & <>SDA_EDIT_METHOD
// to be used in SDA_ImportMany
//******************************************************************************
_O_C_STRING:C293(1; $CR)
$CR:=Char:C90(Carriage return:K15:38)
C_LONGINT:C283($lPlatform)
C_BOOLEAN:C305(<>SDA_IN_WINDOWS)

_O_PLATFORM PROPERTIES:C365($lPlatform)
If ($lPlatform=Windows:K25:3)
	<>SDA_IN_WINDOWS:=True:C214
Else 
	<>SDA_IN_WINDOWS:=False:C215
End if 

C_LONGINT:C283(<>SDA_MAX_LIST_CHARS)
<>SDA_MAX_LIST_CHARS:=31  //This is how many chars we have in the current version of 4D hierarchical lists  

//-------------------------------ASCII KEYSTROKE CONSTANTS -----------------------
C_LONGINT:C283(<>SDA_ASCII_SELECT_ALL_KEY; <>SDA_ASCII_COPY_KEY; <>SDA_ASCII_CUT_KEY)
C_LONGINT:C283(<>SDA_ASCII_PASTE_KEY; <>SDA_ASCII_CLOSE_WINDOW_KEY; <>SDA_ASCII_UNDO_KEY)
C_LONGINT:C283(<>SDA_NEW_METHOD; <>SDA_EDIT_METHOD; <>SDA_DISMISS_EXPLORER)
<>SDA_ASCII_SELECT_ALL_KEY:=Character code:C91("a")
<>SDA_ASCII_COPY_KEY:=Character code:C91("c")
<>SDA_ASCII_CUT_KEY:=Character code:C91("x")
<>SDA_ASCII_PASTE_KEY:=Character code:C91("v")
<>SDA_ASCII_CLOSE_WINDOW_KEY:=Character code:C91("w")
<>SDA_ASCII_UNDO_KEY:=Character code:C91("z")
<>SDA_NEW_METHOD:=Character code:C91("m")
<>SDA_EDIT_METHOD:=Character code:C91("p")
<>SDA_DISMISS_EXPLORER:=F4 key:K12:4

C_LONGINT:C283(<>SDA_ASCII_NEW_METHOD_KEY; <>SDA_ASCII_FIND_KEY; <>SDA_ASCII_METHOD_TAB_KEY)
<>SDA_ASCII_NEW_METHOD_KEY:=Character code:C91("m")
<>SDA_ASCII_FIND_KEY:=Character code:C91("f")
<>SDA_ASCII_METHOD_TAB_KEY:=Character code:C91("p")

//-------------------------------Character Constants ---------------------------
C_TEXT:C284(<>SDA_COLON; <>SDA_HYPHEN; <>SDA_COMMENT_CHAR; <>SDA_CONTINUATION_CHAR; <>SDA_ASSIGNMENT)
<>SDA_COLON:=":"
<>SDA_HYPHEN:="-"
<>SDA_COMMENT_CHAR:="`"
<>SDA_COMMENT_CONTINUATION_CHAR:="~"  //the tilde
<>SDA_ASSIGNMENT:=":="
C_TEXT:C284(<>SDA_START_TABLE_CHAR; <>SDA_END_TABLE_CHAR)
<>SDA_START_TABLE_CHAR:="["
<>SDA_END_TABLE_CHAR:="]"

//-------------------------------TEXT CONSTANTS ---------------------------
C_TEXT:C284(<>SDA_COPY; <>SDA_CUT; <>SDA_PASTE)  //the parameters for the SDA_ClipboardOps
//also used by SDA_Clipboards to determine what choice was selected from popup.
<>SDA_COPY:="copy"
<>SDA_CUT:="cut"
<>SDA_PASTE:="paste"

C_TEXT:C284(<>SDA_CONTINUATION)
<>SDA_CONTINUATION:="..."

C_TEXT:C284(<>LINE_NUMBER_TOKEN)
<>SDA_LINE_NUMBER_TOKEN:="%SDA^"  //set up special characters which are not expected in normal

//Tool Operation Text Constants, Must match the values in the 4D List
//If you change the values in the list change the values here and all the code wil
C_TEXT:C284(<>SDA_MAXIMIZED_PALETTE; <>SDA_MINIMIZED_PALETTE)
<>SDA_MAXIMIZED_PALETTE:="Maximized"
<>SDA_MINIMIZED_PALETTE:="Minimized"
C_TEXT:C284(<>SDA_DISABLE_SHORTCUTS; <>SDA_ENABLE_SHORTCUTS)
<>SDA_DISABLE_SHORTCUTS:="Disable Shortcuts"
<>SDA_ENABLE_SHORTCUTS:="Enable Shortcuts"
C_TEXT:C284(<>SDA_INFO_ADD; <>SDA_INFO_REMOVE)
<>SDA_INFO_ADD:="Add Extra [ ] Popup Information"
<>SDA_INFO_REMOVE:="Remove Extra [ ] Popup Information"

//-------------------------------Transaction Values for SDA_BugAlert--------------
C_LONGINT:C283(<>SDA_UNEXPECTED_PARAM; <>SDA_METHOD_COPY_ERROR; <>SDA_ITEM_NOT_FOUND; <>SDA_REQUIRES_FILEPACK)
C_LONGINT:C283(<>SDA_GENERAL_ERROR; <>SDA_STRING_NOT_FOUND)
<>SDA_UNEXPECTED_PARAM:=1
<>SDA_METHOD_COPY_ERROR:=2
<>SDA_ITEM_NOT_FOUND:=3
<>SDA_REQUIRES_FILEPACK:=4
<>SDA_GENERAL_ERROR:=5
<>SDA_STRING_NOT_FOUND:=6
C_TEXT:C284(<>SDA_WINDOW_TOO_SMALL)
<>SDA_WINDOW_TOO_SMALL:="Main MDI Window is too small to bother tiling windows"

//-------------------------------Prompt or Popup Messages ------------------------
C_TEXT:C284(<>SDA_MSG_NO_CASE)
<>SDA_MSG_NO_CASE:="No case statements in this method."
C_TEXT:C284(<>SDA_CLOSE_PROMPT)
<>SDA_CLOSE_PROMPT:="Close method windows starting with"
C_TEXT:C284(<>SDA_OPEN_PROMPT)
<>SDA_OPEN_PROMPT:="Open method windows starting with"

C_TEXT:C284(<>SDA_MODULE_PREFIX_PROMPT)
<>SDA_MODULE_PREFIX_PROMPT:="Enter the module prefix"
C_TEXT:C284(<>SDA_FIRST_LETTER_PROMPT)
<>SDA_FIRST_LETTER_PROMPT:="Methods starting with what letter?"
C_TEXT:C284(<>SDA_HOW_MANY_METHODS_PROMPT)
<>SDA_HOW_MANY_PROMPT:="How many methods do you want to work with?"

C_TEXT:C284(<>SDA_STR_SEARCH_PROMPT; <>SDA_STR_SEARCH_CONFIRM; <>SDA_STR_SEARCH_RESULT)
<>SDA_STR_SEARCH_PROMPT:="Look for what in the string resources?"
<>SDA_STR_SEARCH_CONFIRM:="Do you wish to keep looking for this item ?"
<>SDA_STR_SEARCH_RESULT:="Found in Resource ID ^1 item number ^2"
C_TEXT:C284(<>SDA_SEL_EXPORT_FOLDER; <>SDA_SEL_IMPORT_FOLDER)
<>SDA_SEL_EXPORT_FOLDER:="Select the Export Folder:"
<>SDA_SEL_IMPORT_FOLDER:="Select the folder to import:"

C_TEXT:C284(<>SDA_REPLACE_ALL; <>SDA_REPLACE_SELECTION; <>SDA_REPLACE_OPEN_WIN; <>SDA_REPLACE_N_METHODS)
<>SDA_REPLACE_ALL:="Replace in entire method"
<>SDA_REPLACE_SELECTION:="Replace in current selection"
<>SDA_REPLACE_OPEN_WIN:="Replace in all open windows"
<>SDA_REPLACE_N_METHODS:="Replace in N next methods"

C_TEXT:C284(<>SDA_REPLACE_WIN_TITLE)
<>SDA_REPLACE_WIN_TITLE:="Replace All"

//------------------------------Paste Insert Strings -----------------------------
C_TEXT:C284(<>SDA_IF_CMD; <>SDA_FOR_CMD; <>SDA_CASE_CMD; <>SDA_REPEAT_CMD; <>SDA_WHILE_CMD)
<>SDA_IF_CMD:="If ()"+$CR+"Else"+$CR+"End If"+$CR
<>SDA_FOR_CMD:="For(;;)"+$CR+"End For"+$CR
<>SDA_CASE_CMD:="Case of"+$CR+":()"+$CR+"Else"+$CR+"End Case"+$CR
<>SDA_WHILE_CMD:="While ()"+$CR+"End While"+$CR
<>SDA_REPEAT_CMD:="Repeat"+$CR+"Until ()"+$CR

C_TEXT:C284(<>SDA_INVALID_CLIP_DATA)
<>SDA_INVALID_CLIP_DATA:="Unexpected Clipboard Data Type or Empty Clipboard"

//----------------------------Resource Editor text------------------------------
_O_C_STRING:C293(30; <>s30SDA_RES_EDTR_WINDW_NAME; <>s30SDA_RES_ELE_EDTR_WINDW_NAME)
_O_C_STRING:C293(30; <>s30SDA_NEW_RES_DEFAULT_NAME)
_O_C_STRING:C293(50; <>s50SDA_NEW_RES_ELEM_DEFAULT_NM)
<>s30SDA_RES_EDTR_WINDW_NAME:="Resource Editor"
<>s30SDA_RES_ELE_EDTR_WINDW_NAME:="Resource String Editor"
<>s30SDA_NEW_RES_DEFAULT_NAME:="New Resource"
<>s50SDA_NEW_RES_ELEM_DEFAULT_NM:="New Resource Element Name:Element Contents:S"

C_LONGINT:C283(<>lSDA_StartingResouceID_Range; <>lSDA_EndingResouceID_Range)
<>lSDA_StartingResouceID_Range:=15001  //lowest useable resource ID
<>lSDA_EndingResouceID_Range:=21999  //highest useable resource ID

//----------------------------Clipboard Preserve Toggle text----------------------
_O_C_STRING:C293(40; <>s40SDA_CLPBD_PRESERVE; <>s40SDA_CLPBD_NONPRESERVE)
<>s40SDA_CLPBD_PRESERVE:="Toggle Clipboard to Preserve"
<>s40SDA_CLPBD_NONPRESERVE:="Toggle Clipboard to Non-Preserve"
